/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.extensions;

import com.laytonsmith.PureUtilities.Common.ClassUtils;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.core.extensions.Extension;
import com.laytonsmith.core.extensions.MSExtension;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"com.laytonsmith.core.extensions.MSExtension"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public class ExtensionAnnotationProcessor
extends AbstractProcessor {
    int found = 0;

    private void error(String message, Element element) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message, element);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        boolean isExtensionWithLifecycleClass = false;
        for (Element element : roundEnv.getElementsAnnotatedWith(MSExtension.class)) {
            Class clazz;
            StreamUtils.GetSystemOut().println("Processing " + element);
            if (this.found > 0) {
                this.error("A given compile unit (IE, Jar file) may contain only ONE lifecycle class!", element);
                continue;
            }
            try {
                clazz = ExtensionAnnotationProcessor.getClassFromName(element.toString());
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(ExtensionAnnotationProcessor.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            Set<Modifier> modifiers = element.getModifiers();
            if (modifiers.contains((Object)Modifier.ABSTRACT)) {
                this.error("Lifecycle classes must not be declared abstract!", element);
                continue;
            }
            if (!modifiers.contains((Object)Modifier.PUBLIC)) {
                this.error("Lifecycle classes must be declared public!", element);
                continue;
            }
            if (clazz.isMemberClass() && !modifiers.contains((Object)Modifier.STATIC)) {
                this.error("Lifecycle class must be declared static when wrapped by an outer class!", element);
                continue;
            }
            if (!Extension.class.isAssignableFrom(clazz)) {
                this.error("Lifecycle class must extend AbstractExtension!", element);
                continue;
            }
            MSExtension annotation = null;
            for (Annotation a : clazz.getAnnotations()) {
                if (!(a instanceof MSExtension)) continue;
                annotation = (MSExtension)a;
            }
            if (annotation == null) {
                this.error("Lifecycle class must be annotated with MSExtension!", element);
                continue;
            }
            ++this.found;
            StreamUtils.GetSystemOut().println("Extension '" + annotation.value() + "' checks out ok!");
            isExtensionWithLifecycleClass = true;
        }
        return isExtensionWithLifecycleClass;
    }

    private static Class getClassFromName(String className) throws ClassNotFoundException {
        return ClassUtils.forCanonicalName(className, false, ExtensionAnnotationProcessor.class.getClassLoader());
    }
}

