/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.objects;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.core.Documentation;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.Method;
import com.laytonsmith.core.Script;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.core.objects.AccessModifier;
import com.laytonsmith.core.objects.ElementDefinition;
import com.laytonsmith.core.objects.ObjectDefinition;
import com.laytonsmith.core.objects.ObjectModifier;
import com.laytonsmith.core.objects.ObjectType;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UserObject
implements Mixed {
    private static int objectIdCounter = 0;
    private final Environment env;
    private final Target t;
    private final ObjectDefinition objectDefinition;
    private final Map<String, Mixed> fieldTable;
    private final Mixed nativeObject;
    private final int objectId;

    public UserObject(Target t, Script parent, Environment env, ObjectDefinition objectDefinition, Mixed nativeObject) {
        this.t = t;
        this.env = env;
        this.objectDefinition = objectDefinition;
        this.nativeObject = nativeObject;
        this.objectId = objectIdCounter++;
        this.fieldTable = new HashMap<String, Mixed>();
        for (Map.Entry<String, List<ElementDefinition>> e : objectDefinition.getElements().entrySet()) {
            ElementDefinition ed;
            if (e.getValue().size() > 1 || (ed = e.getValue().get(0)).getMethod() != null) continue;
            if (parent == null) {
                this.fieldTable.put(e.getKey(), CNull.UNDEFINED);
                continue;
            }
            Mixed value = parent.eval(ed.getDefaultValue(), env);
            this.fieldTable.put(e.getKey(), value);
        }
    }

    @Override
    public String val() {
        List<ElementDefinition> toStrings = this.objectDefinition.getElements().get("toString");
        if (toStrings != null) {
            for (ElementDefinition ed : toStrings) {
                Method m = ed.getMethod();
                if (m == null || m.getParameters().length != 0) continue;
                return m.executeCallable(this.env, this.t, new Mixed[0]).val();
            }
        }
        return this.objectDefinition.getClassName() + "@" + String.format("0x%X", this.objectId);
    }

    @Override
    public void setTarget(Target target) {
    }

    @Override
    public Target getTarget() {
        return this.t;
    }

    @Override
    public Mixed clone() throws CloneNotSupportedException {
        throw new UnsupportedOperationException("UserObject clone");
    }

    @Override
    public String getName() {
        return this.objectDefinition.getName();
    }

    @Override
    public String docs() {
        return "TODO";
    }

    @Override
    public Version since() {
        return MSVersion.V0_0_0;
    }

    @Override
    public CClassType[] getSuperclasses() {
        return this.objectDefinition.getSuperclasses().toArray(new CClassType[this.objectDefinition.getSuperclasses().size()]);
    }

    @Override
    public CClassType[] getInterfaces() {
        return this.objectDefinition.getInterfaces().toArray(new CClassType[this.objectDefinition.getInterfaces().size()]);
    }

    @Override
    public ObjectType getObjectType() {
        return this.objectDefinition.getObjectType();
    }

    @Override
    public Set<ObjectModifier> getObjectModifiers() {
        return this.objectDefinition.getObjectModifiers();
    }

    @Override
    public AccessModifier getAccessModifier() {
        return this.objectDefinition.getAccessModifier();
    }

    @Override
    public CClassType getContainingClass() {
        return this.objectDefinition.getContainingClass();
    }

    @Override
    public boolean isInstanceOf(CClassType type) throws ClassNotFoundException {
        return Construct.isInstanceof((Mixed)this, type);
    }

    @Override
    public boolean isInstanceOf(Class<? extends Mixed> type) {
        return Construct.isInstanceof((Mixed)this, type);
    }

    @Override
    public CClassType typeof() {
        return this.objectDefinition.getType();
    }

    @Override
    public URL getSourceJar() {
        return null;
    }

    @Override
    public Class<? extends Documentation>[] seeAlso() {
        return new Class[0];
    }

    public <T extends Mixed> T getNativeObject(Class<T> type) {
        return (T)this.nativeObject;
    }
}

