/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.persistence;

import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.DaemonManager;
import com.laytonsmith.annotations.datasource;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.persistence.DataSourceException;
import com.laytonsmith.persistence.ReadOnlyException;
import com.laytonsmith.persistence.SQLDataSource;
import com.laytonsmith.persistence.io.ConnectionMixinFactory;
import com.mysql.cj.jdbc.Driver;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

@datasource(value="mysql")
public class MySQLDataSource
extends SQLDataSource {
    private static final String KEY_HASH_COLUMN = "key_hash";
    private String host;
    private int port;
    private String username;
    private String password;
    private String database;
    private String table;

    private MySQLDataSource() {
    }

    public MySQLDataSource(URI uri, ConnectionMixinFactory.ConnectionMixinOptions options) throws DataSourceException {
        super(uri, options);
        String[] split2;
        try {
            Class.forName(Driver.class.getName());
        }
        catch (ClassNotFoundException ex) {
            throw new DataSourceException("Could not instantiate a MySQL data source, no driver appears to exist.", ex);
        }
        this.host = uri.getHost();
        if (this.host == null) {
            throw new DataSourceException("Invalid URI specified for data source \"" + uri.toString() + "\"");
        }
        this.port = uri.getPort();
        if (this.port < 0) {
            this.port = 3306;
        }
        if (uri.getUserInfo() != null) {
            split2 = uri.getUserInfo().split(":");
            this.username = split2[0];
            if (split2.length > 1) {
                this.password = split2[1];
            }
        }
        if (uri.getPath().split("/").length != 3 || !uri.getPath().startsWith("/")) {
            throw new DataSourceException("Invalid path information for mysql connection \"" + uri.toString() + "\". Path requires a database name and a table name, for instance \"/testDatabase/tableName");
        }
        split2 = uri.getPath().split("/");
        this.database = split2[1];
        this.table = split2[2];
        this.table = this.table.replace("`", "``");
        try {
            this.connect();
            try (Statement statement = this.getConnection().createStatement();){
                statement.executeUpdate(this.getTableCreationQuery(this.table));
            }
        }
        catch (IOException | SQLException ex) {
            throw new DataSourceException("Could not connect to MySQL data source \"" + uri.toString() + "\": " + ex.getMessage(), ex);
        }
    }

    public final String getTableCreationQuery(String table) {
        return "CREATE TABLE IF NOT EXISTS `" + table + "` (\n -- This is an UNHEX(MD5('key')) binary hash of the unlimited\n -- length key column, so the table may have a primary key.\n `" + KEY_HASH_COLUMN + "` BINARY(16) PRIMARY KEY NOT NULL,\n -- This is the key itself, stored for plaintext readability,\n -- and for full text searches for getting values\n `" + this.getKeyColumn() + "` TEXT NOT NULL,\n -- The value itself, which may be null\n `" + this.getValueColumn() + "` MEDIUMTEXT\n)\n -- The engine is InnoDB, to support transactions\nENGINE = InnoDB,\n -- The charset is utf8, since all keys are utf8, and values are utf8 json\nCHARACTER SET = utf8,\n -- The collation is case sensitive\nCOLLATE = utf8_bin,\n -- Table comment\nCOMMENT = 'MethodScript storage table'\n;";
    }

    @Override
    protected String getConnectionString() {
        try {
            return "jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database + "?generateSimpleParameterMetadata=true&jdbcCompliantTruncation=false" + (this.username == null ? "" : "&user=" + URLEncoder.encode(this.username, "UTF-8")) + (this.password == null ? "" : "&password=" + URLEncoder.encode(this.password, "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error(ex);
        }
    }

    @Override
    public String get0(String[] key) throws DataSourceException {
        try {
            String ret;
            this.connect();
            try (PreparedStatement statement = this.getConnection().prepareStatement("SELECT `" + this.getValueColumn() + "` FROM `" + this.getEscapedTable() + "` WHERE `" + KEY_HASH_COLUMN + "`=UNHEX(MD5(?)) LIMIT 1");){
                String joinedKey = StringUtils.Join(key, ".");
                statement.setString(1, joinedKey);
                ret = null;
                try (ResultSet result = statement.executeQuery();){
                    if (result.next()) {
                        ret = result.getString(this.getValueColumn());
                    }
                }
            }
            this.updateLastConnected();
            return ret;
        }
        catch (IOException | SQLException ex) {
            throw new DataSourceException(ex.getMessage(), ex);
        }
    }

    @Override
    public boolean set0(DaemonManager dm, String[] key, String value) throws ReadOnlyException, DataSourceException, IOException {
        try {
            this.connect();
            if (value == null) {
                this.clearKey0(dm, key);
            } else {
                try (PreparedStatement statement = this.getConnection().prepareStatement("REPLACE INTO `" + this.getEscapedTable() + "` (`" + KEY_HASH_COLUMN + "`, `" + this.getKeyColumn() + "`, `" + this.getValueColumn() + "`) VALUES (UNHEX(MD5(?)), ?, ?)");){
                    String joinedKey = StringUtils.Join(key, ".");
                    statement.setString(1, joinedKey);
                    statement.setString(2, joinedKey);
                    statement.setString(3, value);
                    statement.executeUpdate();
                }
            }
            this.updateLastConnected();
            return true;
        }
        catch (SQLException ex) {
            throw new DataSourceException(ex.getMessage(), ex);
        }
    }

    @Override
    protected void clearKey0(DaemonManager dm, String[] key) throws ReadOnlyException, DataSourceException, IOException {
        if (this.hasKey(key)) {
            try {
                this.connect();
                try (PreparedStatement statement = this.getConnection().prepareStatement("DELETE FROM `" + this.getEscapedTable() + "` WHERE `" + KEY_HASH_COLUMN + "`=UNHEX(MD5(?))");){
                    String joinedKey = StringUtils.Join(key, ".");
                    statement.setString(1, joinedKey);
                    statement.executeUpdate();
                }
                this.updateLastConnected();
            }
            catch (Exception e) {
                throw new DataSourceException(e.getMessage(), e);
            }
        }
    }

    @Override
    public String docs() {
        return "MySQL {mysql://[user[:password]@]host[:port]/database/table} This type stores data in a MySQL database. Unlike the file based systems, this is extremely efficient, but requires a database connection already set up to work. This also always allows for simultaneous connections from multiple data sink/sources at once, which is not possible without the potential for corruption in file based data sources, without risking either data corruption, or extremely low efficiency. The layout of the table in the database is required to be of a specific format: <%SYNTAX|sql|" + this.getTableCreationQuery("testTable") + "%>";
    }

    @Override
    public MSVersion since() {
        return MSVersion.V3_3_1;
    }

    @Override
    protected void startTransaction0(DaemonManager dm) {
        try (Statement statement = this.getConnection().createStatement();){
            statement.execute("START TRANSACTION");
        }
        catch (SQLException ex) {
            Logger.getLogger(MySQLDataSource.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    protected void stopTransaction0(DaemonManager dm, boolean rollback) throws DataSourceException, IOException {
        try {
            if (rollback) {
                try (PreparedStatement statement = this.getConnection().prepareStatement("ROLLBACK");){
                    statement.execute();
                }
            }
            try (PreparedStatement statement = this.getConnection().prepareStatement("COMMIT");){
                statement.execute();
            }
            this.updateLastConnected();
        }
        catch (SQLException ex) {
            Logger.getLogger(MySQLDataSource.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    protected String getTable() {
        return this.table;
    }
}

