/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.Common;

import java.util.AbstractList;
import java.util.List;

public class Range {
    private final int leftBound;
    private final int rightBound;
    private final boolean leftInclusive;
    private final boolean rightInclusive;

    public Range(int leftBound, int rightBound, boolean leftInclusive, boolean rightInclusive) {
        this.leftBound = leftBound;
        this.rightBound = rightBound;
        this.leftInclusive = leftInclusive;
        this.rightInclusive = rightInclusive;
    }

    public Range(int leftBound, int rightBound) {
        this(leftBound, rightBound, true, true);
    }

    public boolean isEqual() {
        return this.leftBound == this.rightBound;
    }

    public boolean isAscending() {
        return this.leftBound < this.rightBound;
    }

    public boolean isDecending() {
        return this.rightBound < this.leftBound;
    }

    public List<Integer> getRange() {
        double size = Math.abs(this.leftBound - this.rightBound);
        if (!this.leftInclusive) {
            size -= 1.0;
        }
        if (this.rightInclusive) {
            size += 1.0;
        }
        final int finalSize = (int)size;
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                if (Range.this.isAscending()) {
                    return Range.this.leftBound + index + (Range.this.leftInclusive ? 0 : 1);
                }
                return Range.this.leftBound - index - (Range.this.leftInclusive ? 0 : 1);
            }

            @Override
            public int size() {
                return finalSize;
            }
        };
    }

    public int getMin() {
        if (this.isAscending()) {
            if (this.leftInclusive) {
                return this.leftBound;
            }
            return this.leftBound + 1;
        }
        if (this.isDecending()) {
            if (this.rightInclusive) {
                return this.rightBound;
            }
            return this.rightBound + 1;
        }
        return this.leftBound;
    }

    public int getMax() {
        if (this.isDecending()) {
            if (this.leftInclusive) {
                return this.leftBound;
            }
            return this.leftBound - 1;
        }
        if (this.isAscending()) {
            if (this.rightInclusive) {
                return this.rightBound;
            }
            return this.rightBound - 1;
        }
        return this.leftBound;
    }

    public boolean contains(int value) {
        return value >= this.getMin() && value <= this.getMax();
    }

    public String toString() {
        return (this.leftInclusive ? "[" : "(") + this.leftBound + ", " + this.rightBound + (this.rightInclusive ? "]" : ")");
    }
}

