/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.Common;

import com.laytonsmith.PureUtilities.Common.OSUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtils {
    public static final String NL;
    @Deprecated
    public static final String nl;

    private StringUtils() {
    }

    public static String Join(Map map, String entryGlue, String elementGlue) {
        return StringUtils.Join(map, entryGlue, elementGlue, null, null, null);
    }

    public static String Join(Map map, String entryGlue, String elementGlue, String lastElementGlue) {
        return StringUtils.Join(map, entryGlue, elementGlue, lastElementGlue, null, null);
    }

    public static String Join(Map map, String entryGlue, String elementGlue, String lastElementGlue, String elementGlueForTwoItems) {
        return StringUtils.Join(map, entryGlue, elementGlue, lastElementGlue, elementGlueForTwoItems, null);
    }

    public static String Join(Map map, String entryGlue, String elementGlue, String lastElementGlue, String elementGlueForTwoItems, String empty) {
        ArrayList<String> list = new ArrayList<String>();
        for (Object key : map.keySet()) {
            StringBuilder b = new StringBuilder();
            b.append(key).append(entryGlue).append(map.get(key));
            list.add(b.toString());
        }
        return StringUtils.Join(list, elementGlue, lastElementGlue, elementGlueForTwoItems, empty);
    }

    public static <T> String Join(Set<T> set, String glue) {
        return StringUtils.Join(set, glue, null, null, null);
    }

    public static <T> String Join(Set<T> set, String glue, Renderer<T> r) {
        return StringUtils.Join(set, glue, null, null, null, r);
    }

    public static String Join(Set set, String glue, String lastGlue) {
        return StringUtils.Join(set, glue, lastGlue, null, null);
    }

    public static String Join(Set set, String glue, String lastGlue, String glueForTwoItems) {
        return StringUtils.Join(set, glue, lastGlue, glueForTwoItems, null);
    }

    public static <T> String Join(Set<T> set, String glue, String lastGlue, String glueForTwoItems, String empty) {
        return StringUtils.Join(set, glue, lastGlue, glueForTwoItems, empty, null);
    }

    public static <T> String Join(Set<T> set, String glue, String lastGlue, String glueForTwoItems, String empty, Renderer<T> renderer) {
        final ArrayList<T> list = new ArrayList<T>(set);
        return StringUtils.doJoin(new ItemGetter<T>(){

            @Override
            public T get(int index) {
                return list.get(index);
            }

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public boolean isEmpty() {
                return list.isEmpty();
            }
        }, glue, lastGlue, glueForTwoItems, empty, renderer);
    }

    public static String Join(Object[] list, String glue) {
        return StringUtils.Join(list, glue, null, null, null);
    }

    public static String Join(Object[] list, String glue, String lastGlue) {
        return StringUtils.Join(list, glue, lastGlue, null, null);
    }

    public static String Join(Object[] list, String glue, String lastGlue, String glueForTwoItems) {
        return StringUtils.Join(list, glue, lastGlue, glueForTwoItems, null);
    }

    public static String Join(Object[] list, String glue, String lastGlue, String glueForTwoItems, String empty) {
        return StringUtils.Join(list, glue, lastGlue, glueForTwoItems, empty, null);
    }

    public static <T> String Join(final T[] list, String glue, String lastGlue, String glueForTwoItems, String empty, Renderer<T> renderer) {
        return StringUtils.doJoin(new ItemGetter<T>(){

            @Override
            public T get(int index) {
                return list[index];
            }

            @Override
            public int size() {
                return list.length;
            }

            @Override
            public boolean isEmpty() {
                return list.length == 0;
            }
        }, glue, lastGlue, glueForTwoItems, empty, renderer);
    }

    public static String Join(List list, String glue) {
        return StringUtils.Join(list, glue, null, null, null);
    }

    public static String Join(List list, String glue, String lastGlue) {
        return StringUtils.Join(list, glue, lastGlue, null, null);
    }

    public static String Join(List list, String glue, String lastGlue, String glueForTwoItems) {
        return StringUtils.Join(list, glue, lastGlue, glueForTwoItems, null);
    }

    public static String Join(List list, String glue, String lastGlue, String glueForTwoItems, String empty) {
        return StringUtils.Join(list, glue, lastGlue, glueForTwoItems, empty, null);
    }

    public static <T> String Join(final List<T> list, String glue, String lastGlue, String glueForTwoItems, String empty, Renderer<T> renderer) {
        return StringUtils.doJoin(new ItemGetter<T>(){

            @Override
            public T get(int index) {
                return list.get(index);
            }

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public boolean isEmpty() {
                return list.isEmpty();
            }
        }, glue, lastGlue, glueForTwoItems, empty, renderer);
    }

    private static <T> String doJoin(ItemGetter<T> items, String glue, String lastGlue, String glueForTwoItems, String empty, Renderer<T> renderer) {
        if (renderer == null) {
            renderer = new Renderer<T>(){

                @Override
                public String toString(T item) {
                    if (item == null) {
                        return "null";
                    }
                    return item.toString();
                }
            };
        }
        if (lastGlue == null) {
            lastGlue = glue;
        }
        if (glueForTwoItems == null) {
            glueForTwoItems = lastGlue;
        }
        if (items.isEmpty()) {
            return empty == null ? "" : empty;
        }
        if (items.size() == 2) {
            StringBuilder b = new StringBuilder();
            return b.append(renderer.toString(items.get(0))).append(glueForTwoItems).append(renderer.toString(items.get(1))).toString();
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < items.size(); ++i) {
            T o = items.get(i);
            if (i != 0) {
                if (i == items.size() - 1) {
                    b.append(lastGlue);
                } else {
                    b.append(glue);
                }
            }
            b.append(renderer.toString(o));
        }
        return b.toString();
    }

    private static int minimum(int a, int b, int c) {
        return Math.min(Math.min(a, b), c);
    }

    public static int LevenshteinDistance(CharSequence str1, CharSequence str2) {
        int i;
        int[][] distance2 = new int[str1.length() + 1][str2.length() + 1];
        for (i = 0; i <= str1.length(); ++i) {
            distance2[i][0] = i;
        }
        for (int j = 0; j <= str2.length(); ++j) {
            distance2[0][j] = j;
        }
        for (i = 1; i <= str1.length(); ++i) {
            for (int j = 1; j <= str2.length(); ++j) {
                distance2[i][j] = StringUtils.minimum(distance2[i - 1][j] + 1, distance2[i][j - 1] + 1, distance2[i - 1][j - 1] + (str1.charAt(i - 1) == str2.charAt(j - 1) ? 0 : 1));
            }
        }
        return distance2[str1.length()][str2.length()];
    }

    /*
     * Unable to fully structure code
     */
    public static List<String> ArgParser(String args) {
        arguments = new ArrayList<String>();
        buf = new StringBuilder();
        escape = '\u0000';
        quote = '\u0000';
        wasQuote = false;
        block4: for (i = 0; i < args.length(); ++i) {
            block14: {
                ch = args.charAt(i);
                ch2 = '\u0000';
                if (args.length() > i + 1) {
                    ch2 = args.charAt(i + 1);
                }
                if (quote == '\u0000') break block14;
                if (escape != '\u0000') {
                    if (ch == quote) {
                        buf.append(ch);
                    } else {
                        buf.append(escape);
                        buf.append(quote);
                    }
                    escape = '\u0000';
                    continue;
                }
                if (ch == quote) {
                    quote = '\u0000';
                    wasQuote = true;
                    continue;
                }
                ** GOTO lbl-1000
            }
            if (escape != '\u0000') {
                buf.append(ch);
                escape = '\u0000';
                continue;
            }
            switch (ch) {
                case ' ': {
                    if (!wasQuote && buf.length() == 0) continue block4;
                    arguments.add(buf.toString());
                    buf = new StringBuilder();
                    wasQuote = false;
                    continue block4;
                }
                case '\"': 
                case '\'': {
                    quote = ch;
                    continue block4;
                }
                default: lbl-1000:
                // 2 sources

                {
                    if (ch == '\\' && ch2 == quote) {
                        buf.append(ch2);
                        ++i;
                        continue block4;
                    }
                    buf.append(ch);
                }
            }
        }
        if (escape != '\u0000') {
            buf.append(escape);
        }
        if (wasQuote || buf.length() != 0) {
            arguments.add(buf.toString());
        }
        return arguments;
    }

    public static String trimLeft(String str) {
        if (str == null) {
            return "";
        }
        int len = 0;
        while (str.charAt(len) == ' ') {
            ++len;
        }
        return str.substring(len);
    }

    public static String trimRight(String str) {
        int len;
        if (str == null) {
            return "";
        }
        for (len = str.length(); len > 0 && str.charAt(len - 1) == ' '; --len) {
        }
        str = str.substring(0, len);
        return str;
    }

    public static String[] trimSplit(String string, String regex) {
        String[] split2 = string.split(regex);
        for (int i = 0; i < split2.length; ++i) {
            split2[i] = split2[i].trim();
        }
        return split2;
    }

    public static String replaceLast(String string, String regex, String replacement) {
        if (regex == null) {
            return string;
        }
        if (string == null) {
            return null;
        }
        if (regex.length() > string.length()) {
            return string;
        }
        Matcher m = Pattern.compile(regex).matcher(string);
        int start = -1;
        int end = -1;
        while (m.find()) {
            start = m.start();
            end = m.end();
        }
        if (start == -1 || end == -1) {
            return string;
        }
        return string.substring(0, start) + replacement + string.substring(end, string.length());
    }

    public static String HumanReadableByteCount(long bytes) {
        return StringUtils.HumanReadableByteCount(bytes, true);
    }

    public static String HumanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static String PluralHelper(int count, String singular) {
        return StringUtils.PluralHelper(count, singular, singular + "s");
    }

    public static String PluralHelper(int count, String singular, String plural) {
        return (count == 1 ? "is" : "are") + " " + count + " " + (count == 1 ? singular : plural);
    }

    public static String PluralTemplateHelper(int count, String singularTemplate, String pluralTemplate) {
        if (count == 1) {
            return String.format(singularTemplate, count);
        }
        return String.format(pluralTemplate, count);
    }

    public static String nl() {
        return NL;
    }

    public static String stringMultiply(int count, CharSequence s) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be greater than or equal to 0");
        }
        if (count == 0) {
            return "";
        }
        if (count == 1) {
            return s.toString();
        }
        StringBuilder b = new StringBuilder(s.length() * count);
        for (int i = 0; i < count; ++i) {
            b.append(s);
        }
        return b.toString();
    }

    public static String toCodeString(String s) {
        return "\"" + s.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\t", "\\t") + "\"";
    }

    public static String toHex(byte[] bytes) {
        BigInteger bi = new BigInteger(1, bytes);
        return String.format("%0" + (bytes.length << 1) + "X", bi);
    }

    public static List<String> lineSplit(String text, int len) {
        if (text == null) {
            return new ArrayList<String>();
        }
        if (len <= 0 || text.length() <= len) {
            return new ArrayList<String>(Arrays.asList(text));
        }
        char[] chars = text.toCharArray();
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder line = new StringBuilder();
        StringBuilder word = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            word.append(chars[i]);
            if (chars[i] != ' ') continue;
            if (line.length() + word.length() > len) {
                lines.add(line.toString());
                line.delete(0, line.length());
            }
            line.append((CharSequence)word);
            word.delete(0, word.length());
        }
        if (word.length() > 0) {
            if (line.length() + word.length() > len) {
                lines.add(line.toString());
                line.delete(0, line.length());
            }
            line.append((CharSequence)word);
        }
        if (line.length() > 0) {
            lines.add(line.toString());
        }
        return lines;
    }

    public static String lineWrap(String str, int wrapLength) {
        return StringUtils.lineWrap(str, wrapLength, "\n", true);
    }

    public static String lineWrap(String str, int wrapLength, String newLineStr, boolean wrapLongWords) {
        if (str == null) {
            return null;
        }
        if (newLineStr == null) {
            newLineStr = OSUtils.GetLineEnding();
        }
        if (wrapLength < 1) {
            wrapLength = 1;
        }
        int inputLineLength = str.length();
        int offset = 0;
        StringBuilder wrappedLine = new StringBuilder(inputLineLength + 32);
        while (inputLineLength - offset > wrapLength) {
            if (str.charAt(offset) == ' ') {
                ++offset;
                continue;
            }
            int spaceToWrapAt = str.lastIndexOf(32, wrapLength + offset);
            if (spaceToWrapAt >= offset) {
                wrappedLine.append(str.substring(offset, spaceToWrapAt));
                wrappedLine.append(newLineStr);
                offset = spaceToWrapAt + 1;
                continue;
            }
            if (wrapLongWords) {
                wrappedLine.append(str.substring(offset, wrapLength + offset));
                wrappedLine.append(newLineStr);
                offset += wrapLength;
                continue;
            }
            spaceToWrapAt = str.indexOf(32, wrapLength + offset);
            if (spaceToWrapAt >= 0) {
                wrappedLine.append(str.substring(offset, spaceToWrapAt));
                wrappedLine.append(newLineStr);
                offset = spaceToWrapAt + 1;
                continue;
            }
            wrappedLine.append(str.substring(offset));
            offset = inputLineLength;
        }
        wrappedLine.append(str.substring(offset));
        return wrappedLine.toString();
    }

    public static boolean containsIgnoreCase(String container, String contains) {
        return container.toLowerCase().contains(contains.toLowerCase());
    }

    static {
        nl = NL = System.getProperty("line.separator");
    }

    public static interface Renderer<T> {
        public String toString(T var1);
    }

    private static interface ItemGetter<T> {
        public T get(int var1);

        public int size();

        public boolean isEmpty();
    }
}

