/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities;

import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.DaemonManager;
import com.laytonsmith.PureUtilities.ExecutionQueue;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ExecutionQueueImpl
implements ExecutionQueue {
    private ExecutorService service;
    private static int threadCount = 0;
    private Map<String, Deque<Runnable>> queues;
    private final Map<String, Object> locks;
    private Map<String, Boolean> runningQueues;
    private String defaultQueueName;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler = null;
    private ThreadFactory threadFactory;

    public ExecutionQueueImpl(String threadPrefix, String defaultQueueName) {
        this(threadPrefix, defaultQueueName, null);
    }

    public ExecutionQueueImpl(final String threadPrefix, String defaultQueueName, Thread.UncaughtExceptionHandler exceptionHandler) {
        if (threadPrefix == null || defaultQueueName == null) {
            throw new NullPointerException();
        }
        this.uncaughtExceptionHandler = exceptionHandler;
        this.threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, threadPrefix + "-" + ++threadCount);
                t.setDaemon(false);
                return t;
            }
        };
        this.queues = new HashMap<String, Deque<Runnable>>();
        this.defaultQueueName = defaultQueueName;
        this.locks = new HashMap<String, Object>();
        this.runningQueues = new HashMap<String, Boolean>();
    }

    @Override
    public final void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
        this.uncaughtExceptionHandler = exceptionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void push(DaemonManager dm, String queue, Runnable r) {
        queue = this.prepareLock(queue);
        Object object = this.locks.get(queue);
        synchronized (object) {
            Deque<Runnable> q = this.prepareQueue(queue);
            q.addLast(r);
            this.startQueue(dm, queue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void pushFront(DaemonManager dm, String queue, Runnable r) {
        queue = this.prepareLock(queue);
        Object object = this.locks.get(queue);
        synchronized (object) {
            Deque<Runnable> q = this.prepareQueue(queue);
            q.addFirst(r);
            this.startQueue(dm, queue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void remove(String queue) {
        queue = this.prepareLock(queue);
        Object object = this.locks.get(queue);
        synchronized (object) {
            Deque<Runnable> q = this.prepareQueue(queue);
            try {
                q.removeLast();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    @Override
    public final void removeFront(String queue) {
        try {
            this.pop(queue);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clear(String queue) {
        queue = this.prepareLock(queue);
        Object object = this.locks.get(queue);
        synchronized (object) {
            this.prepareQueue(queue).clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isRunning(String queue) {
        queue = this.prepareLock(queue);
        Object object = this.locks.get(queue);
        synchronized (object) {
            return this.runningQueues.containsKey(queue) && this.runningQueues.get(queue).equals(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<String> activeQueues() {
        ArrayList<String> q = new ArrayList<String>();
        for (String queue : this.queues.keySet()) {
            Object object = this.locks.get(queue);
            synchronized (object) {
                if (this.queues.containsKey(queue) && !this.queues.get(queue).isEmpty()) {
                    q.add(queue);
                }
            }
        }
        return q;
    }

    private Deque<Runnable> prepareQueue(String queueName) {
        if (!this.queues.containsKey(queueName)) {
            this.queues.put(queueName, new ArrayDeque());
        }
        return this.queues.get(queueName);
    }

    private String prepareLock(String queueName) {
        if (queueName == null) {
            queueName = this.defaultQueueName;
        }
        if (!this.locks.containsKey(queueName)) {
            this.locks.put(queueName, new Object());
        }
        return queueName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyQueue(String queueName) {
        Object object = this.locks.get(queueName);
        synchronized (object) {
            this.queues.remove(queueName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pumpQueue(String queueName) {
        while (true) {
            Runnable r;
            Object object = this.locks.get(queueName);
            synchronized (object) {
                r = this.pop(queueName);
            }
            r.run();
            object = this.locks.get(queueName);
            synchronized (object) {
                if (this.queues.get(queueName).isEmpty()) {
                    this.runningQueues.put(queueName, false);
                    this.destroyQueue(queueName);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void startQueue(final DaemonManager dm, final String queue) {
        Object object = this.locks.get(queue);
        synchronized (object) {
            if (!this.isRunning(queue)) {
                this.runningQueues.put(queue, true);
                if (dm != null) {
                    dm.activateThread(null);
                }
                if (this.service == null) {
                    this.service = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 50L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), this.threadFactory);
                }
                this.service.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ExecutionQueueImpl.this.pumpQueue(queue);
                        }
                        catch (RuntimeException t) {
                            if (ExecutionQueueImpl.this.uncaughtExceptionHandler != null) {
                                ExecutionQueueImpl.this.uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), t);
                            } else {
                                StreamUtils.GetSystemErr().println("The queue \"" + queue + "\" threw an exception, and it was not handled.");
                                t.printStackTrace(StreamUtils.GetSystemErr());
                            }
                        }
                        finally {
                            if (dm != null) {
                                dm.deactivateThread(null);
                            }
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Runnable pop(String queue) throws NoSuchElementException {
        queue = this.prepareLock(queue);
        Object object = this.locks.get(queue);
        synchronized (object) {
            Deque<Runnable> q = this.queues.get(queue);
            if (q == null) {
                throw new NoSuchElementException("The given queue does not exist.");
            }
            return q.removeFirst();
        }
    }

    @Override
    public synchronized void stopAllNow() {
        if (this.service != null) {
            this.service.shutdownNow();
            this.service = null;
        }
    }

    @Override
    public synchronized void stopAll() {
        this.service.shutdown();
        this.service = null;
    }
}

