/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities;

import com.laytonsmith.PureUtilities.Common.FileUtil;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Preferences {
    private final Map<String, Preference> prefs = new HashMap<String, Preference>();
    private final String appName;
    private final Logger logger;
    private File prefFile;
    private String header = "";
    private int lineLength = 120;

    public Preferences(String appName, Logger logger, List<Preference> defaults, String header) {
        this.appName = appName;
        this.logger = logger;
        for (Preference p2 : defaults) {
            this.prefs.put(p2.name, p2);
        }
        if (!header.trim().isEmpty()) {
            this.header = "#  " + header.replaceAll("\n", "\n#  ");
        }
    }

    public Preferences(String appName, Logger logger, List<Preference> defaults) {
        this(appName, logger, defaults, "");
    }

    public void init(File prefFile) throws IOException {
        this.prefFile = prefFile;
        if (prefFile != null && prefFile.exists()) {
            Properties userProperties = new Properties();
            FileInputStream in = new FileInputStream(prefFile);
            userProperties.load(in);
            in.close();
            for (String key : userProperties.stringPropertyNames()) {
                String val = userProperties.getProperty(key);
                String value = Objects.toString(this.getObject(val, this.prefs.get(key)), null);
                Object ovalue = this.getObject(val, this.prefs.get(key));
                Preference p1 = this.prefs.get(key);
                Preference p2 = p1 != null ? new Preference(p1.name, value, p1.allowed, p1.description) : new Preference(key, val, Type.STRING, "");
                p2.objectValue = ovalue;
                this.prefs.put(key, p2);
            }
        }
        this.save();
    }

    private Object getObject(String value, Preference p2) {
        if (p2 == null) {
            return value;
        }
        if ("null".equalsIgnoreCase(value)) {
            return this.getObject(p2.value, p2);
        }
        switch (p2.allowed) {
            case INT: {
                try {
                    return Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    this.logger.log(Level.WARNING, "[" + this.appName + "] expects the value of " + p2.name + " to be an integer. Using the default of " + p2.value);
                    return Integer.parseInt(p2.value);
                }
            }
            case DOUBLE: {
                try {
                    return Double.parseDouble(value);
                }
                catch (NumberFormatException e) {
                    this.logger.log(Level.WARNING, "[" + this.appName + "] expects the value of " + p2.name + " to be an double. Using the default of " + p2.value);
                    return Double.parseDouble(p2.value);
                }
            }
            case BOOLEAN: {
                try {
                    return this.getBoolean(value);
                }
                catch (NumberFormatException e) {
                    this.logger.log(Level.WARNING, "[" + this.appName + "] expects the value of " + p2.name + " to be an boolean. Using the default of " + p2.value);
                    return this.getBoolean(p2.value);
                }
            }
            case NUMBER: {
                try {
                    return Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    try {
                        return Double.parseDouble(value);
                    }
                    catch (NumberFormatException f) {
                        this.logger.log(Level.WARNING, "[" + this.appName + "] expects the value of " + p2.name + " to be a number. Using the default of " + p2.value);
                        try {
                            return Integer.parseInt(p2.value);
                        }
                        catch (NumberFormatException g2) {
                            return Double.parseDouble(p2.value);
                        }
                    }
                }
            }
            case FILE: {
                if (value == null || "".equals(value.trim())) {
                    return null;
                }
                return new File(value);
            }
        }
        return value;
    }

    private Boolean getBoolean(String value) {
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        if (value.equalsIgnoreCase("yes")) {
            return true;
        }
        if (value.equalsIgnoreCase("no")) {
            return false;
        }
        if (value.equalsIgnoreCase("on")) {
            return true;
        }
        if (value.equalsIgnoreCase("off")) {
            return false;
        }
        double d = Double.parseDouble(value);
        return d != 0.0;
    }

    private Object getSafePreference(String name, Type type) {
        if (this.prefs.get((Object)name).allowed != type) {
            throw new IllegalArgumentException("Expecting " + (Object)((Object)this.prefs.get((Object)name).allowed) + " but " + (Object)((Object)type) + " was requested");
        }
        if (this.prefs.get((Object)name).objectValue == null) {
            this.prefs.get((Object)name).objectValue = this.getObject(this.prefs.get((Object)name).value, this.prefs.get(name));
        }
        return this.prefs.get((Object)name).objectValue;
    }

    public Boolean getBooleanPreference(String name) {
        return (Boolean)this.getSafePreference(name, Type.BOOLEAN);
    }

    public Double getDoublePreference(String name) {
        return (Double)this.getSafePreference(name, Type.DOUBLE);
    }

    public File getFilePreference(String name) {
        return (File)this.getSafePreference(name, Type.FILE);
    }

    public Integer getIntegerPreference(String name) {
        return (Integer)this.getSafePreference(name, Type.INT);
    }

    public Number getNumberPreference(String name) {
        return (Number)this.getSafePreference(name, Type.NUMBER);
    }

    public String getStringPreference(String name) {
        return (String)this.getSafePreference(name, Type.STRING);
    }

    private void save() {
        try {
            StringBuilder b = new StringBuilder();
            String nl = System.getProperty("line.separator");
            b.append("# This file is generated automatically. Changes made to the values of this file").append(nl).append("# will persist, but changes to comments will not.").append(nl).append(nl);
            if (!this.header.trim().isEmpty()) {
                b.append(this.header).append(nl).append(nl);
            }
            TreeSet<String> keys = new TreeSet<String>(this.prefs.keySet()){};
            for (String key : keys) {
                Preference p2 = this.prefs.get(key);
                String description = "This value is not used in " + this.appName;
                if (!p2.description.trim().isEmpty()) {
                    description = p2.description;
                }
                StringBuilder c = new StringBuilder();
                boolean first = true;
                for (String line : description.split("\n|\r\n|\n\r")) {
                    for (String line2 : StringUtils.lineSplit(line, this.lineLength)) {
                        if (first) {
                            c.append("# ").append(line2);
                            first = false;
                            continue;
                        }
                        c.append(nl).append("# ").append(line2);
                    }
                }
                b.append((CharSequence)c).append(nl).append(p2.name).append("=").append(p2.value).append(nl).append(nl);
            }
            if (this.prefFile != null && !this.prefFile.exists()) {
                this.prefFile.getAbsoluteFile().getParentFile().mkdirs();
                this.prefFile.createNewFile();
            }
            if (this.prefFile != null) {
                FileUtil.write(b.toString(), this.prefFile);
            }
        }
        catch (Exception ex) {
            this.logger.log(Level.WARNING, "[" + this.appName + "] Could not write out preferences file: " + (this.prefFile != null ? this.prefFile.getAbsolutePath() : "null"), ex);
        }
    }

    public void setLineLength(int lineLength) {
        if (lineLength < 1) {
            throw new IllegalArgumentException();
        }
        this.lineLength = lineLength;
    }

    public static class Preference {
        public String name;
        public String value;
        public Type allowed;
        public String description;
        public Object objectValue;

        public Preference(String name, String def, Type allowed, String description) {
            this.name = name;
            this.value = def;
            this.allowed = allowed;
            this.description = description;
        }
    }

    public static enum Type {
        NUMBER,
        BOOLEAN,
        STRING,
        INT,
        DOUBLE,
        FILE;

    }
}

