/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.VirtualFS;

import com.laytonsmith.PureUtilities.VirtualFS.FileSystemLayer;
import com.laytonsmith.PureUtilities.VirtualFS.PermissionException;
import com.laytonsmith.PureUtilities.VirtualFS.VirtualFile;
import com.laytonsmith.PureUtilities.VirtualFS.VirtualFileSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

@FileSystemLayer.fslayer(value="file")
public class RealFileSystemLayer
extends FileSystemLayer {
    protected final File real;

    public RealFileSystemLayer(VirtualFile path, VirtualFileSystem fileSystem, String symlink) throws IOException {
        super(path, fileSystem, symlink);
        if (symlink == null) {
            this.real = new File(fileSystem.root, path.getPath());
            if (!this.real.getCanonicalPath().startsWith(fileSystem.root.getCanonicalPath())) {
                throw new PermissionException(path.getPath() + " extends above the root directory of this file system, and does not point to a valid file.");
            }
        } else {
            File symlinkRoot = new File(fileSystem.symlinkFile, symlink);
            this.real = new File(symlinkRoot, path.getPath());
            if (!this.real.getCanonicalPath().startsWith(symlinkRoot.getCanonicalPath()) && !this.real.getCanonicalPath().startsWith(fileSystem.root.getCanonicalPath())) {
                throw new PermissionException(path.getPath() + " extends above the root directory of this file system, and does not point to a valid file.");
            }
        }
    }

    @Override
    public InputStream getInputStream() throws FileNotFoundException {
        return new FileInputStream(this.real);
    }

    @Override
    public void writeByteArray(byte[] bytes) throws IOException {
        FileUtils.writeByteArrayToFile((File)this.real, (byte[])bytes);
    }

    @Override
    public VirtualFile[] listFiles() throws IOException {
        ArrayList<VirtualFile> virtuals = new ArrayList<VirtualFile>();
        for (File sub : this.real.listFiles()) {
            virtuals.add(this.normalize(sub));
        }
        return virtuals.toArray(new VirtualFile[virtuals.size()]);
    }

    private VirtualFile normalize(File real) throws IOException {
        String path = real.getCanonicalPath().replaceFirst(Pattern.quote(this.fileSystem.root.getCanonicalPath()), "");
        if (!(path = path.replace('\\', '/')).startsWith("/")) {
            path = "/" + path;
        }
        return new VirtualFile(path);
    }

    @Override
    public void delete() throws IOException {
        if (!this.exists()) {
            throw new IOException("File does not exist");
        }
        if (!this.real.delete()) {
            throw new IOException("Could not delete the file");
        }
    }

    @Override
    public void deleteEventually() throws IOException {
        if (!this.exists()) {
            throw new IOException("File does not exist");
        }
        this.real.deleteOnExit();
    }

    @Override
    public boolean exists() {
        return this.real.exists();
    }

    @Override
    public boolean canRead() throws IOException {
        if (!this.exists()) {
            throw new IOException("File does not exist");
        }
        return this.real.canRead();
    }

    @Override
    public boolean canWrite() throws IOException {
        if (!this.exists()) {
            throw new IOException("File does not exist");
        }
        return this.real.canWrite();
    }

    @Override
    public boolean isDirectory() throws IOException {
        if (!this.exists()) {
            throw new IOException("File does not exist");
        }
        return this.real.isDirectory();
    }

    @Override
    public boolean isFile() throws IOException {
        if (!this.exists()) {
            throw new IOException("File does not exist");
        }
        return this.real.isFile();
    }

    @Override
    public void mkdirs() throws IOException {
        if (this.exists() && !this.isDirectory()) {
            throw new IOException("The specified path already exists, and is not a directory");
        }
        if (!this.real.mkdirs()) {
            throw new IOException("Directory structure could not be created");
        }
    }

    @Override
    public void createNewFile() throws IOException {
        if (this.exists()) {
            throw new IOException("File already exists");
        }
        if (!this.real.createNewFile()) {
            throw new IOException("File could not be created");
        }
    }
}

