/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit;

import com.laytonsmith.abstraction.MCItemStack;
import com.laytonsmith.abstraction.MCShapedRecipe;
import com.laytonsmith.abstraction.blocks.MCMaterial;
import com.laytonsmith.abstraction.bukkit.BukkitMCItemStack;
import com.laytonsmith.abstraction.bukkit.BukkitMCRecipe;
import com.laytonsmith.abstraction.enums.MCRecipeType;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;

public class BukkitMCShapedRecipe
extends BukkitMCRecipe
implements MCShapedRecipe {
    ShapedRecipe r;

    public BukkitMCShapedRecipe(ShapedRecipe recipe) {
        super((Recipe)recipe);
        this.r = recipe;
    }

    @Override
    public String getKey() {
        return this.r.getKey().getKey();
    }

    @Override
    public MCRecipeType getRecipeType() {
        return MCRecipeType.SHAPED;
    }

    @Override
    public Object getHandle() {
        return this.r;
    }

    @Override
    public Map<Character, MCItemStack> getIngredientMap() {
        HashMap<Character, MCItemStack> ret = new HashMap<Character, MCItemStack>();
        for (Map.Entry e : this.r.getIngredientMap().entrySet()) {
            ret.put((Character)e.getKey(), new BukkitMCItemStack((ItemStack)e.getValue()));
        }
        return ret;
    }

    @Override
    public MCItemStack getResult() {
        return new BukkitMCItemStack(this.r.getResult());
    }

    @Override
    public String[] getShape() {
        return this.r.getShape();
    }

    @Override
    public void setIngredient(char key, MCItemStack ingredient) {
        this.r.setIngredient(key, ((ItemStack)ingredient.getHandle()).getType());
    }

    @Override
    public void setIngredient(char key, MCMaterial mat) {
        this.r.setIngredient(key, (Material)mat.getHandle());
    }

    @Override
    public void setShape(String[] shape) {
        this.r.shape(shape);
    }
}

