/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit.entities;

import com.laytonsmith.PureUtilities.Vector3D;
import com.laytonsmith.abstraction.MCEntity;
import com.laytonsmith.abstraction.MCLivingEntity;
import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.abstraction.MCServer;
import com.laytonsmith.abstraction.MCWorld;
import com.laytonsmith.abstraction.bukkit.BukkitConvertor;
import com.laytonsmith.abstraction.bukkit.BukkitMCLocation;
import com.laytonsmith.abstraction.bukkit.BukkitMCMetadatable;
import com.laytonsmith.abstraction.bukkit.BukkitMCServer;
import com.laytonsmith.abstraction.bukkit.BukkitMCWorld;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCLivingEntity;
import com.laytonsmith.abstraction.bukkit.events.BukkitEntityEvents;
import com.laytonsmith.abstraction.enums.MCEntityEffect;
import com.laytonsmith.abstraction.enums.MCEntityType;
import com.laytonsmith.abstraction.enums.MCTeleportCause;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCEntityType;
import com.laytonsmith.abstraction.events.MCEntityDamageEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.EntityEffect;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Tameable;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.metadata.Metadatable;
import org.bukkit.util.Vector;

public class BukkitMCEntity
extends BukkitMCMetadatable
implements MCEntity {
    Entity e;

    public BukkitMCEntity(Entity e) {
        super((Metadatable)e);
        this.e = e;
    }

    @Override
    public boolean eject() {
        return this.e.eject();
    }

    @Override
    public float getFallDistance() {
        return this.e.getFallDistance();
    }

    @Override
    public int getFireTicks() {
        return this.e.getFireTicks();
    }

    public Entity getHandle() {
        return this.e;
    }

    @Override
    public MCEntityDamageEvent getLastDamageCause() {
        EntityDamageEvent ldc = this.e.getLastDamageCause();
        if (ldc == null) {
            return null;
        }
        if (ldc instanceof EntityDamageByEntityEvent) {
            return new BukkitEntityEvents.BukkitMCEntityDamageByEntityEvent((Event)ldc);
        }
        return new BukkitEntityEvents.BukkitMCEntityDamageEvent((Event)ldc);
    }

    public MCLivingEntity getLivingEntity() {
        if (this.e instanceof LivingEntity) {
            return new BukkitMCLivingEntity(this.e);
        }
        return null;
    }

    @Override
    public MCLocation getLocation() {
        if (this.e.getLocation() == null) {
            return null;
        }
        return new BukkitMCLocation(this.e.getLocation());
    }

    @Override
    public int getMaxFireTicks() {
        return this.e.getMaxFireTicks();
    }

    @Override
    public List<MCEntity> getNearbyEntities(double x, double y, double z) {
        List lst = this.e.getNearbyEntities(x, y, z);
        ArrayList<MCEntity> retn = new ArrayList<MCEntity>();
        for (Entity e : lst) {
            retn.add(BukkitConvertor.BukkitGetCorrectEntity(e));
        }
        return retn;
    }

    @Override
    public List<MCEntity> getPassengers() {
        ArrayList<MCEntity> passengers = new ArrayList<MCEntity>();
        for (Entity passenger : this.e.getPassengers()) {
            passengers.add(BukkitConvertor.BukkitGetCorrectEntity(passenger));
        }
        return passengers;
    }

    @Override
    public MCServer getServer() {
        return new BukkitMCServer(this.e.getServer());
    }

    @Override
    public int getTicksLived() {
        return this.e.getTicksLived();
    }

    @Override
    public MCEntityType getType() {
        return BukkitMCEntityType.valueOfConcrete(this.e.getType());
    }

    @Override
    public UUID getUniqueId() {
        return this.e.getUniqueId();
    }

    @Override
    public MCEntity getVehicle() {
        return BukkitConvertor.BukkitGetCorrectEntity(this.e.getVehicle());
    }

    @Override
    public Vector3D getVelocity() {
        Vector v = this.e.getVelocity();
        return new Vector3D(v.getX(), v.getY(), v.getZ());
    }

    @Override
    public MCWorld getWorld() {
        if (this.e == null || this.e.getWorld() == null) {
            return null;
        }
        return new BukkitMCWorld(this.e.getWorld());
    }

    @Override
    public boolean isDead() {
        return this.e.isDead();
    }

    @Override
    public boolean isEmpty() {
        return this.e.isEmpty();
    }

    @Override
    public boolean isInsideVehicle() {
        return this.e.isInsideVehicle();
    }

    @Override
    public boolean isOnGround() {
        return this.e.isOnGround();
    }

    public boolean isLivingEntity() {
        return this.e instanceof LivingEntity;
    }

    public boolean isTameable() {
        return this.e instanceof Tameable;
    }

    @Override
    public boolean leaveVehicle() {
        return this.e.leaveVehicle();
    }

    @Override
    public void playEffect(MCEntityEffect type) {
        this.e.playEffect(EntityEffect.valueOf((String)type.name()));
    }

    @Override
    public void remove() {
        this.e.remove();
    }

    @Override
    public void setFallDistance(float distance2) {
        this.e.setFallDistance(distance2);
    }

    @Override
    public void setFireTicks(int ticks) {
        this.e.setFireTicks(ticks);
    }

    @Override
    public void setLastDamageCause(MCEntityDamageEvent event) {
        this.e.setLastDamageCause((EntityDamageEvent)event._GetObject());
    }

    @Override
    public boolean setPassenger(MCEntity passenger) {
        return this.e.addPassenger((Entity)passenger.getHandle());
    }

    @Override
    public void setTicksLived(int value) {
        this.e.setTicksLived(value);
    }

    @Override
    public void setVelocity(Vector3D velocity) {
        Vector v = new Vector(velocity.X(), velocity.Y(), velocity.Z());
        this.e.setVelocity(v);
    }

    @Override
    public boolean teleport(MCEntity destination) {
        Entity ent = ((BukkitMCEntity)destination).getHandle();
        return this.e.teleport(ent.getLocation());
    }

    @Override
    public boolean teleport(MCEntity destination, MCTeleportCause cause) {
        return this.e.teleport(((BukkitMCEntity)destination).getHandle(), PlayerTeleportEvent.TeleportCause.valueOf((String)cause.name()));
    }

    @Override
    public boolean teleport(MCLocation location) {
        return this.e.teleport(((BukkitMCLocation)location).asLocation());
    }

    @Override
    public boolean teleport(MCLocation location, MCTeleportCause cause) {
        return this.e.teleport(((BukkitMCLocation)location).asLocation(), PlayerTeleportEvent.TeleportCause.valueOf((String)cause.name()));
    }

    @Override
    public String getCustomName() {
        return this.e.getCustomName();
    }

    @Override
    public boolean isCustomNameVisible() {
        return this.e.isCustomNameVisible();
    }

    @Override
    public void setCustomName(String name) {
        this.e.setCustomName(name);
    }

    @Override
    public void setCustomNameVisible(boolean visible) {
        this.e.setCustomNameVisible(visible);
    }

    @Override
    public boolean isGlowing() {
        return this.e.isGlowing();
    }

    @Override
    public void setGlowing(Boolean glow) {
        this.e.setGlowing(glow.booleanValue());
    }

    @Override
    public boolean hasGravity() {
        return this.e.hasGravity();
    }

    @Override
    public void setHasGravity(boolean gravity) {
        this.e.setGravity(gravity);
    }

    @Override
    public boolean isSilent() {
        return this.e.isSilent();
    }

    @Override
    public void setSilent(boolean silent) {
        this.e.setSilent(silent);
    }

    @Override
    public boolean isInvulnerable() {
        return this.e.isInvulnerable();
    }

    @Override
    public void setInvulnerable(boolean invulnerable) {
        this.e.setInvulnerable(invulnerable);
    }

    @Override
    public Set<String> getScoreboardTags() {
        return this.e.getScoreboardTags();
    }

    @Override
    public boolean addScoreboardTag(String tag) {
        return this.e.addScoreboardTag(tag);
    }

    @Override
    public boolean removeScoreboardTag(String tag) {
        return this.e.removeScoreboardTag(tag);
    }
}

