/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit.entities;

import com.laytonsmith.abstraction.MCEntity;
import com.laytonsmith.abstraction.MCProjectileSource;
import com.laytonsmith.abstraction.blocks.MCBlockProjectileSource;
import com.laytonsmith.abstraction.bukkit.BukkitConvertor;
import com.laytonsmith.abstraction.bukkit.blocks.BukkitMCBlockProjectileSource;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCEntity;
import com.laytonsmith.abstraction.entities.MCProjectile;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Projectile;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.projectiles.ProjectileSource;

public class BukkitMCProjectile
extends BukkitMCEntity
implements MCProjectile {
    Projectile proj;

    public BukkitMCProjectile(Entity e) {
        super(e);
        this.proj = (Projectile)e;
    }

    @Override
    public boolean doesBounce() {
        return this.proj.doesBounce();
    }

    @Override
    public MCProjectileSource getShooter() {
        MCEntity e;
        ProjectileSource source = this.proj.getShooter();
        if (source instanceof BlockProjectileSource) {
            return new BukkitMCBlockProjectileSource((BlockProjectileSource)source);
        }
        if (source instanceof Entity && (e = BukkitConvertor.BukkitGetCorrectEntity((Entity)source)) instanceof MCProjectileSource) {
            return (MCProjectileSource)((Object)e);
        }
        return null;
    }

    @Override
    public void setBounce(boolean doesBounce) {
        this.proj.setBounce(doesBounce);
    }

    @Override
    public void setShooter(MCProjectileSource shooter) {
        if (shooter == null) {
            this.proj.setShooter(null);
        } else if (shooter instanceof MCBlockProjectileSource) {
            this.proj.setShooter((ProjectileSource)((BlockProjectileSource)shooter.getHandle()));
        } else {
            this.proj.setShooter((ProjectileSource)shooter.getHandle());
        }
    }

    public Projectile asProjectile() {
        return this.proj;
    }
}

