/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.compiler;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.core.Documentation;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.Prefs;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class FileOptions {
    @Option(value="Strict Mode On")
    private final Boolean strict;
    @Option(value="Suppressed Warnings")
    private final Set<SuppressWarning> suppressWarnings;
    @Option(value="File Name")
    private final String name;
    @Option(value="Author")
    private final String author;
    @Option(value="Creation Date")
    private final String created;
    @Option(value="File Description")
    private final String description;
    @Option(value="Required Extensions")
    private final Set<String> requiredExtensions;
    @Option(value="Compiler Options")
    private final Set<CompilerOption> compilerOptions;
    @Option(value="Copyright information")
    private final String copyright;
    @Option(value="Distribution License Information")
    private final String license;
    private final Map<String, String> rawOptions;

    public FileOptions(Map<String, String> parsedOptions) {
        this.rawOptions = new HashMap<String, String>(parsedOptions);
        this.strict = this.parseBoolean(this.getDefault(parsedOptions, "strict", null));
        this.suppressWarnings = this.parseEnumSet(this.getDefault(parsedOptions, "suppresswarnings", ""), SuppressWarning.class);
        this.name = this.getDefault(parsedOptions, "name", "").trim();
        this.author = this.getDefault(parsedOptions, "author", "").trim();
        this.created = this.getDefault(parsedOptions, "created", "").trim();
        this.description = this.getDefault(parsedOptions, "description", "").trim();
        this.requiredExtensions = Collections.unmodifiableSet(this.parseSet(this.getDefault(parsedOptions, "requiredextensions", "")));
        this.compilerOptions = this.parseEnumSet(this.getDefault(parsedOptions, "compileroptions", ""), CompilerOption.class);
        this.copyright = this.getDefault(parsedOptions, "copyright", "").trim();
        this.license = this.getDefault(parsedOptions, "license", "").trim();
    }

    private String getDefault(Map<String, String> map, String key, String defaultIfNone) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        return defaultIfNone;
    }

    private Boolean parseBoolean(String bool) {
        if (bool == null) {
            return null;
        }
        return !bool.equalsIgnoreCase("false") && !bool.equalsIgnoreCase("off");
    }

    private List<String> parseList(String list) {
        ArrayList<String> l = new ArrayList<String>();
        for (String part : list.split(",")) {
            if (part.trim().isEmpty()) continue;
            l.add(part.trim().toLowerCase());
        }
        return l;
    }

    private Set<String> parseSet(String list) {
        return new HashSet<String>(this.parseList(list));
    }

    private <T extends Enum<T>> Set<T> parseEnumSet(String list, Class<T> type) {
        EnumSet<T> set = EnumSet.noneOf(type);
        List<String> sList = this.parseList(list);
        block0: for (String s : sList) {
            for (Enum e : (Enum[])type.getEnumConstants()) {
                if (!e.name().equals(s)) continue;
                set.add(e);
                continue block0;
            }
        }
        return set;
    }

    public boolean isStrict() {
        if (this.strict != null) {
            return this.strict;
        }
        return Prefs.StrictMode();
    }

    public boolean isWarningSuppressed(SuppressWarning warning) {
        return this.suppressWarnings.contains(warning);
    }

    public boolean hasCompilerOption(CompilerOption option) {
        return this.compilerOptions.contains(option);
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getCreated() {
        return this.created;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean requiresExtensions() {
        return !this.requiredExtensions.isEmpty();
    }

    public Set<String> getRequiredExtensions() {
        return this.requiredExtensions;
    }

    public String getLicense() {
        return this.license;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public Map<String, String> getRawOptions() {
        return new HashMap<String, String>(this.rawOptions);
    }

    public static List<String> getKnownOptions() {
        ArrayList<String> list = new ArrayList<String>();
        for (Field f : ClassDiscovery.getDefaultInstance().loadFieldsWithAnnotation(Option.class)) {
            list.add(f.getName());
        }
        return list;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (Field f : ClassDiscovery.getDefaultInstance().loadFieldsWithAnnotation(Option.class)) {
            String desc = f.getAnnotation(Option.class).value();
            try {
                b.append(desc).append(": ").append(f.get(this));
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {}
        }
        return b.toString();
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface Option {
        public String value();
    }

    public static enum SuppressWarning implements Documentation
    {
        Note("There are currently no warning suppressions defined, but some will be added in the future", MSVersion.V0_0_0);

        private final String docs;
        private final Version version;

        private SuppressWarning(String docs, Version version) {
            this.docs = docs;
            this.version = version;
        }

        @Override
        public URL getSourceJar() {
            return ClassDiscovery.GetClassContainer(this.getClass());
        }

        @Override
        public Class<? extends Documentation>[] seeAlso() {
            return new Class[0];
        }

        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public String docs() {
            return this.docs;
        }

        @Override
        public Version since() {
            return this.version;
        }
    }

    public static enum CompilerOption implements Documentation
    {
        AllowAmbiguousCommands("Disables compiler validation for ambigous commands (only applicable to MSA files).", MSVersion.V3_3_4),
        UltraStrict("Provides an extra strict programming environment. Nitpicky details may be covered in ultra strict mode, and will turn almost all warnings into compiler errors. This will also apply all lint settings that would be warnings into errors as well, and is generally the most pedantic version of strict mode available. This is used in native code, but is not necessarily recommened, since it offers no flexibility, however, code that passes ultra strict mode will generally be considered \"ideal\" code, and enshrines the standard code layout. Warnings that are explicitely suppressed are not errors in this mode.", MSVersion.V3_3_4);

        private final String docs;
        private final Version version;

        private CompilerOption(String docs, Version version) {
            this.docs = docs;
            this.version = version;
        }

        @Override
        public URL getSourceJar() {
            return ClassDiscovery.GetClassContainer(this.getClass());
        }

        @Override
        public Class<? extends Documentation>[] seeAlso() {
            return new Class[0];
        }

        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public String docs() {
            return this.docs;
        }

        @Override
        public Version since() {
            return this.version;
        }
    }
}

