/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs;

import com.laytonsmith.core.LogLevel;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.constructs.Auto;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.IVariable;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.environments.GlobalEnv;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class IVariableList {
    Map<String, IVariable> varList = new HashMap<String, IVariable>();

    public void remove(String name) {
        this.varList.remove(name);
    }

    public void set(IVariable v) {
        this.varList.put(v.getVariableName(), v);
    }

    public IVariable get(String name, Target t, boolean bypassAssignedCheck, Environment env) {
        IVariable v = this.varList.get(name);
        if (v == null) {
            v = new IVariable(Auto.TYPE, name, CNull.UNDEFINED, t);
            this.set(v);
        }
        if (v.ival() == CNull.UNDEFINED && !bypassAssignedCheck && env.getEnv(GlobalEnv.class).GetFlag("no-check-undefined") == null) {
            MSLog.GetLogger().Log(MSLog.Tags.RUNTIME, LogLevel.ERROR, "Using undefined variable: " + name, t);
        }
        v.setTarget(t);
        return v;
    }

    public IVariable get(String name, Target t, Environment env) {
        return this.get(name, t, false, env);
    }

    public boolean has(String name) {
        return this.varList.containsKey(name);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[");
        boolean first = true;
        for (Map.Entry<String, IVariable> entry : this.varList.entrySet()) {
            IVariable iv = entry.getValue();
            if (first) {
                first = false;
            } else {
                b.append(", ");
            }
            b.append(iv.getVariableName()).append(":").append("(").append(iv.ival().getClass().getSimpleName()).append(")").append(iv.ival().val());
        }
        b.append("]");
        return b.toString();
    }

    public IVariableList clone() {
        IVariableList clone = new IVariableList();
        clone.varList = new HashMap<String, IVariable>(this.varList);
        return clone;
    }

    public Set<String> keySet() {
        return this.varList.keySet();
    }

    public void clear() {
        this.varList.clear();
    }
}

