/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.events;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.annotations.core;
import com.laytonsmith.annotations.hide;
import com.laytonsmith.core.Documentation;
import com.laytonsmith.core.LogLevel;
import com.laytonsmith.core.MethodScriptCompiler;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.CommandHelperEnvironment;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.environments.GlobalEnv;
import com.laytonsmith.core.events.BindableEvent;
import com.laytonsmith.core.events.BoundEvent;
import com.laytonsmith.core.events.Event;
import com.laytonsmith.core.events.EventMixinInterface;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import com.laytonsmith.core.exceptions.CRE.CREPlayerOfflineException;
import com.laytonsmith.core.exceptions.CancelCommandException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.exceptions.EventException;
import com.laytonsmith.core.exceptions.FunctionReturnException;
import com.laytonsmith.core.exceptions.ProgramFlowManipulationException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.core.profiler.ProfilePoint;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractEvent
implements Event,
Comparable<Event> {
    private EventMixinInterface mixin;
    private static final Class[] EMPTY_CLASS = new Class[0];

    public final void setAbstractEventMixin(EventMixinInterface mixin) {
        this.mixin = mixin;
    }

    @Override
    public void bind(BoundEvent event) {
    }

    @Override
    public void unbind(BoundEvent event) {
    }

    @Override
    public void hook() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void execute(ParseTree tree, BoundEvent b, Environment env, BoundEvent.ActiveEvent activeEvent) throws ConfigRuntimeException {
        block14: {
            this.preExecution(env, activeEvent);
            Mixed c = activeEvent.getParsedEvent().get("player");
            if (c != null) {
                try {
                    MCPlayer p2 = Static.GetPlayer(c, Target.UNKNOWN);
                    env.getEnv(CommandHelperEnvironment.class).SetPlayer(p2);
                }
                catch (CREPlayerOfflineException e) {
                    if (env.getEnv(CommandHelperEnvironment.class).GetPlayer() == null) break block14;
                    env.getEnv(CommandHelperEnvironment.class).SetCommandSender(Static.getServer().getConsole());
                }
            }
        }
        ProfilePoint event = null;
        if (env.getEnv(GlobalEnv.class).GetProfiler() != null) {
            event = env.getEnv(GlobalEnv.class).GetProfiler().start("Event " + b.getEventName() + " (defined at " + b.getTarget().toString() + ")", LogLevel.ERROR);
        }
        try {
            try {
                String label = b.getEnvironment().getEnv(GlobalEnv.class).GetLabel();
                if (label == null) {
                    label = "*";
                }
                env.getEnv(GlobalEnv.class).SetLabel(label);
                MethodScriptCompiler.execute(tree, env, null, null);
            }
            catch (CancelCommandException ex) {
                if (ex.getMessage() != null && !ex.getMessage().isEmpty()) {
                    StreamUtils.GetSystemOut().println(ex.getMessage());
                }
            }
            catch (FunctionReturnException ex) {
            }
            catch (ProgramFlowManipulationException ex) {
                ConfigRuntimeException.HandleUncaughtException(new CREFormatException("Unexpected control flow operation used.", ex.getTarget()), env);
            }
        }
        finally {
            if (event != null) {
                event.stop();
            }
            this.postExecution(env, activeEvent);
        }
    }

    public void preExecution(Environment env, BoundEvent.ActiveEvent activeEvent) {
    }

    public void postExecution(Environment env, BoundEvent.ActiveEvent activeEvent) {
    }

    @Override
    public int compareTo(Event o) {
        return this.getName().compareTo(o.getName());
    }

    @Override
    public boolean supportsExternal() {
        return true;
    }

    public static Object DoConvert(CArray manualObject) {
        HashMap<String, Mixed> map = new HashMap<String, Mixed>();
        for (String key : manualObject.stringKeySet()) {
            map.put(key, manualObject.get(key, Target.UNKNOWN));
        }
        return map;
    }

    public Map<String, Mixed> evaluate_helper(BindableEvent e) throws EventException {
        return this.mixin.evaluate_helper(e);
    }

    @Override
    public void manualTrigger(BindableEvent o) {
        this.mixin.manualTrigger(o);
    }

    @Override
    public void cancel(BindableEvent o, boolean state) {
        this.mixin.cancel(o, state);
    }

    @Override
    public boolean isCancellable(BindableEvent o) {
        return this.mixin.isCancellable(o);
    }

    @Override
    public boolean isCancelled(BindableEvent o) {
        return this.mixin.isCancelled(o);
    }

    @Override
    public URL getSourceJar() {
        return ClassDiscovery.GetClassContainer(this.getClass());
    }

    @Override
    public final boolean appearInDocumentation() {
        return this.getClass().getAnnotation(hide.class) != null;
    }

    @Override
    public Class<? extends Documentation>[] seeAlso() {
        return EMPTY_CLASS;
    }

    @Override
    public boolean addCounter() {
        return true;
    }

    @Override
    public final boolean isCore() {
        Class<?> c = this.getClass();
        do {
            if (c.getAnnotation(core.class) == null) continue;
            return true;
        } while ((c = c.getDeclaringClass()) != null);
        return false;
    }
}

