/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.persistence;

import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.DaemonManager;
import com.laytonsmith.persistence.AbstractDataSource;
import com.laytonsmith.persistence.DataSource;
import com.laytonsmith.persistence.DataSourceException;
import com.laytonsmith.persistence.ReadOnlyException;
import com.laytonsmith.persistence.io.ConnectionMixinFactory;
import java.io.IOException;
import java.net.URI;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class SQLDataSource
extends AbstractDataSource {
    private static final String KEY_COLUMN = "key";
    private static final String VALUE_COLUMN = "value";
    protected Connection connection;
    private long lastConnected = 0L;

    protected SQLDataSource() {
    }

    protected SQLDataSource(URI uri, ConnectionMixinFactory.ConnectionMixinOptions options) throws DataSourceException {
        super(uri, options);
    }

    protected Connection getConnection() {
        return this.connection;
    }

    protected String getKeyColumn() {
        return KEY_COLUMN;
    }

    protected String getValueColumn() {
        return VALUE_COLUMN;
    }

    protected abstract String getTable();

    protected abstract String getConnectionString();

    protected String getEscapedTable() {
        return this.getTable().replace("`", "``");
    }

    protected void connect() throws IOException, SQLException {
        boolean needToConnect = false;
        if (this.connection == null) {
            needToConnect = true;
        } else if (this.connection.isClosed()) {
            needToConnect = true;
        } else if (this.lastConnected < System.currentTimeMillis() - 10000L) {
            try {
                if (!this.connection.isValid(3)) {
                    needToConnect = true;
                }
            }
            catch (AbstractMethodError ex) {
                try {
                    this.connection.createStatement().execute(this.getTestQuery());
                }
                catch (SQLException e) {
                    needToConnect = true;
                }
            }
        }
        if (needToConnect) {
            this.connection = DriverManager.getConnection(this.getConnectionString());
        }
    }

    protected String getTestQuery() {
        return "SELECT 1";
    }

    @Override
    public void disconnect() throws DataSourceException {
        try {
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
            }
        }
        catch (SQLException ex) {
            throw new DataSourceException(ex.getMessage(), ex);
        }
    }

    @Override
    public Set<String[]> keySet(String[] keyBase) throws DataSourceException {
        String searchPrefix = StringUtils.Join(keyBase, ".");
        try {
            HashSet<String[]> set;
            this.connect();
            try (PreparedStatement statement = this.connection.prepareStatement("SELECT `key` FROM `" + this.getEscapedTable() + "` WHERE `" + KEY_COLUMN + "` LIKE ?");){
                statement.setString(1, searchPrefix + "%");
                set = new HashSet<String[]>();
                try (ResultSet result = statement.executeQuery();){
                    while (result.next()) {
                        set.add(result.getString(KEY_COLUMN).split("\\."));
                    }
                }
                this.lastConnected = System.currentTimeMillis();
            }
            return set;
        }
        catch (IOException | SQLException ex) {
            throw new DataSourceException(ex.getMessage(), ex);
        }
    }

    @Override
    protected Map<String[], String> getValues0(String[] leadKey) throws DataSourceException {
        try {
            HashMap<String[], String> map;
            this.connect();
            try (PreparedStatement statement = this.connection.prepareStatement("SELECT `key`, `value` FROM `" + this.getEscapedTable() + "` WHERE `" + KEY_COLUMN + "` LIKE ?");){
                statement.setString(1, StringUtils.Join(leadKey, ".") + "%");
                map = new HashMap<String[], String>();
                try (ResultSet results = statement.executeQuery();){
                    while (results.next()) {
                        map.put(results.getString(KEY_COLUMN).split("\\."), results.getString(VALUE_COLUMN));
                    }
                }
                this.lastConnected = System.currentTimeMillis();
            }
            return map;
        }
        catch (IOException | SQLException ex) {
            throw new DataSourceException(ex.getMessage(), ex);
        }
    }

    @Override
    protected void clearKey0(DaemonManager dm, String[] key) throws ReadOnlyException, DataSourceException, IOException {
        if (this.hasKey(key)) {
            try {
                this.connect();
                try (PreparedStatement statement = this.connection.prepareStatement("DELETE FROM `" + this.getEscapedTable() + "` WHERE `" + KEY_COLUMN + "`=?");){
                    statement.setString(1, StringUtils.Join(key, "."));
                    statement.executeUpdate();
                }
                this.lastConnected = System.currentTimeMillis();
            }
            catch (Exception e) {
                throw new DataSourceException(e.getMessage(), e);
            }
        }
    }

    @Override
    public void populate() throws DataSourceException {
    }

    @Override
    public EnumSet<DataSource.DataSourceModifier> implicitModifiers() {
        return EnumSet.of(DataSource.DataSourceModifier.TRANSIENT);
    }

    @Override
    public EnumSet<DataSource.DataSourceModifier> invalidModifiers() {
        return EnumSet.of(DataSource.DataSourceModifier.HTTP, DataSource.DataSourceModifier.HTTPS, DataSource.DataSourceModifier.SSH, DataSource.DataSourceModifier.PRETTYPRINT);
    }

    protected void updateLastConnected() {
        this.lastConnected = System.currentTimeMillis();
    }
}

