/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.tools.docgen;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.abstraction.Implementation;
import com.laytonsmith.annotations.api;
import com.laytonsmith.annotations.typeof;
import com.laytonsmith.commandhelper.CommandHelperFileLocations;
import com.laytonsmith.core.Documentation;
import com.laytonsmith.core.Installer;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.Optimizable;
import com.laytonsmith.core.Prefs;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.events.Event;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.extensions.ExtensionManager;
import com.laytonsmith.core.functions.ExampleScript;
import com.laytonsmith.core.functions.Function;
import com.laytonsmith.core.functions.FunctionBase;
import com.laytonsmith.core.functions.FunctionList;
import com.laytonsmith.tools.SimpleSyntaxHighlighter;
import com.laytonsmith.tools.docgen.DocGenTemplates;
import com.laytonsmith.tools.docgen.templates.Template;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DocGen {
    public static void main(String[] args) throws Exception {
        try {
            Implementation.setServerType(Implementation.Type.BUKKIT);
            ClassDiscovery.getDefaultInstance().addDiscoveryLocation(ClassDiscovery.GetClassContainer(DocGen.class));
            ExtensionManager.Initialize(ClassDiscovery.getDefaultInstance());
            Installer.Install(CommandHelperFileLocations.getDefault().getConfigDirectory());
            Prefs.init(CommandHelperFileLocations.getDefault().getPreferencesFile());
            MSLog.initialize(CommandHelperFileLocations.getDefault().getConfigDirectory());
            StreamUtils.GetSystemOut().println(DocGen.examples("if", true));
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
        finally {
            System.exit(0);
        }
    }

    public static String examples(String function, boolean staged) throws Exception {
        FunctionBase fb = FunctionList.getFunction(new CFunction(function, Target.UNKNOWN));
        if (fb instanceof Function) {
            Function f = (Function)fb;
            String restricted = f instanceof Function && f.isRestricted() ? "<div style=\"background-color: red; font-weight: bold; text-align: center;\">Yes</div>" : "<div style=\"background-color: green; font-weight: bold; text-align: center;\">No</div>";
            String optimizationMessage = "None";
            if (f instanceof Optimizable) {
                Set<Optimizable.OptimizationOption> options = ((Optimizable)f).optimizationOptions();
                ArrayList<String> list = new ArrayList<String>();
                for (Optimizable.OptimizationOption option : options) {
                    list.add("[[CommandHelper/" + (staged ? "Staged/" : "") + "Optimizer#" + option.name() + "|" + option.name() + "]]");
                }
                optimizationMessage = StringUtils.Join(list, "<br />");
            }
            DocInfo di = new DocInfo(f.docs());
            StringBuilder thrown = new StringBuilder();
            if (f instanceof Function && f.thrown() != null) {
                List<Class<? extends CREThrowable>> thrownList = Arrays.asList(f.thrown());
                for (int i = 0; i < thrownList.size(); ++i) {
                    String t = thrownList.get(i).getAnnotation(typeof.class).value();
                    if (i != 0) {
                        thrown.append("<br />\n");
                    }
                    thrown.append("[[CommandHelper/Exceptions#").append(t).append("|").append(t).append("]]");
                }
            }
            String tableUsages = di.originalArgs.replace("|", "<hr />");
            String[] usages = di.originalArgs.split("\\|");
            StringBuilder usageBuilder = new StringBuilder();
            for (String usage : usages) {
                usageBuilder.append("<pre>\n").append(f.getName()).append("(").append(usage.trim()).append(")\n</pre>");
            }
            StringBuilder exampleBuilder = new StringBuilder();
            if (f.examples() != null && f.examples().length > 0) {
                int count = 1;
                for (ExampleScript es : f.examples()) {
                    exampleBuilder.append("====Example ").append(count).append("====\n").append(es.getDescription()).append("\n\nGiven the following code:\n");
                    exampleBuilder.append(SimpleSyntaxHighlighter.Highlight(es.getScript(), true)).append("\n");
                    String style = "";
                    if (es.isAutomatic()) {
                        style = " style=\"background-color: #BDC7E9\"";
                        exampleBuilder.append("\n\nThe output would be:\n<pre");
                    } else {
                        exampleBuilder.append("\n\nThe output might be:\n<pre");
                    }
                    exampleBuilder.append(style).append(">").append(es.getOutput()).append("</pre>\n");
                    ++count;
                }
            } else {
                exampleBuilder.append("Sorry, there are no examples for this function! :(");
            }
            Class<? extends Documentation>[] seeAlso = f.seeAlso();
            String seeAlsoText = "";
            if (seeAlso != null && seeAlso.length > 0) {
                seeAlsoText = seeAlsoText + "===See Also===\n";
                boolean first = true;
                for (Class<? extends Documentation> c : seeAlso) {
                    if (!first) {
                        seeAlsoText = seeAlsoText + ", ";
                    }
                    first = false;
                    if (Function.class.isAssignableFrom(c)) {
                        Function f2 = (Function)c.newInstance();
                        seeAlsoText = seeAlsoText + "<code>[[CommandHelper/" + (staged ? "Staged/" : "") + "API/" + f2.getName() + "|" + f2.getName() + "]]</code>";
                        continue;
                    }
                    if (Template.class.isAssignableFrom(c)) {
                        Template t = (Template)((Object)c.newInstance());
                        seeAlsoText = seeAlsoText + "[[CommandHelper/" + (staged ? "Staged/" : "") + t.getName() + "|Learning Trail: " + t.getDisplayName() + "]]";
                        continue;
                    }
                    throw new Error("Unsupported class found in @seealso annotation: " + c.getName());
                }
            }
            HashMap<String, String> templateFields = new HashMap<String, String>();
            templateFields.put("function_name", f.getName());
            templateFields.put("returns", di.ret);
            templateFields.put("tableUsages", tableUsages);
            templateFields.put("throws", thrown.toString());
            templateFields.put("since", f.since().toString());
            templateFields.put("restricted", restricted);
            templateFields.put("optimizationMessage", optimizationMessage);
            templateFields.put("description", di.extendedDesc == null ? di.desc : di.topDesc + "\n\n" + di.extendedDesc);
            templateFields.put("usages", usageBuilder.toString());
            templateFields.put("examples", exampleBuilder.toString());
            templateFields.put("staged", staged ? "Staged/" : "");
            templateFields.put("seeAlso", seeAlsoText);
            String template = StreamUtils.GetString(DocGenTemplates.class.getResourceAsStream("/templates/example_templates"));
            Matcher m = Pattern.compile("%%(.*?)%%").matcher(template);
            try {
                while (m.find()) {
                    String name = m.group(1);
                    String templateValue = (String)templateFields.get(name);
                    template = template.replaceAll("%%" + Pattern.quote(name) + "%%", templateValue.replace("$", "\\$").replaceAll("\\'", "\\\\'"));
                }
                return template;
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Caught a runtime exception while generating template for " + function, e);
            }
        }
        throw new RuntimeException(function + " does not implement Function");
    }

    public static String functions(MarkupType type, api.Platforms platform, boolean staged) throws ConfigCompileException {
        Set<FunctionBase> functions = FunctionList.getFunctionList(platform);
        HashMap functionlist = new HashMap();
        StringBuilder out = new StringBuilder();
        for (FunctionBase f : functions) {
            Class<?> apiClass = f.getClass().getEnclosingClass() != null ? f.getClass().getEnclosingClass() : null;
            ArrayList<FunctionBase> fl = (ArrayList<FunctionBase>)functionlist.get(apiClass);
            if (fl == null) {
                fl = new ArrayList<FunctionBase>();
                functionlist.put(apiClass, fl);
            }
            fl.add(f);
        }
        if (type == MarkupType.HTML) {
            out.append("Command Helper uses a language called MethodScript, which greatly extend the capabilities of the plugin, and make the plugin a fully <a href=\"http://en.wikipedia.org/wiki/Turing_Complete\">Turing Complete</a> language. There are several functions defined, and they are grouped into \"classes\". \n");
        } else if (type == MarkupType.WIKI) {
            out.append("Command Helper uses a language called MethodScript, which greatly extend the capabilities of the plugin, and make the plugin a fully [http://en.wikipedia.org/wiki/Turing_Complete Turing Complete] language. There are several functions defined, and they are grouped into \"classes\". \n");
            out.append("<p>Each function has its own page for documentation, where you can view examples for how to use a particular function.\n");
        } else if (type == MarkupType.TEXT) {
            out.append("Command Helper uses a language called MethodScript, which greatly extend the capabilities of the plugin, and make the plugin a fully Turing Complete language [http://en.wikipedia.org/wiki/Turing_Complete].\nThere are several functions defined, and they are grouped into \"classes\".\n");
        }
        ArrayList entrySet = new ArrayList(functionlist.entrySet());
        Collections.sort(entrySet, new Comparator<Map.Entry<Class, ArrayList<FunctionBase>>>(){

            @Override
            public int compare(Map.Entry<Class, ArrayList<FunctionBase>> o1, Map.Entry<Class, ArrayList<FunctionBase>> o2) {
                return o1.getKey().getName().compareTo(o2.getKey().getName());
            }
        });
        int total = 0;
        int workingExamples = 0;
        for (Map.Entry entry : entrySet) {
            Class apiClass = (Class)entry.getKey();
            String className = apiClass.getName().split("\\.")[apiClass.getName().split("\\.").length - 1];
            if (className.equals("Sandbox")) continue;
            String classDocs = null;
            try {
                Method m = apiClass.getMethod("docs", null);
                Object o = null;
                if ((m.getModifiers() & 8) == 0) {
                    try {
                        o = apiClass.newInstance();
                    }
                    catch (InstantiationException instantiationException) {
                        // empty catch block
                    }
                }
                classDocs = (String)m.invoke(o, (Object[])null);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException m) {
            }
            catch (Exception e) {
                e.printStackTrace(StreamUtils.GetSystemErr());
                StreamUtils.GetSystemErr().println("Continuing however.");
            }
            StringBuilder intro = new StringBuilder();
            if (type == MarkupType.HTML) {
                if (className != null) {
                    intro.append("<h1>").append(className).append("</h1>\n");
                    intro.append(classDocs == null ? "" : classDocs).append("\n");
                } else {
                    intro.append("<h1>Other Functions</h1>\n");
                }
                intro.append("<table>\n");
            } else if (type == MarkupType.WIKI) {
                if (className != null) {
                    intro.append("===").append(className).append("===\n");
                    intro.append(classDocs == null ? "" : classDocs).append("\n");
                } else {
                    intro.append("===Other Functions===\n");
                }
                intro.append("{| width=\"100%\" cellspacing=\"1\" cellpadding=\"1\" border=\"1\" class=\"wikitable\"\n|-\n! scope=\"col\" width=\"6%\" | Function Name\n! scope=\"col\" width=\"5%\" | Returns\n! scope=\"col\" width=\"10%\" | Arguments\n! scope=\"col\" width=\"10%\" | Throws\n! scope=\"col\" width=\"61%\" | Description\n! scope=\"col\" width=\"3%\" | Since\n! scope=\"col\" width=\"5%\" | Restricted\n");
            } else if (type == MarkupType.TEXT) {
                intro.append("\n").append(className).append("\n");
                intro.append("**********************************************************************************************\n");
                if (className != null) {
                    intro.append(classDocs == null ? "" : classDocs).append("\n");
                } else {
                    intro.append("Other Functions\n");
                }
                intro.append("**********************************************************************************************\n");
            }
            ArrayList<FunctionBase> documentableFunctions = new ArrayList<FunctionBase>();
            for (FunctionBase f : (ArrayList)entry.getValue()) {
                if (!f.appearInDocumentation()) continue;
                documentableFunctions.add(f);
            }
            if (!documentableFunctions.isEmpty()) {
                out.append(intro.toString() + "\n");
            }
            Collections.sort(documentableFunctions, new Comparator<FunctionBase>(){

                @Override
                public int compare(FunctionBase o1, FunctionBase o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (FunctionBase f : documentableFunctions) {
                ++total;
                String doc = f.docs();
                String restricted = f instanceof Function && ((Function)f).isRestricted() ? "<div style=\"background-color: red; font-weight: bold; text-align: center;\">Yes</div>" : "<div style=\"background-color: green; font-weight: bold; text-align: center;\">No</div>";
                StringBuilder thrown = new StringBuilder();
                if (f instanceof Function && ((Function)f).thrown() != null) {
                    List<Class<? extends CREThrowable>> thrownList = Arrays.asList(((Function)f).thrown());
                    for (int i = 0; i < thrownList.size(); ++i) {
                        String t = thrownList.get(i).getAnnotation(typeof.class).value();
                        if (type == MarkupType.HTML || type == MarkupType.TEXT) {
                            if (i != 0) {
                                thrown.append(type == MarkupType.HTML ? "<br />\n" : " | ");
                            }
                            thrown.append(t);
                            continue;
                        }
                        if (i != 0) {
                            thrown.append("<br />\n");
                        }
                        thrown.append("[[CommandHelper/Exceptions#").append(t).append("|").append(t).append("]]");
                    }
                }
                String since = f instanceof Documentation ? ((Documentation)((Object)f)).since().toString() : "0.0.0";
                DocInfo di = new DocInfo(doc);
                boolean hasExample = false;
                if (f instanceof Function && ((Function)f).examples() != null && ((Function)f).examples().length > 0) {
                    hasExample = true;
                    ++workingExamples;
                }
                if (di.ret == null || di.args == null || di.desc == null) {
                    out.append(f.getName() + "'s documentation is not correctly formatted. Please check it and try again.\n");
                }
                if (type == MarkupType.HTML) {
                    out.append("<tr><td>" + di.ret + "</td><td>" + di.args + "</td><td>" + thrown.toString() + "</td><td>" + di.desc + "</td><td>" + since + "</td><td>" + restricted + "</td></tr>\n");
                    continue;
                }
                if (type == MarkupType.WIKI) {
                    out.append("|- id=\"" + f.getName() + "\"\n! scope=\"row\" | [[CommandHelper/" + (staged ? "Staged/" : "") + "API/" + f.getName() + "|" + f.getName() + "]]()\n| " + di.ret + "\n| " + di.args + "\n| " + thrown.toString() + "\n| " + (di.topDesc != null ? di.topDesc + " [[CommandHelper/" + (staged ? "Staged/" : "") + "API/" + f.getName() + "#Description|See More...]]" : di.desc) + (hasExample ? "<br />([[CommandHelper/" + (staged ? "Staged/" : "") + "API/" + f.getName() + "#Examples|Examples...]])" : "") + "\n| " + since + "\n| " + restricted + "\n");
                    continue;
                }
                if (type != MarkupType.TEXT) continue;
                out.append(di.ret + " " + f.getName() + "(" + di.args + ") {" + thrown.toString() + "}\n\t" + di.desc + "\n\t" + since + (f instanceof Function && ((Function)f).isRestricted() ? "\n\tThis function is restricted" : "\n\tThis function is not restricted\n"));
            }
            if (documentableFunctions.isEmpty()) continue;
            if (type == MarkupType.HTML) {
                out.append("</table>\n");
                continue;
            }
            if (type == MarkupType.WIKI) {
                out.append("|}\n{{Back to top}}\n");
                continue;
            }
            if (type != MarkupType.TEXT) continue;
            out.append("\n");
        }
        if (type == MarkupType.HTML) {
            out.append("<h2>Errors in documentation</h2>\n<em>Please note that this documentation is generated automatically, if you notice an error in the documentation, please file a bug report for the plugin itself!</em><div style='text-size:small; text-decoration:italics; color:grey'>There are " + total + " functions in this API page</div>\n");
        } else if (type == MarkupType.WIKI) {
            out.append("===Errors in documentation===\n''Please note that this documentation is generated automatically, if you notice an error in the documentation, please file a bug report for the plugin itself!'' For information on undocumented functions, see [[CommandHelper/Sandbox|this page]]<div style='font-size:xx-small; font-style:italic; color:grey'>There are " + total + " functions in this API page, " + workingExamples + " of which have examples.</div>\n\n{{Back to top}}\n{{LearningTrail}}\n");
        }
        return out.toString();
    }

    public static String Template(String template, boolean staged) {
        HashMap<String, String> customTemplates = new HashMap<String, String>();
        customTemplates.put("staged", staged ? "Staged/" : "");
        return DocGenTemplates.Generate(template, customTemplates);
    }

    public static String events(MarkupType type) {
        Set<Class<?>> classes = ClassDiscovery.getDefaultInstance().loadClassesWithAnnotation(api.class);
        TreeSet<Documentation> list = new TreeSet<Documentation>();
        for (Class<?> c : classes) {
            if (!Event.class.isAssignableFrom(c) || !Documentation.class.isAssignableFrom(c)) continue;
            try {
                Constructor<?> cons = c.getConstructor(new Class[0]);
                Documentation docs = (Documentation)cons.newInstance(new Object[0]);
                list.add(docs);
            }
            catch (Exception ex) {
                StreamUtils.GetSystemErr().println("Could not get documentation for " + c.getSimpleName());
            }
        }
        StringBuilder doc = new StringBuilder();
        if (type == MarkupType.HTML) {
            doc.append("Events allow you to trigger scripts not just on commands, but also on other actions, such as a player logging in, or a player breaking a block. See the documentation on events for more information<table><thead><tr><th>Name</th><th>Description</th><th>Prefilters</th><th>Event Data</th><th>Mutable Fields</th><th>Since</th></thead><tbody>");
        } else if (type == MarkupType.WIKI) {
            doc.append("Events allow you to trigger scripts not just on commands, but also on other actions, such as a player logging in, or a player breaking a block. See the [[CommandHelper/Events|documentation on events]] for more information<br />\n\n");
            doc.append("{| width=\"100%\" cellspacing=\"1\" cellpadding=\"1\" border=\"1\" class=\"wikitable\"\n|-\n! scope=\"col\" width=\"7%\" | Event Name\n! scope=\"col\" width=\"36%\" | Description\n! scope=\"col\" width=\"18%\" | Prefilters\n! scope=\"col\" width=\"18%\" | Event Data\n! scope=\"col\" width=\"18%\" | Mutable Fields\n! scope=\"col\" width=\"3%\" | Since\n");
        } else if (type == MarkupType.TEXT) {
            doc.append("Events allow you to trigger scripts not just on commands, but also on other actions, such as a player logging in, or a player breaking a block. See the documentation on events for more information\n\n\n");
        }
        Pattern p2 = Pattern.compile("\\{(.*?)\\} *?(.*?) *?\\{(.*?)\\} *?\\{(.*?)\\}");
        for (Documentation d : list) {
            Matcher m = p2.matcher(d.docs());
            if (!m.find()) continue;
            String name = d.getName();
            String description = m.group(2).trim();
            String prefilter = PrefilterData.Get(m.group(1).split("\\|"), type);
            String eventData = EventData.Get(m.group(3).split("\\|"), type);
            String mutability = MutabilityData.Get(m.group(4).split("\\|"), type);
            String since = d.since().toString();
            if (type == MarkupType.HTML) {
                doc.append("<tr><td style=\"vertical-align:top\">").append(name).append("</td><td style=\"vertical-align:top\">").append(description).append("</td><td style=\"vertical-align:top\">").append(prefilter).append("</td><td style=\"vertical-align:top\">").append(eventData).append("</td><td style=\"vertical-align:top\">").append(mutability).append("</td><td style=\"vertical-align:top\">").append(since).append("</td></tr>\n");
                continue;
            }
            if (type == MarkupType.WIKI) {
                doc.append("|-\n! scope=\"row\" | [[CommandHelper/Event API/").append(name).append("|").append(name).append("]]\n| ").append(description).append("\n| ").append(prefilter).append("\n| ").append(eventData).append("\n| ").append(mutability).append("\n| ").append(since).append("\n");
                continue;
            }
            if (type != MarkupType.TEXT) continue;
            doc.append("Name: ").append(name).append("\nDescription: ").append(description).append("\nPrefilters:\n").append(prefilter).append("\nEvent Data:\n").append(eventData).append("\nMutable Fields:\n").append(mutability).append("\nSince: ").append(since).append("\n\n");
        }
        if (type == MarkupType.HTML) {
            doc.append("</tbody></table>\n");
        } else if (type == MarkupType.WIKI) {
            doc.append("|}\n");
        }
        if (type == MarkupType.HTML) {
            doc.append("<h2>Errors in documentation</h2>\n<em>Please note that this documentation is generated automatically, if you notice an error in the documentation, please file a bug report for the plugin itself!</em>\n");
        } else if (type == MarkupType.WIKI) {
            doc.append("===Errors in documentation===\n''Please note that this documentation is generated automatically, if you notice an error in the documentation, please file a bug report for the plugin itself!'' For information on undocumented functions, see [[CommandHelper/Sandbox|this page]]\n\n{{LearningTrail}}\n");
        }
        return doc.toString();
    }

    public static enum MarkupType {
        HTML,
        WIKI,
        TEXT,
        MARKDOWN;

    }

    public static class DocInfo {
        public String ret;
        public String args;
        public String originalArgs;
        public String desc;
        public String topDesc = null;
        public String extendedDesc = null;

        public DocInfo(String doc) {
            Pattern p2 = Pattern.compile("(?s)\\s*(.*?)\\s*\\{(.*?)\\}\\s*(.*)\\s*");
            Matcher m = p2.matcher(doc);
            if (m.find()) {
                this.ret = m.group(1);
                this.originalArgs = m.group(2);
                this.desc = m.group(3);
                if (this.desc.contains("----")) {
                    String[] parts = this.desc.split("----", 2);
                    this.desc = this.topDesc = parts[0].trim();
                    this.extendedDesc = parts[1].trim();
                }
            } else {
                throw new IllegalArgumentException("Could not generate DocInfo from string: " + doc);
            }
            this.args = this.originalArgs.replaceAll("\\|", "<hr />").replaceAll("\\[(.*?)\\]", "<strong>[</strong>$1<strong>]</strong>");
        }
    }

    public static class EventDocInfo {
        public final String description;
        public final List<PrefilterData> prefilter;
        public final List<EventData> eventData;
        public final List<MutabilityData> mutability;
        private static final Pattern EVENT_PATTERN = Pattern.compile("\\{(.*?)\\} *?(.*?) *?\\{(.*?)\\} *?\\{(.*?)\\}");

        public EventDocInfo(String docs, String eventName) {
            Matcher m = EVENT_PATTERN.matcher(docs);
            if (m.find()) {
                String[] d;
                this.description = m.group(2).trim();
                this.prefilter = new ArrayList<PrefilterData>();
                for (String p2 : m.group(1).split("\\|")) {
                    if ("".equals(p2)) continue;
                    d = p2.split(":");
                    this.prefilter.add(new PrefilterData(d[0], d.length > 1 ? d[1] : ""));
                }
                this.eventData = new ArrayList<EventData>();
                for (String e : m.group(3).split("\\|")) {
                    if ("".equals(e)) continue;
                    d = e.split(":");
                    this.eventData.add(new EventData(d[0], d.length > 1 ? d[1] : ""));
                }
                this.mutability = new ArrayList<MutabilityData>();
                for (String mu : m.group(4).split("\\|")) {
                    if ("".equals(mu)) continue;
                    d = mu.split(":");
                    this.mutability.add(new MutabilityData(d[0], d.length > 1 ? d[1] : ""));
                }
            } else {
                throw new RuntimeException("Invalid data from " + eventName + ": " + docs);
            }
        }

        public static class MutabilityData {
            public final String name;
            public final String description;

            public MutabilityData(String name, String description) {
                Objects.requireNonNull(name, "name must not be null");
                if (description == null) {
                    description = "";
                }
                this.name = name.trim();
                this.description = description.trim();
            }
        }

        public static class EventData {
            public final String name;
            public final String description;

            public EventData(String name, String description) {
                Objects.requireNonNull(name, "name must not be null");
                if (description == null) {
                    description = "";
                }
                this.name = name.trim();
                this.description = description.trim();
            }
        }

        public static class PrefilterData {
            public final String name;
            public final String description;

            public PrefilterData(String name, String description) {
                Objects.requireNonNull(name, "name must not be null");
                if (description == null) {
                    description = "";
                }
                this.name = name.trim();
                this.description = description.trim();
            }

            public String formatDescription(MarkupType type) {
                return com.laytonsmith.tools.docgen.DocGen$PrefilterData.ExpandMacro(this.description, type);
            }
        }
    }

    public static class MutabilityData {
        public static String Get(String[] data, MarkupType type) {
            StringBuilder b = new StringBuilder();
            boolean first = true;
            if (data.length == 1 && "".equals(data[0].trim())) {
                return "";
            }
            for (String d : data) {
                int split2 = d.indexOf(58);
                if (split2 == -1) {
                    if (type == MarkupType.HTML) {
                        b.append(first ? "" : "<br />").append("<strong>").append(d.trim()).append("</strong>");
                    } else if (type == MarkupType.WIKI) {
                        b.append(first ? "" : "<br />").append("'''").append(d.trim()).append("'''");
                    } else if (type == MarkupType.TEXT) {
                        b.append(first ? "" : "\n").append("\t").append(d.trim());
                    } else if (type == MarkupType.MARKDOWN) {
                        b.append(first ? "" : "  \n").append("**").append(d.trim()).append("**");
                    }
                } else {
                    String name = d.substring(0, split2).trim();
                    String description = d.substring(split2).trim();
                    if (type == MarkupType.HTML) {
                        b.append(first ? "" : "<br />").append("<strong>").append(name).append("</strong>: ").append(description);
                    } else if (type == MarkupType.WIKI) {
                        b.append(first ? "" : "<br />").append("'''").append(name).append("''': ").append(description);
                    } else if (type == MarkupType.TEXT) {
                        b.append(first ? "" : "\n").append("\t").append(name).append(": ").append(description);
                    } else if (type == MarkupType.MARKDOWN) {
                        b.append(first ? "" : "  \n").append("**").append(name).append("**: ").append(description);
                    }
                }
                first = false;
            }
            return b.toString();
        }
    }

    public static class EventData {
        public static String Get(String[] data, MarkupType type) {
            StringBuilder b = new StringBuilder();
            boolean first = true;
            if (data.length == 1 && "".equals(data[0].trim())) {
                return "";
            }
            for (String d : data) {
                String description;
                String name;
                int split2 = d.indexOf(58);
                if (split2 == -1) {
                    name = d;
                    description = "";
                } else {
                    name = d.substring(0, split2).trim();
                    description = d.substring(split2 + 1).trim();
                }
                if (type == MarkupType.HTML) {
                    b.append(first ? "" : "<br />").append("<strong>").append(name).append("</strong>: ").append(description);
                } else if (type == MarkupType.WIKI) {
                    b.append(first ? "" : "<br />").append("'''").append(name).append("''': ").append(description);
                } else if (type == MarkupType.TEXT) {
                    b.append(first ? "" : "\n").append("\t").append(name).append(": ").append(description);
                } else if (type == MarkupType.MARKDOWN) {
                    b.append(first ? "" : "  \n").append("**").append(name).append("**").append(": ").append(description);
                }
                first = false;
            }
            return b.toString();
        }
    }

    public static class PrefilterData {
        public static String Get(String[] data, MarkupType type) {
            StringBuilder b = new StringBuilder();
            boolean first = true;
            if (data.length == 1 && "".equals(data[0].trim())) {
                return "";
            }
            for (String d : data) {
                String description;
                String name;
                int split2 = d.indexOf(58);
                if (split2 == -1) {
                    name = d;
                    description = "";
                } else {
                    name = d.substring(0, split2).trim();
                    description = PrefilterData.ExpandMacro(d.substring(split2 + 1).trim(), type);
                }
                if (type == MarkupType.HTML) {
                    b.append(first ? "" : "<br />").append("<strong>").append(name).append("</strong>: ").append(description);
                } else if (type == MarkupType.WIKI) {
                    b.append(first ? "" : "<br />").append("'''").append(name).append("''': ").append(description);
                } else if (type == MarkupType.TEXT) {
                    b.append(first ? "" : "\n").append("\t").append(name).append(": ").append(description);
                } else if (type == MarkupType.MARKDOWN) {
                    b.append(first ? "" : "  \n").append("**").append(name).append("**: ").append(description);
                }
                first = false;
            }
            return b.toString();
        }

        private static String ExpandMacro(String macro, MarkupType type) {
            if (type == MarkupType.HTML) {
                return "<em>" + macro.replaceAll("<string match>", "&lt;String Match&gt;").replaceAll("<boolean match>", "&lt;Boolean Match&gt;").replaceAll("<regex>", "&lt;Regex&gt;").replaceAll("<item match>", "&lt;Item Match&gt;").replaceAll("<location match>", "&lt;Location Match&gt;").replaceAll("<math match>", "&lt;Math Match&gt;").replaceAll("<macro>", "&lt;Macro&gt;").replaceAll("<expression>", "&lt;Expression&gt;") + "</em>";
            }
            if (type == MarkupType.WIKI) {
                return macro.replaceAll("<string match>", "[[CommandHelper/Events/Prefilters#String Match|String Match]]").replaceAll("<boolean match>", "[[CommandHelper/Events/Prefilters#Boolean Match|Boolean Match]]").replaceAll("<regex>", "[[CommandHelper/Events/Prefilters#Regex|Regex]]").replaceAll("<item match>", "[[CommandHelper/Events/Prefilters#Item Match|Item Match]]").replaceAll("<location match>", "[[CommandHelper/Events/Prefilters#Location Match|Location Match]]").replaceAll("<math match>", "[[CommandHelper/Events/Prefilters#Math Match|Math Match]]").replaceAll("<macro>", "[[CommandHelper/Events/Prefilters#Macro|Macro]]").replaceAll("<expression>", "[[CommandHelper/Events/Prefilters#Expression|Expression]]");
            }
            if (type == MarkupType.TEXT || type == MarkupType.MARKDOWN) {
                return macro.replaceAll("<string match>", "<String Match>").replaceAll("<boolean match>", "<Boolean Match>").replaceAll("<regex>", "<Regex>").replaceAll("<item match>", "<Item Match>").replaceAll("<location match>", "<Location Match>").replaceAll("<math match>", "<Math Match>").replaceAll("<macro>", "<Macro>").replaceAll("<expression>", "<Expression>");
            }
            return macro;
        }
    }
}

