/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities;

import com.laytonsmith.PureUtilities.ArgumentParser;
import com.laytonsmith.PureUtilities.Common.ArrayUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.TermColors;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class ArgumentSuite {
    private final Map<String, ArgumentParser> suite = new LinkedHashMap<String, ArgumentParser>();
    private final Map<String, String> aliases = new LinkedHashMap<String, String>();
    private String description;

    public ArgumentSuite addMode(String modeName, ArgumentParser mode2) {
        this.validateModeName(modeName);
        this.suite.put(modeName, mode2);
        return this;
    }

    public ArgumentSuite addModeAlias(String alias, String realModeName) {
        this.validateModeName(alias);
        this.aliases.put(alias, realModeName);
        return this;
    }

    private void validateModeName(String modeName) {
        if (modeName.contains(" ")) {
            throw new IllegalArgumentException("The mode name may not contain a space.");
        }
    }

    public ArgumentSuite addDescription(String description) {
        this.description = description;
        return this;
    }

    public ArgumentParser getMode(String name) {
        if (this.suite.containsKey(name)) {
            return this.suite.get(name);
        }
        throw new IllegalArgumentException("No mode by the name \"" + name + "\" has been registered.");
    }

    public ArgumentSuiteResults match(String[] args, String defaultMode) throws ArgumentParser.ResultUseException, ArgumentParser.ValidationException {
        String mode2;
        String[] nonModeArgs = ArrayUtils.EMPTY_STRING_ARRAY;
        if (args.length > 1) {
            mode2 = args[0];
            nonModeArgs = ArrayUtils.cast(ArrayUtils.slice(args, 1, args.length - 1), String[].class);
        } else {
            mode2 = args.length == 1 ? args[0] : defaultMode;
        }
        if (this.aliases.containsKey(mode2)) {
            mode2 = this.aliases.get(mode2);
        }
        if (this.suite.containsKey(mode2)) {
            return new ArgumentSuiteResults(mode2, this.suite.get(mode2), this.suite.get(mode2).match(nonModeArgs));
        }
        throw new ArgumentParser.ResultUseException("Mode " + mode2 + " was not found.");
    }

    public ArgumentSuiteResults match(String args, String defaultMode) throws ArgumentParser.ResultUseException, ArgumentParser.ValidationException {
        return this.match(ArgumentParser.lex(args).toArray(new String[0]), defaultMode);
    }

    public String getBuiltDescription() {
        StringBuilder b = new StringBuilder();
        if (this.description != null) {
            b.append(this.description).append("\n\n");
        }
        b.append("Modes: (a mode must be the first argument) \n");
        for (String mode2 : this.suite.keySet()) {
            b.append("\t").append(TermColors.BOLD).append(mode2);
            if (this.aliases.containsValue(mode2)) {
                ArrayList<String> keys = new ArrayList<String>();
                for (String alias : this.aliases.keySet()) {
                    if (!this.aliases.get(alias).equals(mode2)) continue;
                    keys.add(alias);
                }
                b.append(TermColors.RESET).append(" (Alias");
                if (keys.size() != 1) {
                    b.append("es");
                }
                b.append(": ").append(StringUtils.Join(keys, ", ")).append(")");
            }
            b.append(TermColors.RESET).append(": ").append(this.suite.get(mode2).getDescription()).append("\n");
        }
        return b.toString();
    }

    public String getModeFromAlias(String alias) {
        if (alias == null) {
            return null;
        }
        if (this.suite.containsKey(alias)) {
            return alias;
        }
        if (this.aliases.containsKey(alias)) {
            return this.aliases.get(alias);
        }
        return null;
    }

    public ArgumentParser getModeFromName(String mode2) {
        if (mode2 == null) {
            return null;
        }
        if (this.suite.containsKey(mode2)) {
            return this.suite.get(mode2);
        }
        return null;
    }

    public static final class ArgumentSuiteResults {
        private final ArgumentParser mode;
        private final ArgumentParser.ArgumentParserResults results;
        private final String modeName;

        private ArgumentSuiteResults(String modeName, ArgumentParser mode2, ArgumentParser.ArgumentParserResults results) {
            this.modeName = modeName;
            this.mode = mode2;
            this.results = results;
        }

        public String getModeName() {
            return this.modeName;
        }

        public ArgumentParser getMode() {
            return this.mode;
        }

        public ArgumentParser.ArgumentParserResults getResults() {
            return this.results;
        }
    }
}

