/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.ClassLoading;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscoveryCache;
import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscoveryURLCache;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.AbstractMethodMirror;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.ClassMirror;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.ClassMirrorVisitor;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.ClassReferenceMirror;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.ConstructorMirror;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.FieldMirror;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.MethodMirror;
import com.laytonsmith.PureUtilities.Common.ClassUtils;
import com.laytonsmith.PureUtilities.Common.FileUtil;
import com.laytonsmith.PureUtilities.Common.StackTraceUtils;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.Pair;
import com.laytonsmith.PureUtilities.ProgressIterator;
import com.laytonsmith.PureUtilities.ZipIterator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class ClassDiscovery {
    private static final boolean IS_DEBUG = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("jdwp");
    private static ClassDiscovery defaultInstance = null;
    private final Map<URL, Set<ClassMirror<?>>> classCache = new HashMap();
    private final Map<String, ClassMirror<?>> jvmNameToMirror = new HashMap();
    private final Map<String, ClassMirror<?>> fuzzyClassCache = new HashMap();
    private final Map<String, ClassMirror<?>> forNameCache = new HashMap();
    private final Set<URL> urlCache = new HashSet<URL>();
    private final Set<URL> dirtyURLs = new HashSet<URL>();
    private final Map<Class<?>, Set<ClassMirror<?>>> classSubtypeCache = new HashMap();
    private final Map<Class<? extends Annotation>, Set<ClassMirror<?>>> classAnnotationCache = new HashMap();
    private final Map<Class<? extends Annotation>, Set<FieldMirror>> fieldAnnotationCache = new HashMap<Class<? extends Annotation>, Set<FieldMirror>>();
    private final Map<Class<? extends Annotation>, Set<MethodMirror>> methodAnnotationCache = new HashMap<Class<? extends Annotation>, Set<MethodMirror>>();
    private final Map<Class<? extends Annotation>, Set<ConstructorMirror<?>>> constructorAnnotationCache = new HashMap();
    private final Map<Pair<Class<? extends Annotation>, Class<?>>, Set<ClassMirror<?>>> classesWithAnnotationThatExtendCache = new HashMap();
    private ProgressIterator progressIterator = null;
    private final Map<URL, ClassDiscoveryURLCache> preCaches = new HashMap<URL, ClassDiscoveryURLCache>();
    private boolean debug;
    private ClassDiscoveryCache classDiscoveryCache;
    private ClassLoader defaultClassLoader = null;

    public static synchronized ClassDiscovery getDefaultInstance() {
        if (defaultInstance == null) {
            defaultInstance = new ClassDiscovery();
        }
        return defaultInstance;
    }

    public static void setDefaultInstance(ClassDiscovery cd2) {
        defaultInstance = cd2;
    }

    public void setDebugMode(boolean on) {
        this.debug = on;
    }

    public void removePreCache(URL url) {
        if (url == null) {
            throw new NullPointerException("url cannot be null");
        }
        this.preCaches.remove(url);
    }

    public void addPreCache(URL url, ClassDiscoveryURLCache cache) {
        if (url == null) {
            throw new NullPointerException("url cannot be null");
        }
        if (this.debug) {
            StreamUtils.GetSystemOut().println("Adding precache for " + url);
        }
        this.preCaches.put(url, cache);
    }

    public void setClassDiscoveryCache(ClassDiscoveryCache cache) {
        this.classDiscoveryCache = cache;
    }

    public void setProgressIterator(ProgressIterator progressIterator) {
        this.progressIterator = progressIterator;
    }

    private synchronized void doDiscovery() {
        if (!this.dirtyURLs.isEmpty()) {
            Iterator<URL> it = this.dirtyURLs.iterator();
            while (it.hasNext()) {
                this.discover(it.next());
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void discover(URL rootLocation) {
        block34: {
            long start = System.currentTimeMillis();
            if (this.debug) {
                StreamUtils.GetSystemOut().println("Beginning discovery of " + rootLocation);
            }
            try {
                String url;
                if (this.classDiscoveryCache != null) {
                    ClassDiscoveryURLCache cduc = this.classDiscoveryCache.getURLCache(rootLocation);
                    this.preCaches.put(rootLocation, cduc);
                }
                try {
                    url = URLDecoder.decode(rootLocation.toString(), "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    url = null;
                }
                if (url == null) {
                    url = ClassDiscovery.GetClassContainer(ClassDiscovery.class).toString();
                }
                if (!this.classCache.containsKey(rootLocation)) {
                    this.classCache.put(rootLocation, Collections.synchronizedSet(new HashSet()));
                } else {
                    this.classCache.get(rootLocation).clear();
                }
                final Set<ClassMirror<?>> mirrors = this.classCache.get(rootLocation);
                if (this.preCaches.containsKey(rootLocation)) {
                    if (this.debug) {
                        StreamUtils.GetSystemOut().println("Precache already contains this URL, so using it");
                    }
                    mirrors.addAll(this.preCaches.get(rootLocation).getClasses());
                    return;
                }
                if (this.debug) {
                    StreamUtils.GetSystemOut().println("Precache does not contain data for this URL, so scanning now.");
                }
                if ((url = url.replaceFirst("^jar:", "")).endsWith("!/")) {
                    url = StringUtils.replaceLast(url, "!/", "");
                }
                if (url.startsWith("file:") && !url.endsWith(".jar")) {
                    AtomicInteger id = new AtomicInteger(0);
                    String root = url.substring(5);
                    File rootLocationFile = new File(root);
                    ArrayList<File> fileList = new ArrayList<File>();
                    ClassDiscovery.descend(new File(root), fileList);
                    for (File f : fileList) {
                        String file = f.toString();
                        if (file.matches(".*\\$(?:\\d)*\\.class") || !file.endsWith(".class")) continue;
                        InputStream stream = null;
                        try {
                            stream = FileUtil.readAsStream(new File(rootLocationFile, f.getAbsolutePath().replaceFirst(Pattern.quote(new File(root).getAbsolutePath() + File.separator), "")));
                            ClassReader reader = new ClassReader(stream);
                            ClassMirrorVisitor mirrorVisitor = new ClassMirrorVisitor();
                            reader.accept((ClassVisitor)mirrorVisitor, 7);
                            mirrors.add(mirrorVisitor.getMirror(new URL(url)));
                        }
                        catch (IOException ex) {
                            Logger.getLogger(ClassDiscovery.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        finally {
                            if (stream == null) continue;
                            try {
                                stream.close();
                            }
                            catch (IOException ex) {
                                Logger.getLogger(ClassDiscovery.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                    }
                    break block34;
                }
                if (url.startsWith("file:") && url.endsWith(".jar")) {
                    url = url.replaceFirst("file:", "");
                    final File rootLocationFile = new File(url);
                    ZipIterator zi = new ZipIterator(rootLocationFile);
                    try {
                        zi.iterate(new ZipIterator.ZipIteratorCallback(){

                            @Override
                            public void handle(String filename, InputStream in) {
                                if (!filename.matches(".*\\$(?:\\d)*\\.class") && filename.endsWith(".class")) {
                                    try {
                                        ClassReader reader = new ClassReader(in);
                                        ClassMirrorVisitor mirrorVisitor = new ClassMirrorVisitor();
                                        reader.accept((ClassVisitor)mirrorVisitor, 7);
                                        mirrors.add(mirrorVisitor.getMirror(rootLocationFile.toURI().toURL()));
                                    }
                                    catch (IOException ex) {
                                        Logger.getLogger(ClassDiscovery.class.getName()).log(Level.SEVERE, null, ex);
                                    }
                                }
                            }
                        }, this.progressIterator);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(ClassDiscovery.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    break block34;
                }
                throw new RuntimeException("Unknown url type: " + rootLocation);
            }
            catch (RuntimeException e) {
                e.printStackTrace(System.err);
            }
            finally {
                if (this.debug) {
                    StreamUtils.GetSystemOut().println("Scans finished for " + rootLocation + ", taking " + (System.currentTimeMillis() - start) + " ms.");
                }
            }
        }
    }

    public void setDefaultClassLoader(ClassLoader cl) {
        this.defaultClassLoader = cl;
    }

    public ClassLoader getDefaultClassLoader() {
        if (this.defaultClassLoader == null) {
            return ClassDiscovery.class.getClassLoader();
        }
        return this.defaultClassLoader;
    }

    public void addThisJar() {
        this.addDiscoveryLocation(ClassDiscovery.GetClassContainer(StackTraceUtils.getCallingClass()));
    }

    public synchronized void addDiscoveryLocation(URL url) {
        if (url == null) {
            throw new NullPointerException("url cannot be null");
        }
        if (this.urlCache.contains(url)) {
            return;
        }
        this.urlCache.add(url);
        this.dirtyURLs.add(url);
        this.classCache.put(url, new HashSet());
    }

    public void addAllJarsInFolder(File folder) {
        if (folder != null && folder.exists() && folder.isDirectory()) {
            for (File f : folder.listFiles()) {
                if (!f.getName().endsWith(".jar")) continue;
                try {
                    this.addDiscoveryLocation(f.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
    }

    public synchronized void removeDiscoveryLocation(URL url) {
        if (url == null) {
            throw new NullPointerException("url cannot be null");
        }
        if (!this.urlCache.contains(url)) {
            return;
        }
        this.urlCache.remove(url);
        this.dirtyURLs.remove(url);
        this.preCaches.remove(url);
        this.invalidateCaches();
    }

    public void invalidateCaches() {
        this.classCache.clear();
        this.forNameCache.clear();
        this.jvmNameToMirror.clear();
        this.fuzzyClassCache.clear();
        this.classAnnotationCache.clear();
        this.fieldAnnotationCache.clear();
        this.methodAnnotationCache.clear();
        this.constructorAnnotationCache.clear();
        this.classesWithAnnotationThatExtendCache.clear();
        this.dirtyURLs.addAll(this.urlCache);
    }

    public Set<ClassMirror<?>> getKnownClasses() {
        this.doDiscovery();
        HashSet ret = new HashSet();
        for (URL url : this.urlCache) {
            ret.addAll(this.getKnownClasses(url));
        }
        return ret;
    }

    public List<ClassMirror<?>> getKnownClasses(URL url) {
        if (url == null) {
            throw new NullPointerException("url cannot be null");
        }
        if (!this.classCache.containsKey(url)) {
            this.addDiscoveryLocation(url);
        }
        this.doDiscovery();
        return new ArrayList((Collection)this.classCache.get(url));
    }

    public <T> Set<ClassMirror<T>> getClassesThatExtend(Class<T> superType) {
        if (superType == Object.class) {
            return this.getKnownClasses();
        }
        if (this.classSubtypeCache.containsKey(superType)) {
            return new HashSet<ClassMirror<T>>(this.classSubtypeCache.get(superType));
        }
        this.doDiscovery();
        HashSet<ClassMirror<T>> mirrors = new HashSet<ClassMirror<T>>();
        Set<ClassMirror<?>> knownClasses = this.getKnownClasses();
        for (ClassMirror<?> m : knownClasses) {
            if (!this.doesClassExtend(m, superType)) continue;
            mirrors.add(m);
        }
        this.classSubtypeCache.put(superType, mirrors);
        return mirrors;
    }

    public boolean doesClassExtend(ClassMirror<?> subClass, Class<?> superClass) {
        if (subClass.directlyExtendsFrom(superClass)) {
            return true;
        }
        HashSet<ClassReferenceMirror> supers = new HashSet<ClassReferenceMirror>();
        if (!subClass.isInterface()) {
            ClassReferenceMirror<Object> su = subClass.getSuperClass();
            while (!"Ljava/lang/Object;".equals(su.getJVMName())) {
                supers.add(su);
                ClassMirror<?> find = this.getClassMirrorFromJVMName(su.getJVMName());
                if (find == null) {
                    try {
                        Class clazz = ClassUtils.forCanonicalName(su.toString(), false, this.defaultClassLoader);
                        if (superClass.isAssignableFrom(clazz)) {
                            return true;
                        }
                        su = new ClassReferenceMirror("L" + clazz.getSuperclass().getName().replace('.', '/') + ";");
                        continue;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        return false;
                    }
                }
                su = find.getSuperClass();
            }
            for (ClassReferenceMirror classReferenceMirror : supers) {
                if (!classReferenceMirror.getJVMName().equals(ClassUtils.getJVMName(superClass))) continue;
                return true;
            }
        }
        ArrayDeque interfaces = new ArrayDeque();
        HashSet<ClassReferenceMirror> handled = new HashSet<ClassReferenceMirror>();
        interfaces.addAll(subClass.getInterfaces());
        for (ClassReferenceMirror r : supers) {
            ClassMirror<?> find = this.getClassMirrorFromJVMName(r.getJVMName());
            if (find == null) {
                try {
                    Class<?> clazz = Class.forName(r.toString());
                    for (Class<?> c : clazz.getInterfaces()) {
                        interfaces.add(new ClassReferenceMirror("L" + c.getName().replace('.', '/') + ";"));
                    }
                    continue;
                }
                catch (ClassNotFoundException ex) {
                    return false;
                }
            }
            interfaces.addAll(find.getInterfaces());
        }
        while (!interfaces.isEmpty()) {
            ClassReferenceMirror classReferenceMirror = (ClassReferenceMirror)interfaces.pop();
            if (ClassUtils.getJVMName(superClass).equals(classReferenceMirror.getJVMName())) {
                return true;
            }
            if (handled.contains(classReferenceMirror)) continue;
            handled.add(classReferenceMirror);
            supers.add(classReferenceMirror);
            ClassMirror<?> find = this.getClassMirrorFromJVMName(classReferenceMirror.getJVMName());
            if (find != null) {
                interfaces.addAll(find.getInterfaces());
                continue;
            }
            try {
                Class clazz = ClassUtils.forCanonicalName(classReferenceMirror.toString(), false, this.getDefaultClassLoader());
                if (!superClass.isAssignableFrom(clazz)) continue;
                return true;
            }
            catch (ClassNotFoundException ex) {
                return false;
            }
        }
        return false;
    }

    public <T> Set<Class<T>> loadClassesThatExtend(Class<T> superType) {
        return this.loadClassesThatExtend(superType, this.getDefaultClassLoader(), true);
    }

    public <T> Set<Class<T>> loadClassesThatExtend(Class<T> superType, ClassLoader loader, boolean initialize) {
        HashSet<Class<T>> set = new HashSet<Class<T>>();
        for (ClassMirror<T> cm : this.getClassesThatExtend(superType)) {
            set.add(cm.loadClass(loader, initialize));
        }
        return set;
    }

    private ClassMirror<?> getClassMirrorFromJVMName(String className) {
        if (this.jvmNameToMirror.containsKey(className)) {
            return this.jvmNameToMirror.get(className);
        }
        for (ClassMirror<?> c : this.getKnownClasses()) {
            if (!c.getJVMClassName().equals(className)) continue;
            this.jvmNameToMirror.put(c.getJVMClassName(), c);
            return c;
        }
        this.jvmNameToMirror.put(className, null);
        return null;
    }

    public Set<ClassMirror<?>> getClassesWithAnnotation(Class<? extends Annotation> annotation) {
        if (this.classAnnotationCache.containsKey(annotation)) {
            return new HashSet((Collection)this.classAnnotationCache.get(annotation));
        }
        this.doDiscovery();
        HashSet mirrors = new HashSet();
        for (ClassMirror<?> m : this.getKnownClasses()) {
            if (!m.hasAnnotation(annotation)) continue;
            mirrors.add(m);
        }
        this.classAnnotationCache.put(annotation, mirrors);
        return mirrors;
    }

    public <T> Set<ClassMirror<? extends T>> getClassesWithAnnotationThatExtend(Class<? extends Annotation> annotation, Class<T> superClass) {
        Pair<Class<Annotation>, Class<T>> id = new Pair<Class<Annotation>, Class<T>>(annotation, superClass);
        if (this.classesWithAnnotationThatExtendCache.containsKey(id)) {
            return this.classesWithAnnotationThatExtendCache.get(id);
        }
        HashSet<ClassMirror<T>> mirrors = new HashSet<ClassMirror<T>>();
        for (ClassMirror<?> c : this.getClassesWithAnnotation(annotation)) {
            if (!this.doesClassExtend(c, superClass)) continue;
            mirrors.add(c);
        }
        if (superClass.getAnnotation(annotation) != null) {
            mirrors.add(new ClassMirror(superClass));
        }
        this.classesWithAnnotationThatExtendCache.put(id, (Set)mirrors);
        return mirrors;
    }

    public <T> Set<Class<? extends T>> loadClassesWithAnnotationThatExtend(Class<? extends Annotation> annotation, Class<T> superClass) {
        return this.loadClassesWithAnnotationThatExtend(annotation, superClass, this.getDefaultClassLoader(), true);
    }

    public <T> Set<Class<? extends T>> loadClassesWithAnnotationThatExtend(Class<? extends Annotation> annotation, Class<T> superClass, ClassLoader loader, boolean initialize) {
        HashSet<Class<T>> set = new HashSet<Class<T>>();
        for (ClassMirror<T> cm : this.getClassesWithAnnotationThatExtend(annotation, superClass)) {
            try {
                set.add(cm.loadClass(loader, initialize));
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
        }
        return set;
    }

    public Set<Class<?>> loadClassesWithAnnotation(Class<? extends Annotation> annotation) {
        return this.loadClassesWithAnnotation(annotation, this.getDefaultClassLoader(), true);
    }

    public Set<Class<?>> loadClassesWithAnnotation(Class<? extends Annotation> annotation, ClassLoader loader, boolean initialize) {
        HashSet set = new HashSet();
        for (ClassMirror<?> cm : this.getClassesWithAnnotation(annotation)) {
            try {
                set.add(cm.loadClass(loader, initialize));
            }
            catch (NoClassDefFoundError e) {
                if (!IS_DEBUG) continue;
                System.err.println("While trying to process " + cm.toString() + ", an error occurred. It it probably safe to ignore this error, but if you're debugging to figure out why an expected class is not showing up, then this is probably why.");
                e.printStackTrace(System.err);
            }
        }
        return set;
    }

    public Set<FieldMirror> getFieldsWithAnnotation(Class<? extends Annotation> annotation) {
        if (this.fieldAnnotationCache.containsKey(annotation)) {
            return new HashSet<FieldMirror>((Collection)this.fieldAnnotationCache.get(annotation));
        }
        this.doDiscovery();
        HashSet<FieldMirror> mirrors = new HashSet<FieldMirror>();
        for (ClassMirror<?> m : this.getKnownClasses()) {
            for (FieldMirror f : m.getFields()) {
                if (!f.hasAnnotation((Class)annotation)) continue;
                mirrors.add(f);
            }
        }
        this.fieldAnnotationCache.put(annotation, mirrors);
        return mirrors;
    }

    public Set<Field> loadFieldsWithAnnotation(Class<? extends Annotation> annotation) {
        return this.loadFieldsWithAnnotation(annotation, ClassDiscovery.class.getClassLoader(), true);
    }

    public Set<Field> loadFieldsWithAnnotation(Class<? extends Annotation> annotation, ClassLoader loader, boolean initialize) {
        HashSet<Field> ret = new HashSet<Field>();
        for (FieldMirror fm : this.getFieldsWithAnnotation(annotation)) {
            try {
                Field f = fm.loadField(loader, initialize);
                ret.add(f);
            }
            catch (ClassNotFoundException ex) {
                throw new NoClassDefFoundError(ex.getMessage());
            }
        }
        return ret;
    }

    public Set<MethodMirror> getMethodsWithAnnotation(Class<? extends Annotation> annotation) {
        if (this.methodAnnotationCache.containsKey(annotation)) {
            return new HashSet<MethodMirror>((Collection)this.methodAnnotationCache.get(annotation));
        }
        this.doDiscovery();
        HashSet<MethodMirror> mirrors = new HashSet<MethodMirror>();
        for (ClassMirror<?> m : this.getKnownClasses()) {
            for (MethodMirror mm : m.getMethods()) {
                if (!mm.hasAnnotation((Class)annotation)) continue;
                mirrors.add(mm);
            }
        }
        this.methodAnnotationCache.put(annotation, mirrors);
        return mirrors;
    }

    public Set<Method> loadMethodsWithAnnotation(Class<? extends Annotation> annotation) {
        return this.loadMethodsWithAnnotation(annotation, this.getDefaultClassLoader(), true);
    }

    public Set<Method> loadMethodsWithAnnotation(Class<? extends Annotation> annotation, ClassLoader loader, boolean initialize) {
        try {
            HashSet<Method> set = new HashSet<Method>();
            for (MethodMirror mm : this.getMethodsWithAnnotation(annotation)) {
                set.add(mm.loadMethod(loader, initialize));
            }
            return set;
        }
        catch (ClassNotFoundException ex) {
            throw new NoClassDefFoundError(ex.getMessage());
        }
    }

    public Set<ConstructorMirror<?>> getConstructorsWithAnnotation(Class<? extends Annotation> annotation) {
        if (this.constructorAnnotationCache.containsKey(annotation)) {
            return new HashSet((Collection)this.constructorAnnotationCache.get(annotation));
        }
        this.doDiscovery();
        HashSet mirrors = new HashSet();
        for (ClassMirror<?> m : this.getKnownClasses()) {
            for (ConstructorMirror<?> mm : m.getConstructors()) {
                if (!mm.hasAnnotation(annotation)) continue;
                mirrors.add(mm);
            }
        }
        this.constructorAnnotationCache.put(annotation, mirrors);
        return mirrors;
    }

    public Set<Constructor<?>> loadConstructorsWithAnnotation(Class<? extends Annotation> annotation) {
        return this.loadConstructorsWithAnnotation(annotation, this.getDefaultClassLoader(), true);
    }

    public Set<Constructor<?>> loadConstructorsWithAnnotation(Class<? extends Annotation> annotation, ClassLoader loader, boolean initialize) {
        HashSet set = new HashSet();
        for (AbstractMethodMirror abstractMethodMirror : this.getConstructorsWithAnnotation(annotation)) {
            try {
                Class c = abstractMethodMirror.getDeclaringClass().loadClass(loader, initialize);
                block3: for (Constructor<?> cc : c.getDeclaredConstructors()) {
                    Class<?>[] params = cc.getParameterTypes();
                    if (abstractMethodMirror.getParams().size() != params.length) continue;
                    for (int i = 0; i < params.length; ++i) {
                        ClassReferenceMirror crm2;
                        ClassReferenceMirror crm = abstractMethodMirror.getParams().get(i);
                        if (!crm.equals(crm2 = new ClassReferenceMirror(ClassUtils.getJVMName(params[i])))) continue block3;
                    }
                    set.add(cc);
                }
            }
            catch (ClassNotFoundException ex) {
                throw new NoClassDefFoundError();
            }
        }
        return set;
    }

    public ClassMirror<?> forName(String className) throws ClassNotFoundException {
        if (this.forNameCache.containsKey(className)) {
            return this.forNameCache.get(className);
        }
        for (ClassMirror<?> c : this.getKnownClasses()) {
            if (!c.getClassName().equals(className) && !c.getJVMClassName().equals(className)) continue;
            this.forNameCache.put(className, c);
            return c;
        }
        throw new ClassNotFoundException(className);
    }

    public ClassMirror<?> forFuzzyName(String packageRegex, String className) {
        return this.forFuzzyName(packageRegex, className, true, this.getDefaultClassLoader());
    }

    public ClassMirror<?> forFuzzyName(String packageRegex, String className, boolean initialize, ClassLoader classLoader) {
        ClassMirror find;
        String index = packageRegex + className;
        if (this.fuzzyClassCache.containsKey(index)) {
            return this.fuzzyClassCache.get(index);
        }
        HashSet found = new HashSet();
        Set<ClassMirror<?>> searchSpace = this.getKnownClasses();
        for (ClassMirror<?> c : searchSpace) {
            if (!c.getPackage().getName().matches(packageRegex) || !c.getSimpleName().equals(className)) continue;
            found.add(c);
        }
        if (found.size() == 1) {
            find = (ClassMirror)found.iterator().next();
        } else if (found.isEmpty()) {
            find = null;
        } else {
            ClassMirror candidate = null;
            int max2 = Integer.MAX_VALUE;
            for (ClassMirror classMirror : found) {
                int distance2 = StringUtils.LevenshteinDistance(classMirror.getPackage().getName(), packageRegex);
                if (distance2 >= max2) continue;
                candidate = classMirror;
                max2 = distance2;
            }
            find = candidate;
        }
        this.fuzzyClassCache.put(index, find);
        return find;
    }

    private static void descend(File start, List<File> fileList) {
        if (start.isFile()) {
            if (start.getName().endsWith(".class")) {
                fileList.add(start);
            }
        } else {
            File[] list = start.listFiles();
            if (list == null) {
                StreamUtils.GetSystemOut().println("Could not list files in " + start);
                return;
            }
            for (File child : start.listFiles()) {
                ClassDiscovery.descend(child, fileList);
            }
        }
    }

    public static URL GetClassContainer(Class<?> c) {
        if (c == null) {
            throw new NullPointerException("The Class passed to this method may not be null");
        }
        while (c.isMemberClass() || c.isAnonymousClass()) {
            c = c.getEnclosingClass();
        }
        if (c.getProtectionDomain().getCodeSource() == null) {
            return null;
        }
        String packageRoot = null;
        String thisClass = c.getResource(c.getSimpleName() + ".class").toString();
        try {
            try {
                packageRoot = StringUtils.replaceLast(thisClass, Pattern.quote(c.getName().replaceAll("\\.", "/") + ".class"), "");
            }
            catch (Exception e) {
                packageRoot = c.getProtectionDomain().getCodeSource().getLocation().toString();
            }
            packageRoot = URLDecoder.decode(packageRoot, "UTF-8");
            if (packageRoot.matches("jar:file:.*!/")) {
                packageRoot = StringUtils.replaceLast(packageRoot, "!/", "");
                packageRoot = packageRoot.replaceFirst("jar:", "");
            }
            return new URL(packageRoot);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("While interrogating " + c.getName() + ", an unexpected exception was thrown.", e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("While interrogating " + c.getName() + ", an unexpected exception was thrown for potential URL: \"" + packageRoot + "\"", e);
        }
    }
}

