/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.ClassLoading.ClassMirror;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.AbstractMethodMirror;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.AnnotationMirror;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.ClassReferenceMirror;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.ConstructorMirror;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.FieldMirror;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.MethodMirror;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.ModifierMirror;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.PackageMirror;
import com.laytonsmith.PureUtilities.Common.ClassUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ClassMirror<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ClassInfo<T> info;
    private final Class<?> underlyingClass;
    private URL originalURL;

    protected ClassMirror(ClassInfo<T> info, URL originalURL) {
        this.underlyingClass = null;
        this.originalURL = originalURL;
        this.info = info;
    }

    public ClassMirror(Class<?> c) {
        this.underlyingClass = c;
        this.originalURL = ClassDiscovery.GetClassContainer(c);
        this.info = new ClassInfo();
    }

    public URL getContainer() {
        return this.originalURL;
    }

    public ModifierMirror getModifiers() {
        if (this.underlyingClass != null) {
            return new ModifierMirror(this.underlyingClass.getModifiers());
        }
        return this.info.modifiers;
    }

    public String getJVMClassName() {
        if (this.underlyingClass != null) {
            return ClassUtils.getJVMName(this.underlyingClass);
        }
        return "L" + this.info.name + ";";
    }

    public String getClassName() {
        if (this.underlyingClass != null) {
            return this.underlyingClass.getName().replace('$', '.');
        }
        return this.info.name.replaceAll("[/$]", ".");
    }

    public boolean isEnum() {
        if (this.underlyingClass != null) {
            return this.underlyingClass.isEnum();
        }
        return this.info.isEnum;
    }

    public boolean isInterface() {
        if (this.underlyingClass != null) {
            return this.underlyingClass.isInterface();
        }
        return this.info.isInterface;
    }

    public boolean isAbstract() {
        if (this.underlyingClass != null) {
            return (this.underlyingClass.getModifiers() & 0x400) > 0;
        }
        return this.info.modifiers.isAbstract();
    }

    public ClassReferenceMirror<?> getSuperClass() {
        if (this.underlyingClass != null) {
            return ClassReferenceMirror.fromClass(this.underlyingClass.getSuperclass());
        }
        return new ClassReferenceMirror("L" + this.info.superClass + ";");
    }

    public List<ClassReferenceMirror<?>> getInterfaces() {
        ArrayList l = new ArrayList();
        if (this.underlyingClass != null) {
            for (Class<?> inter : this.underlyingClass.getInterfaces()) {
                l.add(ClassReferenceMirror.fromClass(inter));
            }
        } else {
            for (String inter : this.info.interfaces) {
                l.add(new ClassReferenceMirror("L" + inter + ";"));
            }
        }
        return l;
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotation) {
        if (this.underlyingClass != null) {
            return this.underlyingClass.getAnnotation(annotation) != null;
        }
        String name = ClassUtils.getJVMName(annotation);
        for (AnnotationMirror a : this.info.annotations) {
            if (!a.getType().getJVMName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public Boolean isAnnotationVisible(Class<? extends Annotation> annotation) {
        if (this.underlyingClass != null) {
            return this.hasAnnotation(annotation);
        }
        String name = ClassUtils.getJVMName(annotation);
        for (AnnotationMirror a : this.info.annotations) {
            if (!a.getType().getJVMName().equals(name)) continue;
            return a.isVisible();
        }
        return null;
    }

    public AnnotationMirror getAnnotation(Class<? extends Annotation> clazz) {
        if (this.underlyingClass != null) {
            Annotation ann = this.underlyingClass.getAnnotation(clazz);
            if (ann == null) {
                return null;
            }
            return new AnnotationMirror(ann);
        }
        String name = ClassUtils.getJVMName(clazz);
        for (AnnotationMirror a : this.info.annotations) {
            if (!a.getType().getJVMName().equals(name)) continue;
            return a;
        }
        return null;
    }

    public List<AnnotationMirror> getAnnotations() {
        if (this.underlyingClass != null) {
            ArrayList<AnnotationMirror> list = new ArrayList<AnnotationMirror>();
            for (Annotation a : this.underlyingClass.getAnnotations()) {
                list.add(new AnnotationMirror(ClassReferenceMirror.fromClass(a.annotationType()), true));
            }
            return list;
        }
        return new ArrayList<AnnotationMirror>(this.info.annotations);
    }

    public <T extends Annotation> T loadAnnotation(Class<T> type) {
        if (this.underlyingClass != null) {
            return this.underlyingClass.getAnnotation(type);
        }
        AnnotationMirror mirror = this.getAnnotation(type);
        if (mirror == null) {
            return null;
        }
        return mirror.getProxy(type);
    }

    public FieldMirror[] getFields() {
        if (this.underlyingClass != null) {
            FieldMirror[] fields = new FieldMirror[this.underlyingClass.getDeclaredFields().length];
            for (int i = 0; i < fields.length; ++i) {
                Field f = this.underlyingClass.getDeclaredFields()[i];
                fields[i] = new FieldMirror(f);
            }
            return fields;
        }
        return this.info.fields.toArray(new FieldMirror[this.info.fields.size()]);
    }

    public Map<ClassReferenceMirror<?>, List<ClassReferenceMirror<?>>> getGenerics() throws IllegalArgumentException {
        if (this.underlyingClass != null) {
            throw new IllegalArgumentException("Cannot get generics of a real class");
        }
        HashMap map = new HashMap(this.info.genericParameters.size());
        for (Map.Entry<ClassReferenceMirror<?>, List<ClassReferenceMirror<?>>> k : this.info.genericParameters.entrySet()) {
            map.put(k.getKey(), new ArrayList(k.getValue()));
        }
        return map;
    }

    public FieldMirror getField(String name) throws NoSuchFieldException {
        for (FieldMirror m : this.getFields()) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        throw new NoSuchFieldException("The field \"" + name + "\" was not found.");
    }

    public MethodMirror[] getMethods() {
        ArrayList<MethodMirror> l = new ArrayList<MethodMirror>();
        for (AbstractMethodMirror m : this.getAllMethods()) {
            if (!(m instanceof MethodMirror)) continue;
            l.add((MethodMirror)m);
        }
        return l.toArray(new MethodMirror[l.size()]);
    }

    public ConstructorMirror<T>[] getConstructors() {
        ArrayList<ConstructorMirror> l = new ArrayList<ConstructorMirror>();
        for (AbstractMethodMirror m : this.getAllMethods()) {
            if (!(m instanceof ConstructorMirror)) continue;
            l.add((ConstructorMirror)m);
        }
        return l.toArray(new ConstructorMirror[l.size()]);
    }

    public AbstractMethodMirror[] getAllMethods() {
        if (this.underlyingClass != null) {
            AbstractMethodMirror[] mirrors = new MethodMirror[this.underlyingClass.getDeclaredMethods().length];
            for (int i = 0; i < mirrors.length; ++i) {
                mirrors[i] = new MethodMirror(this.underlyingClass.getDeclaredMethods()[i]);
            }
            return mirrors;
        }
        return this.info.methods.toArray(new AbstractMethodMirror[this.info.methods.size()]);
    }

    public MethodMirror getMethod(String name, Class<?> ... params) throws NoSuchMethodException {
        ClassReferenceMirror[] mm = new ClassReferenceMirror[params.length];
        for (int i = 0; i < params.length; ++i) {
            mm[i] = new ClassReferenceMirror(ClassUtils.getJVMName(params[i]));
        }
        return this.getMethod(name, mm);
    }

    public MethodMirror getMethod(String name, ClassReferenceMirror<?> ... params) throws NoSuchMethodException {
        ArrayList crmParams = new ArrayList();
        crmParams.addAll(Arrays.asList(params));
        for (AbstractMethodMirror m : this.getAllMethods()) {
            if (!(m instanceof MethodMirror) || !m.getName().equals(name) || !m.getParams().equals(crmParams)) continue;
            return (MethodMirror)m;
        }
        throw new NoSuchMethodException("No method matching the signature " + name + "(" + StringUtils.Join(crmParams, ", ") + ") was found.");
    }

    public Class<T> loadClass() throws NoClassDefFoundError {
        if (this.underlyingClass != null) {
            return this.underlyingClass;
        }
        try {
            return this.info.classReferenceMirror.loadClass();
        }
        catch (ClassNotFoundException ex) {
            throw new NoClassDefFoundError(ex.getMessage());
        }
    }

    public Class<T> loadClass(ClassLoader loader, boolean initialize) throws NoClassDefFoundError {
        if (this.underlyingClass != null) {
            return this.underlyingClass;
        }
        try {
            return this.info.classReferenceMirror.loadClass(loader, initialize);
        }
        catch (ClassNotFoundException ex) {
            throw new NoClassDefFoundError(ex.getMessage());
        }
    }

    public boolean directlyExtendsFrom(Class<?> superClass) {
        if (this.underlyingClass != null) {
            if (this.underlyingClass == superClass) {
                return true;
            }
            if (this.underlyingClass.isInterface()) {
                return Arrays.asList(this.underlyingClass.getInterfaces()).contains(superClass);
            }
            return this.underlyingClass.getSuperclass() == superClass;
        }
        String name = superClass.getName().replace('.', '/');
        if (this.info.superClass.equals(name)) {
            return true;
        }
        for (String in : this.info.interfaces) {
            if (!in.equals(name)) continue;
            return true;
        }
        return false;
    }

    public PackageMirror getPackage() {
        if (this.underlyingClass != null) {
            return new PackageMirror(this.underlyingClass.getPackage().getName());
        }
        String[] split2 = this.getClassName().split("\\.");
        if (split2.length == 1) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < split2.length - 1; ++i) {
            if (i != 0) {
                b.append(".");
            }
            b.append(split2[i]);
        }
        return new PackageMirror(b.toString());
    }

    public String getSimpleName() {
        if (this.underlyingClass != null) {
            return this.underlyingClass.getSimpleName();
        }
        String[] split2 = this.getClassName().split("\\.");
        return split2[split2.length - 1];
    }

    public String toString() {
        return (this.isInterface() ? "interface" : (this.isEnum() ? "enum" : "class")) + " " + this.getClassName();
    }

    public ClassReferenceMirror<T> getClassReference() {
        if (this.underlyingClass != null) {
            return ClassReferenceMirror.fromClass(this.underlyingClass);
        }
        return new ClassReferenceMirror(this.getJVMClassName());
    }

    public int hashCode() {
        int hash2 = 5;
        hash2 = 97 * hash2 + Objects.hashCode(this.getJVMClassName());
        return hash2;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassMirror other = (ClassMirror)obj;
        return Objects.equals(this.getJVMClassName(), other.getJVMClassName());
    }

    protected static class ClassInfo<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public ModifierMirror modifiers;
        public String name;
        public String superClass;
        public String[] interfaces;
        public List<AnnotationMirror> annotations = new ArrayList<AnnotationMirror>();
        public boolean isInterface = false;
        public boolean isEnum = false;
        public ClassReferenceMirror<T> classReferenceMirror;
        public List<FieldMirror> fields = new ArrayList<FieldMirror>();
        public List<AbstractMethodMirror> methods = new ArrayList<AbstractMethodMirror>();
        public Map<ClassReferenceMirror<?>, List<ClassReferenceMirror<?>>> genericParameters = new HashMap();

        protected ClassInfo() {
        }
    }
}

