/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.ClassLoading.ClassMirror;

import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.AbstractMethodMirror;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.AnnotationMirror;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.ClassReferenceMirror;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.MethodMirror;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.ModifierMirror;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;

public class ConstructorMirror<T>
extends AbstractMethodMirror {
    public static final String INIT = "<init>";

    public ConstructorMirror(ClassReferenceMirror parentClass, List<AnnotationMirror> annotations, ModifierMirror modifiers, ClassReferenceMirror type, String name, List<ClassReferenceMirror> params, boolean isVararg, boolean isSynthetic) {
        super(parentClass, annotations, modifiers, type, name, params, isVararg, isSynthetic);
    }

    public ConstructorMirror(Constructor cons) {
        super(cons);
    }

    ConstructorMirror(ClassReferenceMirror parentClass, ModifierMirror modifiers, ClassReferenceMirror type, String name, List<ClassReferenceMirror> params, boolean isVararg, boolean isSynthetic) {
        super(parentClass, modifiers, type, name, params, isVararg, isSynthetic);
    }

    public ConstructorMirror(MethodMirror copy) {
        super(copy.getDeclaringClass(), copy.modifiers, copy.type, copy.name, copy.getParams(), copy.isVararg(), copy.isSynthetic());
        if (!INIT.equals(copy.name)) {
            throw new IllegalArgumentException("Only constructors may be mirrored by " + this.getClass().getSimpleName());
        }
    }

    public Constructor<T> loadConstructor() throws ClassNotFoundException {
        return this.loadConstructor(ConstructorMirror.class.getClassLoader(), true);
    }

    public Constructor<T> loadConstructor(ClassLoader loader, boolean initialize) throws ClassNotFoundException {
        if (this.getExecutable() != null) {
            return (Constructor)this.getExecutable();
        }
        Class parent = this.loadParentClass(loader, initialize);
        ArrayList cParams = new ArrayList();
        for (ClassReferenceMirror c : this.getParams()) {
            cParams.add(c.loadClass(loader, initialize));
        }
        try {
            return parent.getConstructor(cParams.toArray(new Class[cParams.size()]));
        }
        catch (NoSuchMethodException | SecurityException ex) {
            throw new RuntimeException(ex);
        }
    }
}

