/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction;

import com.laytonsmith.PureUtilities.DaemonManager;
import com.laytonsmith.abstraction.Convertor;
import com.laytonsmith.abstraction.MCCommand;
import com.laytonsmith.abstraction.MCCommandSender;
import com.laytonsmith.abstraction.MCWorldCreator;
import com.laytonsmith.core.events.BindableEvent;
import com.laytonsmith.core.events.Driver;
import com.laytonsmith.core.events.EventUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractConvertor
implements Convertor {
    private final List<Runnable> shutdownHooks = new ArrayList<Runnable>();
    private final Map<Integer, Task> tasks = new HashMap<Integer, Task>();
    private final AtomicInteger taskIDs = new AtomicInteger(0);

    @Override
    public void addShutdownHook(Runnable r) {
        this.shutdownHooks.add(r);
    }

    @Override
    public void runShutdownHooks() {
        EventUtils.TriggerListener(Driver.SHUTDOWN, "shutdown", new BindableEvent(){

            @Override
            public Object _GetObject() {
                return new Object();
            }
        });
        Iterator<Runnable> iter = this.shutdownHooks.iterator();
        while (iter.hasNext()) {
            iter.next().run();
            iter.remove();
        }
    }

    @Override
    public void runOnMainThreadLater(DaemonManager dm, Runnable r) {
        r.run();
    }

    @Override
    public <T> T runOnMainThreadAndWait(Callable<T> callable) throws Exception {
        return callable.call();
    }

    @Override
    public MCWorldCreator getWorldCreator(String worldName) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public MCCommand getNewCommand(String name) {
        throw new UnsupportedOperationException("Not supported in this implementation.");
    }

    @Override
    public MCCommandSender GetCorrectSender(MCCommandSender unspecific) {
        throw new UnsupportedOperationException("Not supported in this implementation.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ClearAllRunnables() {
        Map<Integer, Task> map = this.tasks;
        synchronized (map) {
            for (Task task : this.tasks.values()) {
                task.unregister();
            }
            this.tasks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ClearFutureRunnable(int id) {
        Map<Integer, Task> map = this.tasks;
        synchronized (map) {
            if (this.tasks.containsKey(id)) {
                this.tasks.get(id).unregister();
                this.tasks.remove(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int SetFutureRepeater(DaemonManager dm, long ms, long initialDelay, final Runnable r) {
        int id = this.taskIDs.getAndIncrement();
        Task t = new Task(id, dm, true, initialDelay, ms, new Runnable(){

            @Override
            public void run() {
                AbstractConvertor.this.triggerRunnable(r);
            }
        });
        Map<Integer, Task> map = this.tasks;
        synchronized (map) {
            this.tasks.put(id, t);
            t.register();
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int SetFutureRunnable(DaemonManager dm, long ms, final Runnable r) {
        int id = this.taskIDs.getAndIncrement();
        Task t = new Task(id, dm, false, ms, 0L, new Runnable(){

            @Override
            public void run() {
                AbstractConvertor.this.triggerRunnable(r);
            }
        });
        Map<Integer, Task> map = this.tasks;
        synchronized (map) {
            this.tasks.put(id, t);
            t.register();
        }
        return id;
    }

    protected synchronized void triggerRunnable(Runnable r) {
        r.run();
    }

    private class Task {
        private final int id;
        private final DaemonManager dm;
        private final boolean repeater;
        private final long initialDelay;
        private final long interval;
        private final Runnable task;
        private Timer timer;

        public Task(int id, DaemonManager dm, boolean repeater, long initialDelay, long interval, Runnable task) {
            this.id = id;
            this.dm = dm;
            this.repeater = repeater;
            this.initialDelay = initialDelay;
            this.interval = repeater ? interval : Long.MAX_VALUE;
            this.task = task;
        }

        public void register() {
            this.timer = new Timer();
            this.timer.schedule(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Task.this.task.run();
                    if (!Task.this.repeater) {
                        Task.this.unregister();
                        Map map = AbstractConvertor.this.tasks;
                        synchronized (map) {
                            AbstractConvertor.this.tasks.remove(Task.this.id);
                        }
                    }
                }
            }, this.initialDelay, this.interval);
            if (this.dm != null) {
                this.dm.activateThread(null);
            }
        }

        public void unregister() {
            this.timer.cancel();
            if (this.dm != null) {
                this.dm.deactivateThread(null);
            }
        }

        public int getId() {
            return this.id;
        }
    }
}

