/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit;

import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.abstraction.MCCommand;
import com.laytonsmith.abstraction.MCCommandMap;
import com.laytonsmith.abstraction.bukkit.BukkitMCCommand;
import com.laytonsmith.commandhelper.CommandHelperPlugin;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.plugin.Plugin;

public class BukkitMCCommandMap
implements MCCommandMap {
    private static boolean synced = true;
    SimpleCommandMap scm;

    public BukkitMCCommandMap(SimpleCommandMap invokeMethod) {
        this.scm = invokeMethod;
    }

    @Override
    public Object getHandle() {
        return this.scm;
    }

    private static void SyncCommands() {
        if (CommandHelperPlugin.self.isFirstLoad()) {
            return;
        }
        if (synced) {
            Bukkit.getScheduler().runTask((Plugin)CommandHelperPlugin.self, () -> {
                Server s = Bukkit.getServer();
                ReflectionUtils.invokeMethod(s.getClass(), s, "syncCommands");
                synced = true;
            });
        }
        synced = false;
    }

    @Override
    public void clearCommands() {
        this.scm.clearCommands();
        BukkitMCCommandMap.SyncCommands();
    }

    @Override
    public boolean isCommand(String name) {
        return this.scm.getCommand(name) != null;
    }

    @Override
    public MCCommand getCommand(String name) {
        Command cmd = this.scm.getCommand(name);
        if (cmd == null) {
            return null;
        }
        return new BukkitMCCommand(cmd);
    }

    @Override
    public List<MCCommand> getCommands() {
        ArrayList<MCCommand> cmds = new ArrayList<MCCommand>();
        for (Command c : this.scm.getCommands()) {
            cmds.add(new BukkitMCCommand(c));
        }
        return cmds;
    }

    @Override
    public boolean register(String fallback, MCCommand cmd) {
        boolean success = this.scm.register(fallback, ((BukkitMCCommand)cmd).cmd);
        BukkitMCCommandMap.SyncCommands();
        return success;
    }

    @Override
    public boolean register(String label, String fallback, MCCommand cmd) {
        boolean success = this.scm.register(label, fallback, ((BukkitMCCommand)cmd).cmd);
        BukkitMCCommandMap.SyncCommands();
        return success;
    }

    @Override
    public boolean unregister(MCCommand cmd) {
        if (cmd.isRegistered()) {
            ((Map)ReflectionUtils.invokeMethod(this.scm.getClass(), this.scm, "getKnownCommands")).remove(cmd.getName());
            BukkitMCCommandMap.SyncCommands();
            return cmd.unregister(this);
        }
        return false;
    }

    public boolean equals(Object obj) {
        return this.scm.equals(obj);
    }

    public int hashCode() {
        return this.scm.hashCode();
    }

    public String toString() {
        return this.scm.toString();
    }
}

