/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core;

import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.annotations.breakable;
import com.laytonsmith.annotations.nolinking;
import com.laytonsmith.annotations.unbreakable;
import com.laytonsmith.core.LogLevel;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.MethodScriptComplete;
import com.laytonsmith.core.Optimizable;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.Procedure;
import com.laytonsmith.core.Script;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.compiler.BranchStatement;
import com.laytonsmith.core.compiler.FileOptions;
import com.laytonsmith.core.compiler.KeywordList;
import com.laytonsmith.core.compiler.TokenStream;
import com.laytonsmith.core.compiler.keywords.ObjectDefinitionKeyword;
import com.laytonsmith.core.constructs.CDecimal;
import com.laytonsmith.core.constructs.CDouble;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.CIdentifier;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CKeyword;
import com.laytonsmith.core.constructs.CLabel;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CPreIdentifier;
import com.laytonsmith.core.constructs.CSlice;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CSymbol;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.IVariable;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.constructs.Token;
import com.laytonsmith.core.constructs.Variable;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.environments.GlobalEnv;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CRERangeException;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigCompileGroupException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.exceptions.ProgramFlowManipulationException;
import com.laytonsmith.core.extensions.ExtensionManager;
import com.laytonsmith.core.extensions.ExtensionTracker;
import com.laytonsmith.core.functions.ArrayHandling;
import com.laytonsmith.core.functions.Compiler;
import com.laytonsmith.core.functions.ControlFlow;
import com.laytonsmith.core.functions.DataHandling;
import com.laytonsmith.core.functions.Function;
import com.laytonsmith.core.functions.FunctionBase;
import com.laytonsmith.core.functions.FunctionList;
import com.laytonsmith.core.functions.IncludeCache;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;

public final class MethodScriptCompiler {
    private static final EnumSet<Optimizable.OptimizationOption> NO_OPTIMIZATIONS = EnumSet.noneOf(Optimizable.OptimizationOption.class);
    private static final Pattern VAR_PATTERN = Pattern.compile("\\$[\\p{L}0-9_]+");
    private static final Pattern IVAR_PATTERN = Pattern.compile("@[\\p{L}0-9_]+");
    private static final String __autoconcat__ = new Compiler.__autoconcat__().getName();
    private static final String array_get = new ArrayHandling.array_get().getName();
    private static final String __cbrace__ = new Compiler.__cbrace__().getName();

    private MethodScriptCompiler() {
    }

    public static TokenStream lex(String script, File file, boolean inPureMScript) throws ConfigCompileException {
        return MethodScriptCompiler.lex(script, file, inPureMScript, false);
    }

    /*
     * Unable to fully structure code
     */
    public static TokenStream lex(String script, File file, boolean inPureMScript, boolean saveAllTokens) throws ConfigCompileException {
        if (script.isEmpty()) {
            return new TokenStream(new LinkedList<Token>(), "");
        }
        if (script.charAt(0) == '\ufeff') {
            script = script.substring(1);
        }
        fileOptions = new StringBuilder();
        script = script.replaceAll("\r\n", "\n");
        script = script + "\n";
        keywords = KeywordList.getKeywordNames();
        tokenList = new TokenStream();
        stateInQuote = false;
        quoteLineNumberStart = 1;
        inSmartQuote = false;
        smartQuoteLineNumberStart = 1;
        inComment = false;
        commentLineNumberStart = 1;
        commentIsBlock = false;
        inOptVar = false;
        inCommand = inPureMScript == false;
        inMultiline = false;
        inSmartComment = false;
        inFileOptions = false;
        inAnnotation = false;
        fileOptionsLineNumberStart = 1;
        buf = new StringBuilder();
        lineNum = 1;
        column = 1;
        lastColumn = 0;
        target = Target.UNKNOWN;
        block62: for (i = 0; i < script.length(); ++i) {
            block163: {
                c = Character.valueOf(script.charAt(i));
                c2 = null;
                if (i < script.length() - 1) {
                    c2 = Character.valueOf(script.charAt(i + 1));
                }
                column += i - lastColumn;
                lastColumn = i;
                if (c.charValue() == '\n') {
                    ++lineNum;
                    column = 1;
                    if (!inMultiline && !inPureMScript) {
                        inCommand = true;
                    }
                }
                if (buf.length() == 0) {
                    target = new Target(lineNum, file, column);
                }
                if (!inFileOptions) break block163;
                switch (c.charValue()) {
                    case '\\': {
                        if (c2.charValue() == '>') {
                            fileOptions.append('>');
                            ++i;
                            break;
                        }
                        ** GOTO lbl60
                    }
                    case '>': {
                        if (saveAllTokens) {
                            tokenList.add(new Token(Token.TType.FILE_OPTIONS_STRING, fileOptions.toString(), target));
                            tokenList.add(new Token(Token.TType.FILE_OPTIONS_END, ">", target));
                        }
                        inFileOptions = false;
                        break;
                    }
lbl60:
                    // 2 sources

                    default: {
                        fileOptions.append(c);
                        break;
                    }
                }
                continue;
            }
            if (stateInQuote || inSmartQuote) ** GOTO lbl-1000
            switch (c.charValue()) {
                case '/': {
                    if (inComment) ** GOTO lbl123
                    if (c2.charValue() == '*') {
                        buf.append("/*");
                        inComment = true;
                        commentIsBlock = true;
                        if (i < script.length() - 2 && script.charAt(i + 2) == '*') {
                            inSmartComment = true;
                            buf.append("*");
                            ++i;
                        }
                        commentLineNumberStart = lineNum;
                        ++i;
                        continue block62;
                    }
                    if (c2.charValue() == '/') {
                        buf.append("//");
                        inComment = true;
                        ++i;
                        continue block62;
                    }
                    ** GOTO lbl123
                }
                case '#': {
                    if (!inComment) {
                        buf.append("#");
                        inComment = true;
                        continue block62;
                    }
                    ** GOTO lbl123
                }
                case '*': {
                    if (inComment && commentIsBlock && c2.charValue() == '/') {
                        if (saveAllTokens || inSmartComment) {
                            buf.append("*/");
                            tokenList.add(new Token(inSmartComment != false ? Token.TType.SMART_COMMENT : Token.TType.COMMENT, buf.toString(), target));
                        }
                        buf = new StringBuilder();
                        target = new Target(lineNum, file, column);
                        inComment = false;
                        commentIsBlock = false;
                        inSmartComment = false;
                        ++i;
                        continue block62;
                    }
                    ** GOTO lbl123
                }
                case '\n': {
                    if (inComment && !commentIsBlock) {
                        inComment = false;
                        if (saveAllTokens) {
                            tokenList.add(new Token(Token.TType.COMMENT, buf.toString(), target));
                            tokenList.add(new Token(Token.TType.NEWLINE, "\n", new Target(lineNum + 1, file, 0)));
                        }
                        buf = new StringBuilder();
                        target = new Target(lineNum, file, column);
                        continue block62;
                    }
                }
lbl123:
                // 7 sources

                default: lbl-1000:
                // 2 sources

                {
                    if (inComment || inAnnotation && c.charValue() != '}') {
                        buf.append(c);
                        continue block62;
                    }
                    if (stateInQuote) ** GOTO lbl372
                    switch (c.charValue()) {
                        case '+': {
                            if (c2.charValue() == '=') {
                                token = new Token(Token.TType.PLUS_ASSIGNMENT, "+=", target);
                                ++i;
                                break;
                            }
                            if (c2.charValue() == '+') {
                                token = new Token(Token.TType.INCREMENT, "++", target);
                                ++i;
                                break;
                            }
                            token = new Token(Token.TType.PLUS, "+", target);
                            break;
                        }
                        case '-': {
                            if (c2.charValue() == '=') {
                                token = new Token(Token.TType.MINUS_ASSIGNMENT, "-=", target);
                                ++i;
                                break;
                            }
                            if (c2.charValue() == '-') {
                                token = new Token(Token.TType.DECREMENT, "--", target);
                                ++i;
                                break;
                            }
                            if (c2.charValue() == '>') {
                                token = new Token(Token.TType.DEREFERENCE, "->", target);
                                ++i;
                                break;
                            }
                            token = new Token(Token.TType.MINUS, "-", target);
                            break;
                        }
                        case '*': {
                            if (c2.charValue() == '=') {
                                token = new Token(Token.TType.MULTIPLICATION_ASSIGNMENT, "*=", target);
                                ++i;
                                break;
                            }
                            if (c2.charValue() == '*') {
                                token = new Token(Token.TType.EXPONENTIAL, "**", target);
                                ++i;
                                break;
                            }
                            token = new Token(Token.TType.MULTIPLICATION, "*", target);
                            break;
                        }
                        case '/': {
                            if (c2.charValue() == '=') {
                                token = new Token(Token.TType.DIVISION_ASSIGNMENT, "/=", target);
                                ++i;
                                break;
                            }
                            if (!Character.isLetter(c2.charValue())) {
                                token = new Token(Token.TType.DIVISION, "/", target);
                                break;
                            }
                            ** GOTO lbl372
                        }
                        case '.': {
                            if (c2.charValue() == '=') {
                                token = new Token(Token.TType.CONCAT_ASSIGNMENT, ".=", target);
                                ++i;
                                break;
                            }
                            if (c2.charValue() == '.') {
                                token = new Token(Token.TType.SLICE, "..", target);
                                ++i;
                                break;
                            }
                            token = new Token(Token.TType.DOT, ".", target);
                            break;
                        }
                        case '%': {
                            token = new Token(Token.TType.MODULO, "%", target);
                            break;
                        }
                        case '>': {
                            if (c2.charValue() == '=') {
                                token = new Token(Token.TType.GTE, ">=", target);
                                ++i;
                                break;
                            }
                            if (c2.charValue() == '>' && i < script.length() - 2 && script.charAt(i + 2) == '>') {
                                token = new Token(Token.TType.MULTILINE_START, ">>>", target);
                                inMultiline = true;
                                i += 2;
                                break;
                            }
                            token = new Token(Token.TType.GT, ">", target);
                            break;
                        }
                        case '<': {
                            if (c2.charValue() == '!') {
                                if (buf.length() > 0) {
                                    tokenList.add(new Token(Token.TType.UNKNOWN, buf.toString(), target));
                                    buf = new StringBuilder();
                                    target = new Target(lineNum, file, column);
                                }
                                if (saveAllTokens) {
                                    tokenList.add(new Token(Token.TType.FILE_OPTIONS_START, "<!", target));
                                }
                                inFileOptions = true;
                                fileOptionsLineNumberStart = lineNum;
                                ++i;
                                continue block62;
                            }
                            if (c2.charValue() == '=') {
                                token = new Token(Token.TType.LTE, "<=", target);
                                ++i;
                                break;
                            }
                            if (c2.charValue() == '<' && i < script.length() - 2 && script.charAt(i + 2) == '<') {
                                token = new Token(Token.TType.MULTILINE_END, "<<<", target);
                                inMultiline = false;
                                i += 2;
                                break;
                            }
                            token = new Token(Token.TType.LT, "<", target);
                            break;
                        }
                        case '=': {
                            if (c2.charValue() == '=') {
                                if (i < script.length() - 2 && script.charAt(i + 2) == '=') {
                                    token = new Token(Token.TType.STRICT_EQUALS, "===", target);
                                    i += 2;
                                    break;
                                }
                                token = new Token(Token.TType.EQUALS, "==", target);
                                ++i;
                                break;
                            }
                            if (inCommand) {
                                if (inOptVar) {
                                    token = new Token(Token.TType.OPT_VAR_ASSIGN, "=", target);
                                    break;
                                }
                                token = new Token(Token.TType.ALIAS_END, "=", target);
                                inCommand = false;
                                break;
                            }
                            token = new Token(Token.TType.ASSIGNMENT, "=", target);
                            break;
                        }
                        case '!': {
                            if (c2.charValue() == '=') {
                                if (i < script.length() - 2 && script.charAt(i + 2) == '=') {
                                    token = new Token(Token.TType.STRICT_NOT_EQUALS, "!==", target);
                                    i += 2;
                                    break;
                                }
                                token = new Token(Token.TType.NOT_EQUALS, "!=", target);
                                ++i;
                                break;
                            }
                            token = new Token(Token.TType.LOGICAL_NOT, "!", target);
                            break;
                        }
                        case '&': {
                            if (c2.charValue() == '&') {
                                if (i < script.length() - 2 && script.charAt(i + 2) == '&') {
                                    token = new Token(Token.TType.DEFAULT_AND, "&&&", target);
                                    i += 2;
                                    break;
                                }
                                token = new Token(Token.TType.LOGICAL_AND, "&&", target);
                                ++i;
                                break;
                            }
                            ** GOTO lbl372
                        }
                        case '|': {
                            if (c2.charValue() == '|') {
                                if (i < script.length() - 2 && script.charAt(i + 2) == '|') {
                                    token = new Token(Token.TType.DEFAULT_OR, "|||", target);
                                    i += 2;
                                    break;
                                }
                                token = new Token(Token.TType.LOGICAL_OR, "||", target);
                                ++i;
                                break;
                            }
                            ** GOTO lbl372
                        }
                        case ':': {
                            if (c2.charValue() == ':') {
                                token = new Token(Token.TType.DEREFERENCE, "::", target);
                                ++i;
                                break;
                            }
                            token = new Token(Token.TType.LABEL, ":", target);
                            break;
                        }
                        case '{': {
                            token = new Token(Token.TType.LCURLY_BRACKET, "{", target);
                            break;
                        }
                        case '}': {
                            if (inAnnotation) {
                                inAnnotation = false;
                                token = new Token(Token.TType.COMMENT, "@{" + buf.toString() + "}", target);
                                buf = new StringBuilder();
                                break;
                            }
                            token = new Token(Token.TType.RCURLY_BRACKET, "}", target);
                            break;
                        }
                        case '[': {
                            token = new Token(Token.TType.LSQUARE_BRACKET, "[", target);
                            inOptVar = true;
                            break;
                        }
                        case ']': {
                            token = new Token(Token.TType.RSQUARE_BRACKET, "]", target);
                            inOptVar = false;
                            break;
                        }
                        case ',': {
                            token = new Token(Token.TType.COMMA, ",", target);
                            break;
                        }
                        case ';': {
                            token = new Token(Token.TType.SEMICOLON, ";", target);
                            break;
                        }
                        case '(': {
                            token = new Token(Token.TType.FUNC_START, "(", target);
                            if (buf.length() > 0) {
                                if (saveAllTokens) {
                                    if (KeywordList.getKeywordByName(buf.toString()) != null) {
                                        tokenList.add(new Token(Token.TType.KEYWORD, buf.toString(), target));
                                    } else {
                                        tokenList.add(new Token(Token.TType.FUNC_NAME, buf.toString(), target));
                                    }
                                } else {
                                    tokenList.add(new Token(Token.TType.FUNC_NAME, buf.toString(), target));
                                }
                                buf = new StringBuilder();
                                target = new Target(lineNum, file, column);
                                break;
                            }
                            try {
                                count = 0;
                                it = tokenList.descendingIterator();
                                while (true) {
                                    t = (Token)it.next();
                                    if (t.type != Token.TType.WHITESPACE) break;
                                    ++count;
                                }
                                if (t.type == Token.TType.UNKNOWN) {
                                    t.type = Token.TType.FUNC_NAME;
                                    --count;
                                    for (a = 0; a < count; ++a) {
                                        tokenList.removeLast();
                                    }
                                    break;
                                }
                                tokenList.add(new Token(Token.TType.FUNC_NAME, "__autoconcat__", target));
                            }
                            catch (NoSuchElementException e) {
                                tokenList.add(new Token(Token.TType.FUNC_NAME, "__autoconcat__", target));
                            }
                            break;
                        }
                        case ')': {
                            token = new Token(Token.TType.FUNC_END, ")", target);
                            break;
                        }
                        case ' ': {
                            token = new Token(Token.TType.WHITESPACE, " ", target);
                            break;
                        }
                        case '\t': {
                            token = new Token(Token.TType.WHITESPACE, "\t", target);
                            break;
                        }
                        case '@': {
                            if (c2.charValue() == '{') {
                                inAnnotation = true;
                                ++i;
                                continue block62;
                            }
                            ** GOTO lbl372
                        }
                        default: {
                            ** GOTO lbl372
                        }
                    }
                    if (buf.length() > 0) {
                        tokenList.add(new Token(Token.TType.UNKNOWN, buf.toString(), target));
                        buf = new StringBuilder();
                        target = new Target(lineNum, file, column);
                    }
                    tokenList.add(token);
                    continue block62;
lbl372:
                    // 6 sources

                    switch (c.charValue()) {
                        case '\'': {
                            if (stateInQuote && !inSmartQuote) {
                                tokenList.add(new Token(Token.TType.STRING, buf.toString(), target));
                                buf = new StringBuilder();
                                target = new Target(lineNum, file, column);
                                stateInQuote = false;
                                continue block62;
                            }
                            if (!stateInQuote) {
                                stateInQuote = true;
                                quoteLineNumberStart = lineNum;
                                inSmartQuote = false;
                                if (buf.length() <= 0) continue block62;
                                tokenList.add(new Token(Token.TType.UNKNOWN, buf.toString(), target));
                                buf = new StringBuilder();
                                target = new Target(lineNum, file, column);
                                continue block62;
                            }
                            buf.append("'");
                            continue block62;
                        }
                        case '\"': {
                            if (stateInQuote && inSmartQuote) {
                                tokenList.add(new Token(Token.TType.SMART_STRING, buf.toString(), target));
                                buf = new StringBuilder();
                                target = new Target(lineNum, file, column);
                                stateInQuote = false;
                                inSmartQuote = false;
                                continue block62;
                            }
                            if (!stateInQuote) {
                                stateInQuote = true;
                                inSmartQuote = true;
                                smartQuoteLineNumberStart = lineNum;
                                if (buf.length() <= 0) continue block62;
                                tokenList.add(new Token(Token.TType.UNKNOWN, buf.toString(), target));
                                buf = new StringBuilder();
                                target = new Target(lineNum, file, column);
                                continue block62;
                            }
                            buf.append('\"');
                            continue block62;
                        }
                        case '\n': {
                            if (stateInQuote) {
                                buf.append(c);
                                continue block62;
                            }
                            if (buf.length() > 0) {
                                tokenList.add(new Token(Token.TType.UNKNOWN, buf.toString(), target));
                                buf = new StringBuilder();
                                target = new Target(lineNum, file, column);
                            }
                            tokenList.add(new Token(Token.TType.NEWLINE, "\n", target));
                            continue block62;
                        }
                        case '\\': {
                            if (!stateInQuote) {
                                tokenList.add(new Token(Token.TType.SEPERATOR, "\\", target));
                                continue block62;
                            }
                            switch (c2.charValue()) {
                                case '\"': 
                                case '\'': 
                                case '\\': {
                                    buf.append(c2);
                                    break;
                                }
                                case 'n': {
                                    buf.append('\n');
                                    break;
                                }
                                case 'r': {
                                    buf.append('\r');
                                    break;
                                }
                                case 't': {
                                    buf.append('\t');
                                    break;
                                }
                                case '0': {
                                    buf.append('\u0000');
                                    break;
                                }
                                case 'f': {
                                    buf.append('\f');
                                    break;
                                }
                                case 'v': {
                                    buf.append('\u000b');
                                    break;
                                }
                                case 'a': {
                                    buf.append('\u0007');
                                    break;
                                }
                                case 'b': {
                                    buf.append('\b');
                                    break;
                                }
                                case 'u': {
                                    if (i + 5 >= script.length()) {
                                        throw new ConfigCompileException("Unrecognized unicode escape sequence", target);
                                    }
                                    unicode = script.substring(i + 2, i + 6);
                                    try {
                                        unicodeNum = Integer.parseInt(unicode, 16);
                                    }
                                    catch (NumberFormatException e) {
                                        throw new ConfigCompileException("Unrecognized unicode escape sequence: \\u" + unicode, target);
                                    }
                                    buf.append(Character.toChars(unicodeNum));
                                    i += 4;
                                    break;
                                }
                                case 'U': {
                                    if (i + 9 >= script.length()) {
                                        throw new ConfigCompileException("Unrecognized unicode escape sequence", target);
                                    }
                                    unicode = script.substring(i + 2, i + 10);
                                    try {
                                        unicodeNum = Integer.parseInt(unicode, 16);
                                    }
                                    catch (NumberFormatException e) {
                                        throw new ConfigCompileException("Unrecognized unicode escape sequence: \\u" + unicode, target);
                                    }
                                    buf.append(Character.toChars(unicodeNum));
                                    i += 8;
                                    break;
                                }
                                case '@': {
                                    if (!inSmartQuote) {
                                        throw new ConfigCompileException("The escape sequence \\@ is not a recognized escape sequence in a non-smart string", target);
                                    }
                                    buf.append("\\@");
                                    break;
                                }
                                default: {
                                    throw new ConfigCompileException("The escape sequence \\" + c2 + " is not a recognized escape sequence", target);
                                }
                            }
                            ++i;
                            continue block62;
                        }
                        default: {
                            if (!stateInQuote && c.charValue() == '\u00a0') {
                                throw new ConfigCompileException("NBSP character in script", target);
                            }
                            buf.append(c);
                            continue block62;
                        }
                    }
                }
            }
        }
        if (inFileOptions) {
            throw new ConfigCompileException("Unended file options. You started the the file options on line " + fileOptionsLineNumberStart, target);
        }
        if (stateInQuote) {
            if (inSmartQuote) {
                throw new ConfigCompileException("Unended string literal. You started the last double quote on line " + smartQuoteLineNumberStart, target);
            }
            throw new ConfigCompileException("Unended string literal. You started the last single quote on line " + quoteLineNumberStart, target);
        }
        if (inComment || commentIsBlock) {
            throw new ConfigCompileException("Unended block comment. You started the comment on line " + commentLineNumberStart, target);
        }
        it = tokenList.listIterator(0);
        while (it.hasNext()) {
            t = (Token)it.next();
            if (t.type == Token.TType.WHITESPACE && it.hasNext()) {
                next = (Token)it.next();
                if (next.type == Token.TType.WHITESPACE) {
                    t.value = t.value + next.val();
                    it.remove();
                } else {
                    it.previous();
                }
                it.previous();
                it.next();
            }
            it.previous();
            if (it.hasPrevious() && t.type == Token.TType.UNKNOWN) {
                prev1 = (Token)it.previous();
                if (prev1.type.isPlusMinus()) {
                    prevNonWhitespace = null;
                    while (it.hasPrevious()) {
                        if (((Token)it.previous()).type == Token.TType.WHITESPACE) continue;
                        prevNonWhitespace = (Token)it.next();
                        break;
                    }
                    while (it.next() != prev1) {
                    }
                    if (!(prevNonWhitespace == null || prevNonWhitespace.type.isIdentifier() || prevNonWhitespace.type == Token.TType.FUNC_END || prevNonWhitespace.type == Token.TType.RSQUARE_BRACKET || MethodScriptCompiler.IVAR_PATTERN.matcher(t.val()).matches() || MethodScriptCompiler.VAR_PATTERN.matcher(t.val()).matches())) {
                        t.value = prev1.value + t.value;
                        it.remove();
                    }
                } else {
                    it.next();
                }
            }
            it.next();
            if (t.type == Token.TType.UNKNOWN) {
                if (t.val().charAt(0) == '/' && t.val().length() > 1) {
                    t.type = Token.TType.COMMAND;
                } else if (t.val().equals("$")) {
                    t.type = Token.TType.FINAL_VAR;
                } else if (MethodScriptCompiler.VAR_PATTERN.matcher(t.val()).matches()) {
                    t.type = Token.TType.VARIABLE;
                } else if (MethodScriptCompiler.IVAR_PATTERN.matcher(t.val()).matches()) {
                    t.type = Token.TType.IVARIABLE;
                } else {
                    if (t.val().charAt(0) == '@') {
                        throw new ConfigCompileException("IVariables must match the regex: " + MethodScriptCompiler.IVAR_PATTERN, target);
                    }
                    t.type = keywords.contains(t.val()) != false ? Token.TType.KEYWORD : (t.val().matches("[\t ]*") != false ? Token.TType.WHITESPACE : Token.TType.LIT);
                }
            }
            if (!inPureMScript || !it.hasNext()) continue;
            next = (Token)it.next();
            it.previous();
            it.previous();
            if (t.type.isSymbol() && !t.type.isUnary() && !next.type.isUnary() && it.hasPrevious()) {
                prev1 = (Token)it.previous();
                if (prev1.type.equals((Object)Token.TType.FUNC_START) || prev1.type.equals((Object)Token.TType.COMMA) || next.type.equals((Object)Token.TType.FUNC_END) || next.type.equals((Object)Token.TType.COMMA) || prev1.type.isSymbol() || next.type.isSymbol()) {
                    throw new ConfigCompileException("Unexpected symbol (" + t.val() + ")", t.getTarget());
                }
                it.next();
            }
            it.next();
        }
        tokenList.setFileOptions(fileOptions.toString());
        foundCode = false;
        for (Token t : tokenList) {
            if (t.type.isFileOption()) {
                if (!foundCode) break;
                throw new ConfigCompileException("File options must be the first non-comment section in the code", t.target);
            }
            if (t.type.isComment() || t.type.isWhitespace()) continue;
            foundCode = true;
        }
        if (!(fileName = tokenList.getFileOptions().getName()).isEmpty() && !file.getAbsolutePath().replace("\\", "/").endsWith(fileName.replace("\\", "/"))) {
            MSLog.GetLogger().w(MSLog.Tags.COMPILER, file + " has the wrong file name in the file options (" + fileName + ")", new Target(0, file, 0));
        }
        exts = ExtensionManager.getTrackers().values();
        notFound = new HashSet<String>();
        for (String extension : tokenList.getFileOptions().getRequiredExtensions()) {
            found = false;
            for (ExtensionTracker t : exts) {
                if (!t.getIdentifier().equalsIgnoreCase(extension)) continue;
                found = true;
                break;
            }
            if (found) continue;
            notFound.add(extension);
        }
        if (!notFound.isEmpty()) {
            throw new ConfigCompileException("Could not compile file, because one or more required extensions are not loaded: " + StringUtils.Join(notFound, ", ") + ". These extensions must be provided before compilation can continue.", new Target(0, file, 0));
        }
        return tokenList;
    }

    public static List<Script> preprocess(TokenStream tokenStream, Set<Class<? extends Environment.EnvironmentImpl>> envs) throws ConfigCompileException {
        if (tokenStream == null || tokenStream.isEmpty()) {
            return new ArrayList<Script>();
        }
        while (!tokenStream.isEmpty() && ((Token)tokenStream.getFirst()).type == Token.TType.NEWLINE) {
            tokenStream.removeFirst();
        }
        if (tokenStream.isEmpty()) {
            return new ArrayList<Script>();
        }
        ListIterator it = tokenStream.listIterator(0);
        Token token = (Token)it.next();
        block12: while (true) {
            switch (token.type) {
                case WHITESPACE: {
                    it.remove();
                    if (!it.hasNext()) break block12;
                    token = (Token)it.next();
                    continue block12;
                }
                case NEWLINE: {
                    while (it.hasNext()) {
                        token = (Token)it.next();
                        if (token.type != Token.TType.NEWLINE) continue block12;
                        it.remove();
                    }
                    break block12;
                }
                default: {
                    if (!it.hasNext()) break block12;
                    token = (Token)it.next();
                    continue block12;
                }
            }
            break;
        }
        boolean insideMultiline = false;
        ListIterator it2 = tokenStream.listIterator(0);
        Token token2 = null;
        block14: while (it2.hasNext()) {
            token2 = (Token)it2.next();
            switch (token2.type) {
                case ALIAS_END: {
                    if (!it2.hasNext()) continue block14;
                    if (((Token)it2.next()).type == Token.TType.MULTILINE_START) {
                        insideMultiline = true;
                        it2.remove();
                        it2.previous();
                        it2.next();
                        continue block14;
                    }
                    it2.previous();
                    continue block14;
                }
                case MULTILINE_END: {
                    if (!insideMultiline) {
                        throw new ConfigCompileException("Found multiline end symbol, and no multiline start found", token2.target);
                    }
                    insideMultiline = false;
                    it2.remove();
                    continue block14;
                }
                case MULTILINE_START: {
                    if (insideMultiline) {
                        throw new ConfigCompileException("Did not expect a multiline start symbol here, are you missing a multiline end symbol above this line?", token2.target);
                    }
                    it2.previous();
                    if (!it2.hasPrevious() || ((Token)it2.previous()).type != Token.TType.ALIAS_END) {
                        throw new ConfigCompileException("Multiline symbol must follow the alias_end (=) symbol", token2.target);
                    }
                    it2.next();
                    it2.next();
                    continue block14;
                }
                case NEWLINE: {
                    if (!insideMultiline) continue block14;
                    it2.remove();
                    continue block14;
                }
                case COMMENT: 
                case SMART_COMMENT: {
                    it2.remove();
                    continue block14;
                }
            }
            if (token2.type == Token.TType.STRING || !token2.val().equals("\\") || !it2.hasNext()) continue;
            if (((Token)it2.next()).type == Token.TType.NEWLINE) {
                it2.remove();
                it2.previous();
                it2.next();
                continue;
            }
            it2.previous();
        }
        assert (token2 != null);
        if (insideMultiline) {
            throw new ConfigCompileException("Expecting a multiline end symbol, but your last multiline alias appears to be missing one.", token2.target);
        }
        ArrayList<Token> left = new ArrayList<Token>();
        ArrayList<Token> right = new ArrayList<Token>();
        ArrayList<Script> scripts = new ArrayList<Script>();
        it2 = tokenStream.listIterator(0);
        block15: while (it2.hasNext()) {
            Token t = (Token)it2.next();
            while (t.type != Token.TType.ALIAS_END) {
                if (!it2.hasNext()) break block15;
                left.add(t);
                t = (Token)it2.next();
            }
            while (t.type != Token.TType.NEWLINE) {
                assert (it2.hasNext());
                right.add(t);
                t = (Token)it2.next();
            }
            if (t.type != Token.TType.NEWLINE) continue;
            for (int j = left.size() - 1; j >= 0; --j) {
                if (((Token)left.get((int)j)).type != Token.TType.NEWLINE || j <= 0 || ((Token)left.get((int)(j - 1))).type == Token.TType.WHITESPACE) continue;
                throw new ConfigCompileException("Unexpected token: " + ((Token)left.get(j - 1)).val(), ((Token)left.get(j - 1)).getTarget());
            }
            Script s = new Script(left, right, null, envs, tokenStream.getFileOptions());
            scripts.add(s);
            left = new ArrayList();
            right = new ArrayList();
        }
        return scripts;
    }

    public static ParseTree compile(TokenStream stream, Environment environment, Set<Class<? extends Environment.EnvironmentImpl>> envs) throws ConfigCompileException, ConfigCompileGroupException {
        Target unknown;
        Objects.requireNonNull(envs, () -> "envs parameter must not be null");
        HashSet<ConfigCompileException> compilerErrors = new HashSet<ConfigCompileException>();
        if (stream == null || stream.isEmpty()) {
            return null;
        }
        try {
            unknown = new Target(0, ((Token)stream.get((int)0)).target.file(), 0);
        }
        catch (Exception e) {
            unknown = Target.UNKNOWN;
        }
        ListIterator it = stream.listIterator(0);
        while (it.hasNext()) {
            if (!((Token)it.next()).type.isWhitespace()) continue;
            it.remove();
        }
        FileOptions fileOptions = stream.getFileOptions();
        ParseTree tree = new ParseTree(fileOptions);
        tree.setData(CNull.NULL);
        Stack<ParseTree> parents = new Stack<ParseTree>();
        Stack<AtomicInteger> constructCount = new Stack<AtomicInteger>();
        constructCount.push(new AtomicInteger(0));
        parents.push(tree);
        tree.addChild(new ParseTree(new CFunction(__autoconcat__, unknown), fileOptions));
        parents.push(tree.getChildAt(0));
        tree = tree.getChildAt(0);
        constructCount.push(new AtomicInteger(0));
        Stack<AtomicInteger> arrayStack = new Stack<AtomicInteger>();
        arrayStack.add(new AtomicInteger(-1));
        Stack<AtomicInteger> minusArrayStack = new Stack<AtomicInteger>();
        Stack<AtomicInteger> minusFuncStack = new Stack<AtomicInteger>();
        int parens = 0;
        Token t = null;
        int braceCount = 0;
        boolean inObjectDefinition = false;
        Token[] tokenArray = stream.toArray(new Token[stream.size()]);
        for (int i = 0; i < tokenArray.length; ++i) {
            ArrayList<ParseTree> subChildren;
            Token next3;
            t = tokenArray[i];
            Token prev1 = i - 1 >= 0 ? tokenArray[i - 1] : new Token(Token.TType.UNKNOWN, "", t.target);
            Token next1 = i + 1 < stream.size() ? tokenArray[i + 1] : new Token(Token.TType.UNKNOWN, "", t.target);
            Token next2 = i + 2 < stream.size() ? tokenArray[i + 2] : new Token(Token.TType.UNKNOWN, "", t.target);
            Token token = next3 = i + 3 < stream.size() ? tokenArray[i + 3] : new Token(Token.TType.UNKNOWN, "", t.target);
            if (t.type == Token.TType.LCURLY_BRACKET) {
                inObjectDefinition = false;
                ParseTree b = new ParseTree(new CFunction(__cbrace__, t.getTarget()), fileOptions);
                tree.addChild(b);
                tree = b;
                parents.push(b);
                ++braceCount;
                constructCount.push(new AtomicInteger(0));
                continue;
            }
            if (t.type == Token.TType.RCURLY_BRACKET) {
                --braceCount;
                if (((AtomicInteger)constructCount.peek()).get() > 1) {
                    int stacks = ((AtomicInteger)constructCount.peek()).get();
                    int replaceAt = tree.getChildren().size() - stacks;
                    ParseTree c = new ParseTree(new CFunction(__autoconcat__, tree.getTarget()), fileOptions);
                    subChildren = new ArrayList<ParseTree>();
                    for (int b = replaceAt; b < tree.numberOfChildren(); ++b) {
                        subChildren.add(tree.getChildAt(b));
                    }
                    c.setChildren(subChildren);
                    if (replaceAt > 0) {
                        ArrayList<ParseTree> firstChildren = new ArrayList<ParseTree>();
                        for (int d = 0; d < replaceAt; ++d) {
                            firstChildren.add(tree.getChildAt(d));
                        }
                        tree.setChildren(firstChildren);
                    } else {
                        tree.removeChildren();
                    }
                    tree.addChild(c);
                }
                parents.pop();
                tree = (ParseTree)parents.peek();
                constructCount.pop();
                try {
                    ((AtomicInteger)constructCount.peek()).incrementAndGet();
                    continue;
                }
                catch (EmptyStackException e) {
                    throw new ConfigCompileException("Unexpected end curly brace", t.target);
                }
            }
            if (t.type == Token.TType.KEYWORD && KeywordList.getKeywordByName(t.value) instanceof ObjectDefinitionKeyword) {
                inObjectDefinition = true;
            }
            if (t.type == Token.TType.LABEL && tree.getChildren().size() > 0) {
                if (!prev1.type.isAtomicLit() && prev1.type != Token.TType.IVARIABLE && prev1.type != Token.TType.KEYWORD) {
                    ConfigCompileException error = new ConfigCompileException("Invalid label specified", t.getTarget());
                    if (prev1.type == Token.TType.FUNC_END) {
                        throw error;
                    }
                    compilerErrors.add(error);
                }
                ParseTree cc = tree.getChildren().get(tree.getChildren().size() - 1);
                tree.removeChildAt(tree.getChildren().size() - 1);
                tree.addChild(new ParseTree(new CLabel((Construct)cc.getData()), fileOptions));
                continue;
            }
            if (t.type.equals((Object)Token.TType.LSQUARE_BRACKET)) {
                arrayStack.push(new AtomicInteger(tree.getChildren().size() - 1));
                continue;
            }
            if (t.type.equals((Object)Token.TType.RSQUARE_BRACKET)) {
                ParseTree myIndex;
                boolean emptyArray = false;
                if (prev1.type.equals((Object)Token.TType.LSQUARE_BRACKET)) {
                    emptyArray = true;
                }
                if (arrayStack.size() == 1) {
                    throw new ConfigCompileException("Mismatched square bracket", t.target);
                }
                int array2 = ((AtomicInteger)arrayStack.pop()).get();
                int index = array2 + 1;
                if (!tree.hasChildren() || array2 == -1) {
                    throw new ConfigCompileException("Brackets are illegal here", t.target);
                }
                ParseTree myArray = tree.getChildAt(array2);
                if (!emptyArray) {
                    myIndex = new ParseTree(new CFunction(__autoconcat__, myArray.getTarget()), fileOptions);
                    for (int j = index; j < tree.numberOfChildren(); ++j) {
                        myIndex.addChild(tree.getChildAt(j));
                    }
                } else {
                    myIndex = new ParseTree(new CSlice("0..-1", t.target), fileOptions);
                }
                tree.setChildren(tree.getChildren().subList(0, array2));
                ParseTree arrayGet = new ParseTree(new CFunction(array_get, t.target), fileOptions);
                arrayGet.addChild(myArray);
                arrayGet.addChild(myIndex);
                if (!minusArrayStack.isEmpty() && arrayStack.size() + 1 == ((AtomicInteger)minusArrayStack.peek()).get()) {
                    if (!next1.type.equals((Object)Token.TType.LSQUARE_BRACKET)) {
                        ParseTree negTree = new ParseTree(new CFunction("neg", unknown), fileOptions);
                        negTree.addChild(arrayGet);
                        tree.addChild(negTree);
                        minusArrayStack.pop();
                    } else {
                        tree.addChild(arrayGet);
                    }
                } else {
                    tree.addChild(arrayGet);
                }
                ((AtomicInteger)constructCount.peek()).set(((AtomicInteger)constructCount.peek()).get() - myIndex.numberOfChildren());
                continue;
            }
            if (t.type == Token.TType.SMART_STRING) {
                if (t.val().contains("@")) {
                    ParseTree function = new ParseTree(fileOptions);
                    function.setData(new CFunction(new Compiler.smart_string().getName(), t.target));
                    ParseTree string = new ParseTree(fileOptions);
                    string.setData(new CString(t.value, t.target));
                    function.addChild(string);
                    tree.addChild(function);
                } else {
                    tree.addChild(new ParseTree(new CString(t.val(), t.target), fileOptions));
                }
                ((AtomicInteger)constructCount.peek()).incrementAndGet();
                continue;
            }
            if (t.type == Token.TType.DEREFERENCE) {
                compilerErrors.add(new ConfigCompileException("The '" + t.val() + "' symbol is not currently allowed in raw strings. You must quote all symbols.", t.target));
            }
            if (t.type.equals((Object)Token.TType.FUNC_NAME)) {
                CFunction func = new CFunction(t.val(), t.target);
                ParseTree f = new ParseTree(func, fileOptions);
                tree.addChild(f);
                constructCount.push(new AtomicInteger(0));
                tree = f;
                parents.push(f);
            } else if (t.type.equals((Object)Token.TType.FUNC_START)) {
                if (!prev1.type.equals((Object)Token.TType.FUNC_NAME)) {
                    throw new ConfigCompileException("Unexpected parenthesis", t.target);
                }
                ++parens;
            } else if (t.type.equals((Object)Token.TType.FUNC_END)) {
                if (parens <= 0) {
                    throw new ConfigCompileException("Unexpected parenthesis", t.target);
                }
                --parens;
                parents.pop();
                if (((AtomicInteger)constructCount.peek()).get() > 1) {
                    int stacks = ((AtomicInteger)constructCount.peek()).get();
                    int replaceAt = tree.getChildren().size() - stacks;
                    ParseTree c = new ParseTree(new CFunction("__autoconcat__", tree.getTarget()), fileOptions);
                    subChildren = new ArrayList();
                    for (int b = replaceAt; b < tree.numberOfChildren(); ++b) {
                        subChildren.add(tree.getChildAt(b));
                    }
                    c.setChildren(subChildren);
                    if (replaceAt > 0) {
                        ArrayList<ParseTree> firstChildren = new ArrayList<ParseTree>();
                        for (int d = 0; d < replaceAt; ++d) {
                            firstChildren.add(tree.getChildAt(d));
                        }
                        tree.setChildren(firstChildren);
                    } else {
                        tree.removeChildren();
                    }
                    tree.addChild(c);
                }
                constructCount.pop();
                try {
                    ((AtomicInteger)constructCount.peek()).incrementAndGet();
                }
                catch (EmptyStackException e) {
                    throw new ConfigCompileException("Unexpected end parenthesis", t.target);
                }
                try {
                    tree = (ParseTree)parents.peek();
                }
                catch (EmptyStackException e) {
                    throw new ConfigCompileException("Unexpected end parenthesis", t.target);
                }
                if (!minusFuncStack.isEmpty() && ((AtomicInteger)minusFuncStack.peek()).get() == parens + 1) {
                    if (next1.type.equals((Object)Token.TType.LSQUARE_BRACKET)) {
                        minusArrayStack.push(new AtomicInteger(arrayStack.size() + 1));
                    } else {
                        ParseTree negTree = new ParseTree(new CFunction("neg", unknown), fileOptions);
                        negTree.addChild(tree.getChildAt(tree.numberOfChildren() - 1));
                        tree.removeChildAt(tree.numberOfChildren() - 1);
                        tree.addChildAt(tree.numberOfChildren(), negTree);
                    }
                    minusFuncStack.pop();
                }
            } else if (t.type.equals((Object)Token.TType.COMMA)) {
                if (inObjectDefinition) {
                    tree.addChild(new ParseTree(new CSymbol(",", Token.TType.COMMA, unknown), fileOptions));
                    continue;
                }
                if (((AtomicInteger)constructCount.peek()).get() > 1) {
                    int stacks = ((AtomicInteger)constructCount.peek()).get();
                    int replaceAt = tree.getChildren().size() - stacks;
                    ParseTree c = new ParseTree(new CFunction("__autoconcat__", unknown), fileOptions);
                    subChildren = new ArrayList();
                    for (int b = replaceAt; b < tree.numberOfChildren(); ++b) {
                        subChildren.add(tree.getChildAt(b));
                    }
                    c.setChildren(subChildren);
                    if (replaceAt > 0) {
                        ArrayList<ParseTree> firstChildren = new ArrayList<ParseTree>();
                        for (int d = 0; d < replaceAt; ++d) {
                            firstChildren.add(tree.getChildAt(d));
                        }
                        tree.setChildren(firstChildren);
                    } else {
                        tree.removeChildren();
                    }
                    tree.addChild(c);
                }
                ((AtomicInteger)constructCount.peek()).set(0);
                continue;
            }
            if (t.type == Token.TType.SLICE) {
                try {
                    String value = next1.val();
                    if (next1.type == Token.TType.MINUS || next1.type == Token.TType.PLUS) {
                        value = next1.val() + next2.val();
                        ++i;
                    }
                    CSlice slice = new CSlice(".." + value, t.getTarget());
                    ++i;
                    tree.addChild(new ParseTree(slice, fileOptions));
                    ((AtomicInteger)constructCount.peek()).incrementAndGet();
                    continue;
                }
                catch (ConfigRuntimeException ex) {
                    throw new ConfigCompileException(ex);
                }
            }
            if (next1.type.equals((Object)Token.TType.SLICE)) {
                try {
                    CSlice slice;
                    if (t.type.isSeparator() || t.type.isWhitespace() && prev1.type.isSeparator() || t.type.isKeyword()) {
                        String value = next2.val();
                        ++i;
                        if (next2.type == Token.TType.MINUS || next2.type == Token.TType.PLUS) {
                            value = next2.val() + next3.val();
                            ++i;
                        }
                        slice = new CSlice(".." + value, next1.getTarget());
                        if (t.type.isKeyword()) {
                            tree.addChild(new ParseTree(new CKeyword(t.val(), t.getTarget()), fileOptions));
                            ((AtomicInteger)constructCount.peek()).incrementAndGet();
                        }
                    } else if (next2.type.isSeparator() || next2.type.isKeyword()) {
                        String modifier = "";
                        if (prev1.type == Token.TType.MINUS || prev1.type == Token.TType.PLUS) {
                            modifier = prev1.val();
                            tree.removeChildAt(tree.getChildren().size() - 1);
                        }
                        slice = new CSlice(modifier + t.value + "..", t.target);
                    } else {
                        String modifier1 = "";
                        if (prev1.type == Token.TType.MINUS || prev1.type == Token.TType.PLUS) {
                            modifier1 = prev1.val();
                            tree.removeChildAt(tree.getChildren().size() - 1);
                        }
                        Token first = t;
                        if (first.type.isWhitespace()) {
                            first = prev1;
                        }
                        Token second = next2;
                        ++i;
                        String modifier2 = "";
                        if (next2.type == Token.TType.MINUS || next2.type == Token.TType.PLUS) {
                            modifier2 = next2.val();
                            second = next3;
                            ++i;
                        }
                        slice = new CSlice(modifier1 + first.value + ".." + modifier2 + second.value, t.target);
                    }
                    ++i;
                    tree.addChild(new ParseTree(slice, fileOptions));
                    ((AtomicInteger)constructCount.peek()).incrementAndGet();
                    continue;
                }
                catch (ConfigRuntimeException ex) {
                    throw new ConfigCompileException(ex);
                }
            }
            if (t.type == Token.TType.LIT) {
                Construct c = Static.resolveConstruct(t.val(), t.target, true);
                if ((c instanceof CInt || c instanceof CDecimal) && next1.type == Token.TType.DOT && next2.type == Token.TType.LIT) {
                    try {
                        if (t.value.startsWith("0m")) {
                            String neg2 = "";
                            if (prev1.value.equals("-")) {
                                neg2 = "-";
                            }
                            c = new CDecimal(neg2 + t.value.substring(2) + '.' + next2.value, t.target);
                        } else {
                            c = new CDouble(Double.parseDouble(t.val() + '.' + next2.val()), t.target);
                        }
                        i += 2;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                tree.addChild(new ParseTree(c, fileOptions));
                ((AtomicInteger)constructCount.peek()).incrementAndGet();
                continue;
            }
            if (t.type.equals((Object)Token.TType.STRING) || t.type.equals((Object)Token.TType.COMMAND)) {
                tree.addChild(new ParseTree(new CString(t.val(), t.target), fileOptions));
                ((AtomicInteger)constructCount.peek()).incrementAndGet();
                continue;
            }
            if (t.type.equals((Object)Token.TType.IDENTIFIER)) {
                tree.addChild(new ParseTree(new CPreIdentifier(t.val(), t.target), fileOptions));
                ((AtomicInteger)constructCount.peek()).incrementAndGet();
                continue;
            }
            if (t.type.isKeyword()) {
                tree.addChild(new ParseTree(new CKeyword(t.val(), t.getTarget()), fileOptions));
                ((AtomicInteger)constructCount.peek()).incrementAndGet();
                continue;
            }
            if (t.type.equals((Object)Token.TType.IVARIABLE)) {
                tree.addChild(new ParseTree(new IVariable(t.val(), t.target), fileOptions));
                ((AtomicInteger)constructCount.peek()).incrementAndGet();
                continue;
            }
            if (t.type.equals((Object)Token.TType.UNKNOWN)) {
                tree.addChild(new ParseTree(Static.resolveConstruct(t.val(), t.target), fileOptions));
                ((AtomicInteger)constructCount.peek()).incrementAndGet();
                continue;
            }
            if (t.type.isSymbol()) {
                if (!(!t.type.equals((Object)Token.TType.MINUS) || prev1.type.isAtomicLit() || prev1.type.equals((Object)Token.TType.IVARIABLE) || prev1.type.equals((Object)Token.TType.VARIABLE) || prev1.type.equals((Object)Token.TType.RCURLY_BRACKET) || prev1.type.equals((Object)Token.TType.RSQUARE_BRACKET) || prev1.type.equals((Object)Token.TType.FUNC_END) || !next1.type.equals((Object)Token.TType.IVARIABLE) && !next1.type.equals((Object)Token.TType.VARIABLE) && !next1.type.equals((Object)Token.TType.FUNC_NAME))) {
                    if (next2.type.equals((Object)Token.TType.LSQUARE_BRACKET)) {
                        minusArrayStack.push(new AtomicInteger(arrayStack.size() + 1));
                        continue;
                    }
                    if (next1.type.equals((Object)Token.TType.FUNC_NAME)) {
                        minusFuncStack.push(new AtomicInteger(parens + 1));
                        continue;
                    }
                    ParseTree negTree = new ParseTree(new CFunction("neg", unknown), fileOptions);
                    negTree.addChild(new ParseTree(new IVariable(next1.value, next1.target), fileOptions));
                    tree.addChild(negTree);
                    ((AtomicInteger)constructCount.peek()).incrementAndGet();
                    ++i;
                    continue;
                }
                tree.addChild(new ParseTree(new CSymbol(t.val(), t.type, t.target), fileOptions));
                ((AtomicInteger)constructCount.peek()).incrementAndGet();
                continue;
            }
            if (t.type == Token.TType.DOT) {
                Construct c = null;
                if (next1.type == Token.TType.LIT && prev1.type != Token.TType.STRING && prev1.type != Token.TType.SMART_STRING) {
                    try {
                        c = new CDouble(Double.parseDouble('.' + next1.val()), t.target);
                        ++i;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (c == null) {
                    c = new CSymbol(".", Token.TType.CONCAT, t.target);
                }
                tree.addChild(new ParseTree(c, fileOptions));
                ((AtomicInteger)constructCount.peek()).incrementAndGet();
                continue;
            }
            if (!t.type.equals((Object)Token.TType.VARIABLE) && !t.type.equals((Object)Token.TType.FINAL_VAR)) continue;
            tree.addChild(new ParseTree(new Variable(t.val(), null, false, t.type.equals((Object)Token.TType.FINAL_VAR), t.target), fileOptions));
            ((AtomicInteger)constructCount.peek()).incrementAndGet();
        }
        assert (t != null);
        assert (arrayStack.size() != 0) : "The last element of arrayStack should be present, but it was popped.";
        if (arrayStack.size() != 1) {
            Target target = MethodScriptCompiler.traceMismatchedOpenToken(stream, Token.TType.LSQUARE_BRACKET, Token.TType.RSQUARE_BRACKET);
            assert (target != null) : "Mismatched bracket was detected, but target-finding code could not find it.";
            if (target == null) {
                target = t.target;
            }
            throw new ConfigCompileException("Mismatched square brackets", target);
        }
        if (parens != 0) {
            Target target = MethodScriptCompiler.traceMismatchedOpenToken(stream, Token.TType.FUNC_START, Token.TType.FUNC_END);
            assert (target != null) : "Mismatched parentheses was detected, but target-finding code could not find it.";
            if (target == null) {
                target = t.target;
            }
            throw new ConfigCompileException("Mismatched parentheses", target);
        }
        if (braceCount != 0) {
            Target target = MethodScriptCompiler.traceMismatchedOpenToken(stream, Token.TType.LCURLY_BRACKET, Token.TType.RCURLY_BRACKET);
            assert (target != null) : "Mismatched curly brace was detected, but target-finding code could not find it.";
            if (target == null) {
                target = t.target;
            }
            throw new ConfigCompileException("Mismatched curly braces", target);
        }
        Stack<List<Procedure>> procs = new Stack<List<Procedure>>();
        procs.add(new ArrayList());
        MethodScriptCompiler.processKeywords(tree);
        MethodScriptCompiler.optimizeAutoconcats(tree, environment, envs, compilerErrors);
        MethodScriptCompiler.optimize(tree, environment, envs, procs, compilerErrors);
        MethodScriptCompiler.link(tree, compilerErrors, envs);
        MethodScriptCompiler.checkLabels(tree, compilerErrors);
        MethodScriptCompiler.checkBreaks(tree, compilerErrors);
        MethodScriptCompiler.eliminateDeadCode(tree, envs);
        if (!compilerErrors.isEmpty()) {
            if (compilerErrors.size() == 1) {
                Iterator iterator = compilerErrors.iterator();
                if (iterator.hasNext()) {
                    ConfigCompileException e = (ConfigCompileException)iterator.next();
                    throw e;
                }
            } else {
                throw new ConfigCompileGroupException(compilerErrors);
            }
        }
        parents.pop();
        tree = (ParseTree)parents.pop();
        return tree;
    }

    private static Target traceMismatchedOpenToken(TokenStream stream, Token.TType openType, Token.TType closeType) {
        Iterator iterator = stream.descendingIterator();
        int closingCount = 0;
        while (iterator.hasNext()) {
            Token token = (Token)iterator.next();
            if (token.type == closeType) {
                ++closingCount;
                continue;
            }
            if (token.type != openType) continue;
            if (closingCount <= 0) {
                return token.target;
            }
            --closingCount;
        }
        return null;
    }

    private static void checkBreaks(ParseTree tree, Set<ConfigCompileException> compilerExceptions) {
        MethodScriptCompiler.checkBreaks0(tree, 0L, null, compilerExceptions);
    }

    private static void checkBreaks0(ParseTree tree, long currentLoops, String lastUnbreakable, Set<ConfigCompileException> compilerErrors) {
        Function func;
        if (!(tree.getData() instanceof CFunction)) {
            return;
        }
        if (tree.getData().val().startsWith("_")) {
            for (ParseTree child : tree.getChildren()) {
                MethodScriptCompiler.checkBreaks0(child, currentLoops, lastUnbreakable, compilerErrors);
            }
            return;
        }
        try {
            func = ((CFunction)tree.getData()).getFunction();
        }
        catch (ConfigCompileException ex) {
            compilerErrors.add(ex);
            return;
        }
        if (func.getClass().getAnnotation(nolinking.class) != null) {
            return;
        }
        if (func instanceof ControlFlow._break) {
            long breakCounter = 1L;
            if (tree.getChildren().size() == 1) {
                try {
                    breakCounter = Static.getInt32(tree.getChildAt(0).getData(), tree.getChildAt(0).getTarget());
                }
                catch (CRECastException | CRERangeException e) {
                    compilerErrors.add(new ConfigCompileException(e));
                    return;
                }
            }
            if (breakCounter > currentLoops) {
                if (currentLoops == 0L) {
                    compilerErrors.add(new ConfigCompileException("The break() function can only break out of loops" + (lastUnbreakable == null ? "." : ", but an attempt to break out of a " + lastUnbreakable + " was detected."), tree.getTarget()));
                } else {
                    compilerErrors.add(new ConfigCompileException("Too many breaks detected. Check your loop nesting, and set the break count to an appropriate value.", tree.getTarget()));
                }
            }
            return;
        }
        if (func.getClass().getAnnotation(unbreakable.class) != null) {
            for (ParseTree child : tree.getChildren()) {
                MethodScriptCompiler.checkBreaks0(child, 0L, func.getName(), compilerErrors);
            }
            return;
        }
        if (func.getClass().getAnnotation(breakable.class) != null) {
            ++currentLoops;
        }
        for (ParseTree child : tree.getChildren()) {
            MethodScriptCompiler.checkBreaks0(child, currentLoops, lastUnbreakable, compilerErrors);
        }
    }

    private static void optimizeAutoconcats(ParseTree root, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, Set<ConfigCompileException> compilerExceptions) {
        for (ParseTree child : root.getChildren()) {
            if (!child.hasChildren()) continue;
            MethodScriptCompiler.optimizeAutoconcats(child, env, envs, compilerExceptions);
        }
        if (root.getData() instanceof CFunction && root.getData().val().equals(__autoconcat__)) {
            try {
                ParseTree ret = ((Compiler.__autoconcat__)((CFunction)root.getData()).getFunction()).optimizeDynamic(root.getTarget(), env, envs, root.getChildren(), root.getFileOptions());
                root.setData(ret.getData());
                root.setChildren(ret.getChildren());
            }
            catch (ConfigCompileException ex) {
                compilerExceptions.add(ex);
            }
        }
    }

    private static void checkLabels(ParseTree tree, Set<ConfigCompileException> compilerErrors) throws ConfigCompileException {
    }

    private static void link(ParseTree tree, Set<ConfigCompileException> compilerErrors, Set<Class<? extends Environment.EnvironmentImpl>> envs) {
        FunctionBase treeFunction = null;
        try {
            treeFunction = FunctionList.getFunction((CFunction)tree.getData(), null);
            if (treeFunction.getClass().getAnnotation(nolinking.class) != null) {
                return;
            }
        }
        catch (ConfigCompileException | ClassCastException exception) {
            // empty catch block
        }
        if (treeFunction != null) {
            Optimizable op;
            Integer[] numArgs = treeFunction.numArgs();
            if (!Arrays.asList(numArgs).contains(Integer.MAX_VALUE) && !Arrays.asList(numArgs).contains(tree.getChildren().size())) {
                compilerErrors.add(new ConfigCompileException("Incorrect number of arguments passed to " + tree.getData().val(), tree.getData().getTarget()));
            }
            if (treeFunction instanceof Optimizable && (op = (Optimizable)treeFunction).optimizationOptions().contains(Optimizable.OptimizationOption.CUSTOM_LINK)) {
                try {
                    op.link(tree.getData().getTarget(), tree.getChildren());
                }
                catch (ConfigCompileException ex) {
                    compilerErrors.add(ex);
                }
            }
        }
        for (ParseTree child : tree.getChildren()) {
            if (!(child.getData() instanceof CFunction)) continue;
            if (child.getData().val().charAt(0) != '_' || child.getData().val().charAt(1) == '_') {
                try {
                    FunctionList.getFunction((CFunction)child.getData(), envs);
                }
                catch (ConfigCompileException ex) {
                    compilerErrors.add(ex);
                }
                catch (ClassCastException ex) {
                    throw new RuntimeException(ex);
                }
            }
            MethodScriptCompiler.link(child, compilerErrors, envs);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void optimize(ParseTree tree, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, Stack<List<Procedure>> procs, Set<ConfigCompileException> compilerErrors) {
        void var11_26;
        void var11_24;
        Function func;
        if (tree.isOptimized()) {
            return;
        }
        if (!(tree.getData() instanceof CFunction)) {
            return;
        }
        if (tree.getData().val().equals("proc")) {
            procs.push(new ArrayList());
        }
        CFunction cFunction = (CFunction)tree.getData();
        try {
            func = (Function)FunctionList.getFunction(cFunction, envs);
        }
        catch (ConfigCompileException e) {
            func = null;
        }
        if (func != null && func.getClass().getAnnotation(nolinking.class) != null) {
            return;
        }
        if (cFunction instanceof CIdentifier) {
            ParseTree c = ((CIdentifier)cFunction).contained();
            tree.addChild(c);
            if (c.getData() instanceof Construct) {
                ((Construct)c.getData()).setWasIdentifier(true);
            }
        }
        List<ParseTree> children = tree.getChildren();
        if (func instanceof Optimizable && ((Optimizable)func).optimizationOptions().contains(Optimizable.OptimizationOption.PRIORITY_OPTIMIZATION)) {
            try {
                ((Optimizable)func).optimizeDynamic(tree.getTarget(), env, envs, children, tree.getFileOptions());
            }
            catch (ConfigCompileException ex) {
                compilerErrors.add(ex);
                return;
            }
            catch (ConfigRuntimeException ex) {
                compilerErrors.add(new ConfigCompileException(ex));
                return;
            }
        }
        boolean fullyStatic = true;
        boolean hasIVars = false;
        for (ParseTree parseTree : children) {
            Construct construct;
            if (parseTree.getData() instanceof CFunction) {
                MethodScriptCompiler.optimize(parseTree, env, envs, procs, compilerErrors);
            }
            if (parseTree.getData() instanceof Construct && ((construct = (Construct)parseTree.getData()).isDynamic() || construct instanceof IVariable)) {
                fullyStatic = false;
            }
            if (!(parseTree.getData() instanceof IVariable)) continue;
            hasIVars = true;
        }
        tree.setOptimized(true);
        if (func == null) {
            Procedure p2 = null;
            block19: for (List list : procs) {
                for (Procedure pp : list) {
                    if (!pp.getName().equals(cFunction.val())) continue;
                    p2 = pp;
                    break block19;
                }
            }
            if (p2 != null) {
                try {
                    Mixed mixed = DataHandling.proc.optimizeProcedure(p2.getTarget(), p2, children);
                    if (mixed != null) {
                        tree.setData(mixed);
                        tree.removeChildren();
                        return;
                    }
                }
                catch (ConfigRuntimeException configRuntimeException) {
                    compilerErrors.add(new ConfigCompileException(configRuntimeException));
                }
            }
            return;
        }
        if (tree.getData().val().equals("proc")) {
            if (children.size() < 2) {
                compilerErrors.add(new ConfigCompileException("Incorrect number of arguments passed to proc", tree.getData().getTarget()));
                return;
            }
            procs.pop();
            try {
                ParseTree root = new ParseTree(new CFunction(__autoconcat__, Target.UNKNOWN), tree.getFileOptions());
                Script script = Script.GenerateScript(root, "*");
                env.getEnv(GlobalEnv.class).SetFlag("no-check-undefined", true);
                Procedure procedure = DataHandling.proc.getProcedure(tree.getTarget(), env, script, children.toArray(new ParseTree[children.size()]));
                env.getEnv(GlobalEnv.class).ClearFlag("no-check-undefined");
                procs.peek().add(procedure);
            }
            catch (ConfigRuntimeException e) {
                compilerErrors.add(new ConfigCompileException(e));
            }
            catch (NullPointerException e) {
                return;
            }
        }
        String oldFunctionName = func.getName();
        EnumSet<Optimizable.OptimizationOption> enumSet = NO_OPTIMIZATIONS;
        if (func instanceof Optimizable) {
            Set<Optimizable.OptimizationOption> set = ((Optimizable)func).optimizationOptions();
        }
        if (var11_24.contains(Optimizable.OptimizationOption.OPTIMIZE_DYNAMIC)) {
            try {
                void var12_35;
                ParseTree parseTree;
                try {
                    parseTree = ((Optimizable)func).optimizeDynamic(tree.getData().getTarget(), env, envs, tree.getChildren(), tree.getFileOptions());
                }
                catch (ConfigRuntimeException e) {
                    throw new ConfigCompileException(e);
                }
                if (parseTree == Optimizable.PULL_ME_UP) {
                    if (tree.hasChildren()) {
                        ParseTree parseTree2 = tree.getChildAt(0);
                    } else {
                        Object var12_34 = null;
                    }
                }
                if (var12_35 == Optimizable.REMOVE_ME) {
                    tree.setData(new CFunction("p", Target.UNKNOWN));
                    tree.removeChildren();
                } else if (var12_35 != null) {
                    tree.setData(var12_35.getData());
                    tree.setOptimized(var12_35.isOptimized());
                    tree.setChildren(var12_35.getChildren());
                    Construct.SetWasIdentifierHelper(tree.getData(), var12_35.getData(), false);
                    MethodScriptCompiler.optimize(tree, env, envs, procs, compilerErrors);
                    tree.setOptimized(true);
                    if (var12_35.hasBeenMadeStatic()) {
                        fullyStatic = true;
                    }
                }
            }
            catch (ConfigCompileException configCompileException) {
                compilerErrors.add(configCompileException);
                EnumSet<Optimizable.OptimizationOption> enumSet2 = NO_OPTIMIZATIONS;
            }
        }
        if (!fullyStatic) {
            return;
        }
        if (func.preResolveVariables() && hasIVars) {
            return;
        }
        if (tree.getData().val().equals(oldFunctionName) && (var11_26.contains(Optimizable.OptimizationOption.OPTIMIZE_CONSTANT) || var11_26.contains(Optimizable.OptimizationOption.CONSTANT_OFFLINE))) {
            Mixed[] mixedArray = new Mixed[tree.getChildren().size()];
            for (int i = 0; i < tree.getChildren().size(); ++i) {
                mixedArray[i] = tree.getChildAt(i).getData();
            }
            try {
                try {
                    Mixed result;
                    if (var11_26.contains(Optimizable.OptimizationOption.CONSTANT_OFFLINE)) {
                        List<Integer> numArgsList = Arrays.asList(func.numArgs());
                        if (!numArgsList.contains(Integer.MAX_VALUE) && !numArgsList.contains(tree.getChildren().size())) {
                            compilerErrors.add(new ConfigCompileException("Incorrect number of arguments passed to " + tree.getData().val(), tree.getData().getTarget()));
                            result = null;
                        } else {
                            result = func.exec(tree.getData().getTarget(), env, mixedArray);
                        }
                    } else {
                        result = ((Optimizable)func).optimize(tree.getData().getTarget(), env, mixedArray);
                    }
                    if (result != null) {
                        Construct.SetWasIdentifierHelper(tree.getData(), result, false);
                        tree.setData(result);
                        tree.removeChildren();
                    }
                }
                catch (ConfigRuntimeException e) {
                    throw new ConfigCompileException(e);
                }
            }
            catch (ConfigCompileException ex) {
                compilerErrors.add(ex);
            }
        }
    }

    private static boolean eliminateDeadCode(ParseTree tree, Set<Class<? extends Environment.EnvironmentImpl>> envs) {
        if (tree.getData() instanceof CFunction) {
            List<Boolean> branches;
            Function f;
            try {
                f = (Function)FunctionList.getFunction((CFunction)tree.getData(), envs);
            }
            catch (ConfigCompileException | ClassCastException ex) {
                return false;
            }
            List<ParseTree> children = tree.getChildren();
            if (f instanceof BranchStatement) {
                branches = ((BranchStatement)((Object)f)).isBranch(children);
                if (branches.size() != children.size()) {
                    throw new Error(f.getName() + " does not properly implement isBranch. It does not return a value with the same count as the actual children. Expected: " + children.size() + "; Actual: " + branches.size() + "; Code target causing this: " + tree.getTarget());
                }
            } else {
                branches = new ArrayList<Boolean>(children.size());
                for (ParseTree child : children) {
                    branches.add(false);
                }
            }
            boolean doDeletion = false;
            for (int m = 0; m < children.size(); ++m) {
                ParseTree child;
                boolean isBranch = branches.get(m);
                if (doDeletion) {
                    if (isBranch) {
                        doDeletion = false;
                    } else {
                        MSLog.GetLogger().Log(MSLog.Tags.COMPILER, LogLevel.WARNING, "Unreachable code. Consider removing this code.", children.get(m).getTarget());
                        children.remove(m);
                        --m;
                        continue;
                    }
                }
                if ((child = children.get(m)).getData() instanceof CFunction) {
                    Function c;
                    try {
                        c = (Function)FunctionList.getFunction((CFunction)child.getData(), envs);
                    }
                    catch (ConfigCompileException | ClassCastException ex) {
                        continue;
                    }
                    Set<Optimizable.OptimizationOption> options = NO_OPTIMIZATIONS;
                    if (c instanceof Optimizable) {
                        options = ((Optimizable)c).optimizationOptions();
                    }
                    doDeletion = options.contains(Optimizable.OptimizationOption.TERMINAL);
                    boolean subDoDelete = MethodScriptCompiler.eliminateDeadCode(child, envs);
                    if (subDoDelete) {
                        doDeletion = true;
                    }
                }
                if (!isBranch) continue;
                doDeletion = false;
            }
            return doDeletion;
        }
        return false;
    }

    private static void processKeywords(ParseTree tree) throws ConfigCompileException {
        List<ParseTree> children = tree.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            ParseTree node = children.get(i);
            MethodScriptCompiler.processKeywords(node);
            if (!(node.getData() instanceof CKeyword) && (!(node.getData() instanceof CLabel) || !(((CLabel)node.getData()).cVal() instanceof CKeyword)) && (!(node.getData() instanceof CFunction) || KeywordList.getKeywordByName(node.getData().val()) == null)) continue;
            for (int j = i + 1; j < children.size(); ++j) {
                MethodScriptCompiler.processKeywords(children.get(j));
            }
            i = KeywordList.getKeywordByName(node.getData().val()).process(children, i);
        }
    }

    public static Mixed execute(String script, File file, boolean inPureMScript, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, MethodScriptComplete done, Script s, List<Variable> vars) throws ConfigCompileException, ConfigCompileGroupException {
        return MethodScriptCompiler.execute(MethodScriptCompiler.compile(MethodScriptCompiler.lex(script, file, inPureMScript), env, envs), env, done, s, vars);
    }

    public static Mixed execute(ParseTree root, Environment env, MethodScriptComplete done, Script script) {
        return MethodScriptCompiler.execute(root, env, done, script, null);
    }

    public static Mixed execute(ParseTree root, Environment env, MethodScriptComplete done, Script script, List<Variable> vars) {
        if (root == null) {
            return CVoid.VOID;
        }
        if (script == null) {
            script = new Script(null, null, env.getEnv(GlobalEnv.class).GetLabel(), env.getEnvClasses(), new FileOptions(new HashMap<String, String>()));
        }
        if (vars != null) {
            HashMap<String, Variable> varMap = new HashMap<String, Variable>();
            for (Variable v : vars) {
                varMap.put(v.getVariableName(), v);
            }
            for (Mixed tempNode : root.getAllData()) {
                if (!(tempNode instanceof Variable)) continue;
                Variable vv = (Variable)varMap.get(((Variable)tempNode).getVariableName());
                if (vv != null) {
                    ((Variable)tempNode).setVal(vv.getDefault());
                    continue;
                }
                ((Variable)tempNode).setVal("");
            }
        }
        StringBuilder b = new StringBuilder();
        Mixed returnable = null;
        for (ParseTree gg : root.getChildren()) {
            String ret;
            Mixed retc = script.eval(gg, env);
            if (root.numberOfChildren() == 1) {
                returnable = retc;
            }
            if ((ret = retc instanceof CNull ? "null" : retc.val()) == null || ret.trim().isEmpty()) continue;
            b.append(ret).append(" ");
        }
        if (done != null) {
            done.done(b.toString().trim());
        }
        if (returnable != null) {
            return returnable;
        }
        return Static.resolveConstruct(b.toString().trim(), Target.UNKNOWN);
    }

    public static void registerAutoIncludes(Environment env, Script s) {
        for (File f : Static.getAliasCore().autoIncludes) {
            try {
                MethodScriptCompiler.execute(IncludeCache.get(f, env, new Target(0, f, 0)), env, null, s);
            }
            catch (ProgramFlowManipulationException e) {
                ConfigRuntimeException.HandleUncaughtException(ConfigRuntimeException.CreateUncatchableException("Cannot break program flow in auto include files.", e.getTarget()), env);
            }
            catch (ConfigRuntimeException e) {
                e.setEnv(env);
                ConfigRuntimeException.HandleUncaughtException(e, env);
            }
        }
    }
}

