/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core;

import com.laytonsmith.PureUtilities.ExecutionQueueImpl;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.environments.GlobalEnv;
import com.laytonsmith.core.exceptions.CancelCommandException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.exceptions.FunctionReturnException;
import com.laytonsmith.core.functions.Echoes;

public class MethodScriptExecutionQueue
extends ExecutionQueueImpl {
    GlobalEnv env;

    public MethodScriptExecutionQueue(String threadPrefix, String defaultQueueName) {
        super(threadPrefix, defaultQueueName, null);
    }

    public void setEnvironment(GlobalEnv env) {
        this.env = env;
        super.setUncaughtExceptionHandler(this.getExceptionHandler());
    }

    private Thread.UncaughtExceptionHandler getExceptionHandler() {
        Thread.UncaughtExceptionHandler uceh = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                Environment env = Environment.createEnvironment(MethodScriptExecutionQueue.this.env);
                if (e instanceof ConfigRuntimeException) {
                    ConfigRuntimeException.HandleUncaughtException((ConfigRuntimeException)e, env);
                } else if (e instanceof FunctionReturnException) {
                    if (!(((FunctionReturnException)e).getReturn() instanceof CVoid)) {
                        ConfigRuntimeException.DoWarning("Closure is returning a value in an execution queue task, which is unexpected behavior. It may return void however, which will simply stop that one task. " + ((FunctionReturnException)e).getTarget().toString());
                    }
                } else if (e instanceof CancelCommandException) {
                    String msg2 = ((CancelCommandException)e).getMessage().trim();
                    if (!"".equals(msg2)) {
                        Target tt = ((CancelCommandException)e).getTarget();
                        new Echoes.console().exec(tt, env, new CString(msg2, tt));
                    }
                } else {
                    throw new RuntimeException(e);
                }
            }
        };
        return uceh;
    }
}

