/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.compiler;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.core.compiler.Keyword;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class KeywordList {
    private static Map<String, Keyword> keywordList;

    public static void refreshKeywordList() {
        Set<Class<Keyword>> keywords = ClassDiscovery.getDefaultInstance().loadClassesWithAnnotationThatExtend(Keyword.keyword.class, Keyword.class);
        keywordList = new HashMap<String, Keyword>();
        for (Class<Keyword> k : keywords) {
            if (k == Keyword.class) continue;
            try {
                Keyword kk = k.newInstance();
                keywordList.put(kk.getKeywordName(), kk);
            }
            catch (IllegalAccessException | InstantiationException ex) {
                Logger.getLogger(KeywordList.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static Set<Keyword> getKeywordList() {
        return new HashSet<Keyword>(keywordList.values());
    }

    public static Set<String> getKeywordNames() {
        return new HashSet<String>(keywordList.keySet());
    }

    public static Keyword getKeywordByName(String name) {
        return keywordList.get(name);
    }

    static {
        KeywordList.refreshKeywordList();
    }
}

