/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.compiler.keywords;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.compiler.Keyword;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.CKeyword;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.functions.ControlFlow;
import java.util.List;

@Keyword.keyword(value="foreach")
public class ForeachKeyword
extends Keyword {
    private static final String FOREACHELSE = new ControlFlow.foreachelse().getName();

    @Override
    public int process(List<ParseTree> list, int keywordPosition) throws ConfigCompileException {
        ParseTree elseKeyword;
        ParseTree codeBlock;
        ParseTree foreach2 = list.get(keywordPosition);
        Target t = foreach2.getTarget();
        if (list.size() > keywordPosition + 1 && ForeachKeyword.isCodeBlock(codeBlock = list.get(keywordPosition + 1))) {
            this.validateCodeBlock(codeBlock, "");
            foreach2.addChild(ForeachKeyword.getArgumentOrNull(codeBlock));
            list.remove(keywordPosition + 1);
        }
        if (list.size() > keywordPosition + 1 && (elseKeyword = list.get(keywordPosition + 1)).getData() instanceof CKeyword && elseKeyword.getData().val().equals("else")) {
            list.remove(keywordPosition + 1);
            ParseTree codeBlock2 = list.get(keywordPosition + 1);
            if (ForeachKeyword.isCodeBlock(codeBlock2)) {
                this.validateCodeBlock(codeBlock2, "");
                foreach2.addChild(ForeachKeyword.getArgumentOrNull(codeBlock2));
            }
            list.get(keywordPosition).setData(new CFunction(FOREACHELSE, t));
            list.remove(keywordPosition + 1);
        }
        return keywordPosition;
    }

    @Override
    public String docs() {
        return "Loops over each element of a given array, calling the code block for each element.";
    }

    @Override
    public Version since() {
        return MSVersion.V3_3_1;
    }
}

