/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.functions;

import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.core.MethodScriptCompiler;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.Script;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.IVariable;
import com.laytonsmith.core.constructs.IVariableList;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.environments.GlobalEnv;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigCompileGroupException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.exceptions.FunctionReturnException;
import com.laytonsmith.core.functions.AbstractFunction;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.HashMap;
import java.util.Map;

public abstract class CompositeFunction
extends AbstractFunction {
    private static final Map<Class<? extends CompositeFunction>, ParseTree> CACHED_SCRIPTS = new HashMap<Class<? extends CompositeFunction>, ParseTree>();

    @Override
    public final Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
        ParseTree tree;
        if (!CACHED_SCRIPTS.containsKey(this.getClass())) {
            try {
                String script = this.script();
                tree = MethodScriptCompiler.compile(MethodScriptCompiler.lex(script, null, true), env, env.getEnvClasses()).getChildAt(0);
            }
            catch (ConfigCompileException | ConfigCompileGroupException ex) {
                throw new Error(ex);
            }
            if (this.cacheCompile()) {
                CACHED_SCRIPTS.put(this.getClass(), tree);
            }
        } else {
            tree = CACHED_SCRIPTS.get(this.getClass());
        }
        GlobalEnv gEnv = env.getEnv(GlobalEnv.class);
        IVariableList oldVariables = gEnv.GetVarList();
        IVariableList newVariables = new IVariableList();
        newVariables.set(new IVariable(CArray.TYPE, "@arguments", new CArray(t, args.length, args), t));
        gEnv.SetVarList(newVariables);
        Mixed ret = CVoid.VOID;
        try {
            if (gEnv.GetScript() != null) {
                gEnv.GetScript().eval(tree, env);
            } else {
                Script.GenerateScript(null, null).eval(tree, env);
            }
        }
        catch (FunctionReturnException ex) {
            ret = ex.getReturn();
        }
        catch (ConfigRuntimeException ex) {
            if (gEnv.GetStackTraceManager().getCurrentStackTrace().isEmpty()) {
                ex.setTarget(t);
                ConfigRuntimeException.StackTraceElement ste = new ConfigRuntimeException.StackTraceElement(this.getName(), t);
                gEnv.GetStackTraceManager().addStackTraceElement(ste);
            }
            gEnv.GetStackTraceManager().setCurrentTarget(t);
            throw ex;
        }
        gEnv.SetVarList(oldVariables);
        return ret;
    }

    protected abstract String script();

    protected String getBundledCode() {
        return StreamUtils.GetString(CompositeFunction.class.getResourceAsStream("/function_impl/" + this.getName() + ".ms"));
    }

    protected boolean cacheCompile() {
        return true;
    }

    @Override
    public final Mixed execs(Target t, Environment env, Script parent, ParseTree ... nodes) {
        throw new Error(this.getClass().toString());
    }

    @Override
    public final boolean useSpecialExec() {
        return false;
    }
}

