/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.persistence;

import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.DaemonManager;
import com.laytonsmith.PureUtilities.Web.WebUtility;
import com.laytonsmith.annotations.datasource;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.persistence.AbstractDataSource;
import com.laytonsmith.persistence.DataSource;
import com.laytonsmith.persistence.DataSourceException;
import com.laytonsmith.persistence.ReadOnlyException;
import com.laytonsmith.persistence.io.ConnectionMixinFactory;
import java.io.IOException;
import java.net.URI;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.exceptions.JedisConnectionException;

@datasource(value="redis")
public class RedisDataSource
extends AbstractDataSource {
    private Jedis connection;
    private Transaction transaction;
    private JedisShardInfo shardInfo;
    private String host;
    private int port;
    private int timeout;
    private String password;
    private long lastConnected = 0L;

    private RedisDataSource() {
    }

    public RedisDataSource(URI uri, ConnectionMixinFactory.ConnectionMixinOptions options) throws DataSourceException {
        super(uri, options);
        try {
            this.host = uri.getHost();
            this.port = uri.getPort();
            Map<String, String> queryString = WebUtility.getQueryMap(uri.getQuery());
            this.shardInfo = this.port == -1 ? new JedisShardInfo(this.host) : new JedisShardInfo(this.host, this.port);
            if (queryString.containsKey("timeout")) {
                this.timeout = Integer.parseInt(queryString.get("timeout"));
                this.shardInfo.setSoTimeout(this.timeout);
            }
            if (queryString.containsKey("password")) {
                this.password = queryString.get("password");
                this.shardInfo.setPassword(this.password);
            }
            this.connect();
        }
        catch (Exception e) {
            throw new DataSourceException(e.getMessage(), e);
        }
    }

    private void connect() {
        boolean needToConnect = false;
        if (this.connection == null) {
            needToConnect = true;
        } else if (!this.connection.isConnected()) {
            needToConnect = true;
        } else if (this.lastConnected < System.currentTimeMillis() - 10000L) {
            try {
                this.connection.exists("connection.test");
            }
            catch (JedisConnectionException ex) {
                needToConnect = true;
            }
        }
        if (needToConnect) {
            this.connection = new Jedis(this.shardInfo);
        }
    }

    @Override
    public void disconnect() throws DataSourceException {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    @Override
    protected boolean set0(DaemonManager dm, String[] key, String value) throws ReadOnlyException, DataSourceException, IOException {
        String status;
        this.connect();
        String ckey = StringUtils.Join(key, ".");
        try {
            status = this.inTransaction() ? (String)this.transaction.set(ckey, value).get() : this.connection.set(ckey, value);
            this.lastConnected = System.currentTimeMillis();
        }
        catch (JedisConnectionException e) {
            throw new DataSourceException(e);
        }
        return "OK".equals(status);
    }

    @Override
    protected void clearKey0(DaemonManager dm, String[] key) throws ReadOnlyException, DataSourceException, IOException {
        this.connect();
        String ckey = StringUtils.Join(key, ".");
        try {
            if (this.inTransaction()) {
                this.transaction.del(ckey);
            } else {
                this.connection.del(ckey);
            }
            this.lastConnected = System.currentTimeMillis();
        }
        catch (JedisConnectionException e) {
            throw new DataSourceException(e);
        }
    }

    @Override
    protected String get0(String[] key) throws DataSourceException {
        this.connect();
        String ckey = StringUtils.Join(key, ".");
        try {
            String ret = this.inTransaction() ? (String)this.transaction.get(ckey).get() : this.connection.get(ckey);
            this.lastConnected = System.currentTimeMillis();
            return ret;
        }
        catch (JedisConnectionException e) {
            throw new DataSourceException(e);
        }
    }

    @Override
    public Set<String[]> keySet(String[] keyBase) throws DataSourceException {
        Set ret;
        this.connect();
        String kb = StringUtils.Join(keyBase, ".") + "*";
        try {
            ret = this.inTransaction() ? (Set)this.transaction.keys(kb).get() : this.connection.keys(kb);
            this.lastConnected = System.currentTimeMillis();
        }
        catch (JedisConnectionException e) {
            throw new DataSourceException(e);
        }
        HashSet<String[]> parsed = new HashSet<String[]>();
        for (String s : ret) {
            parsed.add(s.split("\\."));
        }
        return parsed;
    }

    @Override
    public void populate() throws DataSourceException {
    }

    @Override
    public EnumSet<DataSource.DataSourceModifier> implicitModifiers() {
        return EnumSet.of(DataSource.DataSourceModifier.TRANSIENT);
    }

    @Override
    public EnumSet<DataSource.DataSourceModifier> invalidModifiers() {
        return EnumSet.of(DataSource.DataSourceModifier.HTTP, DataSource.DataSourceModifier.HTTPS, DataSource.DataSourceModifier.PRETTYPRINT, DataSource.DataSourceModifier.SSH);
    }

    @Override
    public String docs() {
        return "Redis {redis://host:port?timeout=90&password=pass} This type allows a connection to a  redis server. A redis server must be set up and running, and if not \"localhost,\" it is heavily recommended to be async as well. Instructions for download and setup can be found at http://redis.io/download though Windows does not appear to be officially supported. The options in the url may be set to provide additional connection information.";
    }

    @Override
    public MSVersion since() {
        return MSVersion.V3_3_1;
    }

    @Override
    protected void startTransaction0(DaemonManager dm) {
        dm.activateThread(null);
        this.connection.multi();
        dm.deactivateThread(null);
    }

    @Override
    protected void stopTransaction0(DaemonManager dm, boolean rollback) throws DataSourceException, IOException {
        dm.activateThread(null);
        if (rollback) {
            this.transaction.discard();
        } else {
            this.transaction.exec();
        }
        dm.deactivateThread(null);
    }
}

