/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.tools.docgen.localization;

import com.laytonsmith.PureUtilities.Common.FileUtil;
import com.laytonsmith.PureUtilities.Common.FileWriteMode;
import com.laytonsmith.PureUtilities.Common.MutableObject;
import com.laytonsmith.PureUtilities.SAXDocument;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xml.sax.SAXException;

public class TranslationSummary {
    private final Map<String, TranslationSummaryEntry> entries = new HashMap<String, TranslationSummaryEntry>();
    private final File translationDb;
    private int nextId = 0;

    public TranslationSummary(File translationDb) throws IOException {
        this.translationDb = translationDb;
        this.initialize();
    }

    private String toSummaryString() {
        StringBuilder b = new StringBuilder();
        b.append("<summary>");
        ArrayList<TranslationSummaryEntry> values = new ArrayList<TranslationSummaryEntry>(this.entries.values());
        Collections.sort(values);
        for (TranslationSummaryEntry tse : values) {
            b.append("<translationEntry>\n");
            b.append("\t<id>").append(tse.id).append("</id>\n");
            b.append("\t<key>").append(this.escape(tse.englishKey)).append("</key>\n");
            b.append("\t<eligibleForMachineTranslation>").append(tse.eligibleForMachineTranslation).append("</eligibleForMachineTranslation>\n");
            b.append("\t<comment>").append(this.escape(tse.comment)).append("</comment>\n");
            b.append("\t<untranslatable>").append(tse.untranslatable).append("</untranslatable>\n");
            b.append("\t<suspectSegment>").append(tse.suspectSegment).append("</suspectSegment>\n");
            b.append("</translationEntry>\n");
        }
        b.append("</summary>\n");
        return b.toString();
    }

    private String escape(String input) {
        if (input == null || "".equals(input)) {
            return "";
        }
        input = input.replace("]]>", "]]]]><![CDATA[>");
        return "<![CDATA[" + input + "]]>";
    }

    public int getNextId() {
        return ++this.nextId;
    }

    public boolean containsTranslation(String key) {
        return this.entries.containsKey(key);
    }

    public int getTranslationId(String key) {
        return this.entries.get(key).id;
    }

    public List<TranslationSummaryEntry> getAllMemories() {
        return new ArrayList<TranslationSummaryEntry>(this.entries.values());
    }

    public TranslationSummaryEntry getMemory(String key) {
        return this.entries.get(key);
    }

    public void addTranslation(String key, int id) {
        if (this.containsTranslation(key)) {
            throw new Error("The summary already contains an entry with key! " + key);
        }
        TranslationSummaryEntry v = new TranslationSummaryEntry(key, id);
        this.entries.put(key, v);
    }

    public void save() throws IOException {
        FileUtil.write(this.toSummaryString(), new File(this.translationDb, "summary.xml"), FileWriteMode.OVERWRITE, true);
    }

    public Boolean isMachineTranslatable(String key) {
        return this.entries.get(key).eligibleForMachineTranslation;
    }

    private void initialize() throws IOException {
        File f = new File(this.translationDb, "summary.xml");
        if (!f.exists()) {
            FileUtil.write("<summary></summary>", f);
        }
        SAXDocument sd = new SAXDocument(new FileInputStream(f));
        MutableObject id = new MutableObject();
        MutableObject key = new MutableObject();
        MutableObject eligibleForMachineTranslation = new MutableObject();
        MutableObject comment = new MutableObject();
        MutableObject untranslatable = new MutableObject();
        MutableObject<Boolean> suspectSegment = new MutableObject<Boolean>(false);
        sd.addListener("/summary/translationEntry/id", (xpath, tag, attr, contents) -> id.setObject(Integer.parseInt(contents)));
        sd.addListener("/summary/translationEntry/key", (xpath, tag, attr, contents) -> key.setObject(contents));
        sd.addListener("/summary/translationEntry/eligibleForMachineTranslation", (xpath, tag, attr, contents) -> {
            Boolean b = "true".equals(contents) ? Boolean.valueOf(true) : ("false".equals(contents) ? Boolean.valueOf(false) : null);
            eligibleForMachineTranslation.setObject(b);
        });
        sd.addListener("/summary/translationEntry/comment", (xpath, tag, attr, contents) -> comment.setObject(contents));
        sd.addListener("/summary/translationEntry/untranslatable", (xpath, tag, attr, contents) -> untranslatable.setObject(Boolean.valueOf(contents)));
        sd.addListener("/summary/translationEntry/suspectSegment", (xpath, tag, attr, contents) -> suspectSegment.setObject(Boolean.valueOf(contents)));
        sd.addListener("/summary/translationEntry", (xpath, tag, attr, contents) -> {
            TranslationSummaryEntry tse = new TranslationSummaryEntry((String)key.getObject(), (Integer)id.getObject());
            tse.eligibleForMachineTranslation = (Boolean)eligibleForMachineTranslation.getObject();
            tse.comment = (String)comment.getObject();
            tse.untranslatable = (Boolean)untranslatable.getObject();
            tse.suspectSegment = (Boolean)suspectSegment.getObject();
            this.entries.put((String)key.getObject(), tse);
            this.nextId = Math.max(this.nextId, tse.id);
            id.setObject(null);
            key.setObject(null);
            eligibleForMachineTranslation.setObject(null);
            comment.setObject(null);
            untranslatable.setObject(false);
            suspectSegment.setObject(false);
        });
        try {
            sd.parse();
        }
        catch (SAXException ex) {
            throw new IOException(ex);
        }
    }

    public Set<String> validate() {
        HashSet<String> errors = new HashSet<String>();
        for (TranslationSummaryEntry tse : this.entries.values()) {
            for (TranslationSummaryEntry tse2 : this.entries.values()) {
                if (tse == tse2) continue;
                if (tse.id == tse2.id) {
                    errors.add("Two entries in the summary.xml file have the same id: " + tse.id);
                }
                if (!tse.englishKey.equals(tse2.englishKey)) continue;
                errors.add("Two entries in the summary.xml file have the same key: " + tse.id + " and " + tse2.id);
            }
        }
        return errors;
    }

    public int size() {
        return this.entries.size();
    }

    public class TranslationSummaryEntry
    implements Comparable<TranslationSummaryEntry> {
        private final String englishKey;
        private final int id;
        private Boolean eligibleForMachineTranslation = null;
        private boolean untranslatable = false;
        private boolean suspectSegment = false;
        private String comment;

        public TranslationSummaryEntry(String englishKey, int id) {
            this.englishKey = englishKey;
            this.id = id;
        }

        @Override
        public int compareTo(TranslationSummaryEntry t) {
            return new Integer(this.id).compareTo(t.id);
        }

        public String getEnglishKey() {
            return this.englishKey;
        }

        public int getId() {
            return this.id;
        }

        public Boolean getEligibleForMachineTranslation() {
            return this.eligibleForMachineTranslation;
        }

        public String getComment() {
            return this.comment;
        }

        public boolean isUntranslatable() {
            return this.untranslatable;
        }

        public boolean isSuspectSegment() {
            return this.suspectSegment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public void setEligibleForMachineTranslation(Boolean eligibleForMachineTranslation) {
            this.eligibleForMachineTranslation = eligibleForMachineTranslation;
        }

        public void setSuspectSegment(boolean suspectSegment) {
            this.suspectSegment = suspectSegment;
        }

        public void setUntranslatable(boolean untranslatable) {
            this.untranslatable = untranslatable;
        }
    }
}

