/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.tools.pnviewer;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.Common.ArrayUtils;
import com.laytonsmith.PureUtilities.Common.AutoFlushObjectOutputStream;
import com.laytonsmith.PureUtilities.Common.StackTraceUtils;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.Common.TemplateBuilder;
import com.laytonsmith.PureUtilities.Common.UIUtils;
import com.laytonsmith.PureUtilities.UI.TextDialog;
import com.laytonsmith.abstraction.Implementation;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.MarshalException;
import com.laytonsmith.core.functions.DataHandling;
import com.laytonsmith.persistence.DataSourceException;
import com.laytonsmith.persistence.PersistenceNetwork;
import com.laytonsmith.persistence.PersistenceNetworkImpl;
import com.laytonsmith.persistence.io.ConnectionMixinFactory;
import com.laytonsmith.tools.pnviewer.ConfigurationLoaderDialog;
import com.laytonsmith.tools.pnviewer.ManageBookmarksDialog;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class PNViewer
extends JFrame {
    private Map<String, String> data;
    private VirtualPersistenceNetwork network;
    private Boolean isLocalConfig = null;
    private Thread remoteSocketThread;
    private Socket remoteSocket;
    private ObjectOutputStream remoteOutput;
    private ObjectInputStream remoteInput;
    private ConfigurationLoaderDialog loaderDialog;
    private String localPath;
    private static final int PROTOCOL_VERSION = 2;
    private JMenuItem aboutMenu;
    private JMenu bookmarksMenu;
    private JMenuItem closeRemoteConnectionMenu;
    private JLabel configurationFromLabel;
    private JMenu fileMenu;
    private JMenuItem helpMenu;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JMenu jMenu1;
    private JMenuBar jMenuBar1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JPopupMenu.Separator jSeparator1;
    private JSplitPane jSplitPane1;
    private JLabel keyLabel;
    private JTree keyTree;
    private JMenuItem loadFromConfigurationMenu;
    private JMenuItem manageBookmarksMenu;
    private JLabel namespaceLabel;
    private JButton reloadButton;
    private JLabel sourceLabel;
    private JLabel statusLabel;
    private JProgressBar statusProgressBar;
    private JTextArea valueTextArea;
    private JLabel valueTypeLabel;

    public PNViewer() {
        this.initComponents();
        this.setTitle("Persistence Network Viewer");
        this.configurationFromLabel.setText("");
        this.namespaceLabel.setText("");
        this.keyLabel.setText("");
        this.valueTypeLabel.setText("");
        this.sourceLabel.setText("");
        try {
            this.setIconImage(ImageIO.read(PNViewer.class.getResourceAsStream("GearIcon.png")));
        }
        catch (IOException ex) {
            Logger.getLogger(PNViewer.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.setStatus("Waiting for configuration to be loaded...", false);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (PNViewer.this.remoteSocketThread != null && PNViewer.this.remoteSocketThread.isAlive()) {
                    int sel = JOptionPane.showConfirmDialog(PNViewer.this, "A connection to the remote server is still active, are you sure you wish to disconnect?", "Confirm", 0, 2);
                    if (sel == 0) {
                        System.exit(0);
                    }
                } else {
                    System.exit(0);
                }
            }
        });
        this.loaderDialog = new ConfigurationLoaderDialog((Frame)this, true);
        this.loaderDialog.setLoaderDialogFinish(new ConfigurationLoaderDialog.LoaderDialogFinish(){

            @Override
            public void data(boolean isLocal, String localPath, String host, int port, String password, String remoteFile) {
                PNViewer.this.isLocalConfig = isLocal;
                if (isLocal) {
                    PNViewer.this.loadFromLocal(localPath);
                } else {
                    PNViewer.this.loadFromRemote(host, port, password, remoteFile);
                }
            }
        });
        this.loadFromConfigurationMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIUtils.centerWindowOnWindow(PNViewer.this.loaderDialog, PNViewer.this);
                PNViewer.this.loaderDialog.setVisible(true);
            }
        });
        this.closeRemoteConnectionMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PNViewer.this.remoteSocketThread == null) {
                    PNViewer.this.showError("No remote connection is established.");
                } else {
                    PNViewer.this.setStatus("Closing remote connection...", false);
                    try {
                        PNViewer.this.remoteOutput.writeUTF("DISCONNECT");
                    }
                    catch (IOException ex) {
                        PNViewer.log(ex);
                        try {
                            PNViewer.this.remoteSocket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    PNViewer.this.remoteSocketThread.interrupt();
                }
            }
        });
        this.keyTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                try {
                    String[] key = new String[e.getNewLeadSelectionPath().getPathCount() - 1];
                    for (int i = 1; i < e.getNewLeadSelectionPath().getPathCount(); ++i) {
                        key[i - 1] = (String)((DefaultMutableTreeNode)e.getNewLeadSelectionPath().getPathComponent(i)).getUserObject();
                    }
                    PNViewer.this.showData(PNViewer.this.join(key), (String)PNViewer.this.data.get(PNViewer.this.join(key)));
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
        this.keyTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int selRow = PNViewer.this.keyTree.getRowForLocation(e.getX(), e.getY());
                TreePath selPath = PNViewer.this.keyTree.getPathForLocation(e.getX(), e.getY());
                if (selRow != -1 && SwingUtilities.isRightMouseButton(e)) {
                    StreamUtils.GetSystemOut().println("Right click on " + selPath);
                }
            }
        });
        this.manageBookmarksMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageBookmarksDialog bd = new ManageBookmarksDialog((Frame)PNViewer.this, true);
                UIUtils.centerWindowOnWindow(bd, PNViewer.this);
                bd.setVisible(true);
            }
        });
        this.reloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PNViewer.this.isLocalConfig == null) {
                    PNViewer.this.showError("No configuration is loaded.");
                } else if (PNViewer.this.isLocalConfig.booleanValue()) {
                    PNViewer.this.loadFromLocal(PNViewer.this.localPath);
                } else if (PNViewer.this.remoteSocketThread == null) {
                    PNViewer.this.showError("Remote connection isn't established, cannot reload data");
                } else {
                    try {
                        PNViewer.this.remoteOutput.writeUTF("LOAD-DATA");
                    }
                    catch (IOException ex) {
                        Logger.getLogger(PNViewer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        });
        this.aboutMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TemplateBuilder builder = new TemplateBuilder();
                builder.addTemplate("version", new TemplateBuilder.Generator(){

                    @Override
                    public String generate(String ... args) {
                        return MSVersion.LATEST.toString();
                    }
                });
                builder.addTemplate("implementation", new TemplateBuilder.Generator(){

                    @Override
                    public String generate(String ... args) {
                        try {
                            return Implementation.GetServerType().getBranding();
                        }
                        catch (Exception ex) {
                            return "MethodScript";
                        }
                    }
                });
                builder.addTemplate("clientVersion", new TemplateBuilder.Generator(){

                    @Override
                    public String generate(String ... args) {
                        return Integer.toString(2);
                    }
                });
                String text = builder.build(StreamUtils.GetString(PNViewer.class.getResourceAsStream("AboutDialog.html")));
                TextDialog td = new TextDialog((Frame)PNViewer.this, true, text);
                UIUtils.centerWindowOnWindow(td, PNViewer.this);
                td.setVisible(true);
            }
        });
        this.helpMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TemplateBuilder builder = new TemplateBuilder();
                builder.addTemplate("wiki", new TemplateBuilder.Generator(){

                    @Override
                    public String generate(String ... args) {
                        return "https://methodscript.com/docs/" + MSVersion.LATEST + "/" + args[0] + ".html";
                    }
                });
                builder.addTemplate("jarName", new TemplateBuilder.Generator(){

                    @Override
                    public String generate(String ... args) {
                        return new File(ClassDiscovery.GetClassContainer(PNViewer.class).getPath()).getName();
                    }
                });
                String text = builder.build(StreamUtils.GetString(PNViewer.class.getResourceAsStream("HelpDialog.html")));
                TextDialog td = new TextDialog((Frame)PNViewer.this, false, text);
                UIUtils.centerWindowOnWindow(td, PNViewer.this);
                td.setVisible(true);
            }
        });
    }

    private String join(String[] key) {
        return StringUtils.Join(key, ".");
    }

    private void showData(final String key, String value) {
        String[] split2 = key.split("\\.");
        String[] namespace = new String[split2.length - 1];
        String keyPart = null;
        for (int i = 0; i < split2.length; ++i) {
            if (i == split2.length - 1) {
                keyPart = split2[i];
                continue;
            }
            namespace[i] = split2[i];
        }
        this.namespaceLabel.setText(this.join(namespace));
        this.keyLabel.setText(keyPart);
        if (value == null) {
            this.sourceLabel.setText("");
            this.valueTypeLabel.setText("(empty key)");
            this.valueTextArea.setText("");
        } else {
            this.sourceLabel.setText("(resolving)");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    final String source = PNViewer.this.network.getKeySource(key.split("\\.")).toString();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PNViewer.this.sourceLabel.setText(source);
                        }
                    });
                }
            }).start();
            Construct c = CNull.NULL;
            try {
                c = Construct.json_decode(value, Target.UNKNOWN);
            }
            catch (MarshalException ex) {
                Logger.getLogger(PNViewer.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.valueTypeLabel.setText(new DataHandling.typeof().exec(Target.UNKNOWN, null, c).val());
            this.valueTextArea.setText(c.val());
        }
    }

    private void loadFromLocal(final String path) {
        this.localPath = path;
        new Thread(new Runnable(){

            @Override
            public void run() {
                PNViewer.this.setStatus("Loading from local file system", true);
                PNViewer.this.setProgress(null);
                try {
                    final PersistenceNetwork pn = PNViewer.getPersistenceNetwork(path);
                    VirtualPersistenceNetwork vpn = new VirtualPersistenceNetwork(){

                        @Override
                        public Map<String[], String> getAllData() throws DataSourceException {
                            return pn.getNamespace(ArrayUtils.EMPTY_STRING_ARRAY);
                        }

                        @Override
                        public URI getKeySource(String[] key) {
                            return pn.getKeySource(key);
                        }
                    };
                    PNViewer.this.displayData(vpn);
                }
                catch (DataSourceException | IOException | URISyntaxException ex) {
                    Logger.getLogger(PNViewer.class.getName()).log(Level.SEVERE, null, ex);
                    PNViewer.this.showError(ex.getMessage());
                }
            }
        }).start();
    }

    private void loadFromRemote(final String host, final int port, final String password, final String remoteFile) {
        this.remoteSocketThread = new Thread(new Runnable(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK], 2[TRYBLOCK]], but top level block is 25[CASE]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
        this.remoteSocketThread.start();
    }

    public static void startServer(int port, final String password) throws IOException {
        ServerSocket socket = new ServerSocket(port);
        PNViewer.log("Server started on port " + port + ". Type Ctrl+C to kill the server.");
        PNViewer.log("Process info: " + ManagementFactory.getRuntimeMXBean().getName());
        PNViewer.log("Server version: 2");
        while (true) {
            PNViewer.log("Persistence Network Viewers may now connect to this server.");
            final Socket s = socket.accept();
            PNViewer.log("A client has connected from " + s.getInetAddress().toString());
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Thread waitThread = null;
                    try {
                        final AtomicBoolean dataReceieved = new AtomicBoolean(false);
                        final AtomicBoolean longTimeout = new AtomicBoolean(false);
                        waitThread = new Thread(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    while (true) {
                                        AtomicBoolean atomicBoolean = dataReceieved;
                                        synchronized (atomicBoolean) {
                                            dataReceieved.wait(longTimeout.get() ? 600000L : 10000L);
                                        }
                                        if (!dataReceieved.get()) {
                                            PNViewer.log("No response from client in too long, forcibly closing connection.");
                                            try {
                                                s.close();
                                            }
                                            catch (IOException iOException) {}
                                            break;
                                        }
                                        dataReceieved.set(false);
                                    }
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                        });
                        waitThread.start();
                        ObjectInputStream is = new ObjectInputStream(s.getInputStream());
                        AutoFlushObjectOutputStream os = new AutoFlushObjectOutputStream(s.getOutputStream());
                        int protocolVersion = is.readInt();
                        if (protocolVersion != 2) {
                            PNViewer.log("Client version unsupported: " + protocolVersion);
                            ((ObjectOutputStream)os).writeUTF("VERSION-MISMATCH");
                            return;
                        }
                        PNViewer.log("Client version supported: " + protocolVersion);
                        ((ObjectOutputStream)os).writeUTF("VERSION-OK");
                        String clientPassword = is.readUTF();
                        if (!password.equals(clientPassword)) {
                            PNViewer.log("Client supplied the wrong password, disconnecting.");
                            ((ObjectOutputStream)os).writeUTF("PASSWORD-BAD");
                            ((ObjectOutputStream)os).writeUTF("DISCONNECT");
                            return;
                        }
                        if (!"".equals(password)) {
                            PNViewer.log("Client supplied the correct password");
                        }
                        ((ObjectOutputStream)os).writeUTF("PASSWORD-OK");
                        longTimeout.set(true);
                        String remoteFile = null;
                        PersistenceNetwork pn = null;
                        block33: while (s.isConnected()) {
                            String command = is.readUTF();
                            PNViewer.log("Command received from client: " + command);
                            dataReceieved.set(true);
                            Object object = dataReceieved;
                            synchronized (object) {
                                dataReceieved.notifyAll();
                            }
                            switch (command) {
                                case "DISCONNECT": {
                                    ((ObjectOutputStream)os).writeUTF("DISCONNECT");
                                    break;
                                }
                                case "SET-REMOTE-FILE": {
                                    remoteFile = is.readUTF();
                                    PNViewer.log("File set to " + remoteFile);
                                    if (new File(remoteFile).exists()) {
                                        PNViewer.log("File accepted.");
                                        ((ObjectOutputStream)os).writeUTF("FILE-OK");
                                        continue block33;
                                    }
                                    PNViewer.log("File not accepted.");
                                    ((ObjectOutputStream)os).writeUTF("FILE-BAD");
                                    ((ObjectOutputStream)os).writeUTF("DISCONNECT");
                                    continue block33;
                                }
                                case "LOAD-DATA": {
                                    ((ObjectOutputStream)os).writeUTF("LOAD-DATA");
                                    try {
                                        pn = PNViewer.getPersistenceNetwork(remoteFile);
                                        Map<String[], String> data = pn.getNamespace(ArrayUtils.EMPTY_STRING_ARRAY);
                                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                        ObjectOutputStream oos = new ObjectOutputStream(baos);
                                        oos.writeObject(data);
                                        oos.flush();
                                        byte[] output = baos.toByteArray();
                                        ((ObjectOutputStream)os).writeInt(output.length);
                                        ((ObjectOutputStream)os).write(output);
                                    }
                                    catch (DataSourceException | URISyntaxException ex) {
                                        ((ObjectOutputStream)os).writeUTF("LOAD-ERROR");
                                        ((ObjectOutputStream)os).writeUTF(ex.getMessage());
                                        PNViewer.log("Load error!");
                                        PNViewer.log(ex);
                                    }
                                    continue block33;
                                }
                                case "KEY-SOURCE": {
                                    ((ObjectOutputStream)os).writeUTF("KEY-SOURCE");
                                    String key = is.readUTF();
                                    if (pn == null) {
                                        PNViewer.log("pn is null, can't get key source");
                                        ((ObjectOutputStream)os).writeUTF("DISCONNECT");
                                        continue block33;
                                    }
                                    PNViewer.log("Requested source for key: " + key);
                                    URI uri = pn.getKeySource(key.split("\\."));
                                    PNViewer.log("Responding with: " + uri);
                                    os.writeObject(uri);
                                    continue block33;
                                }
                                default: {
                                    ((ObjectOutputStream)os).writeUTF("DISCONNECT");
                                    break;
                                }
                            }
                            break;
                        }
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        try {
                            s.close();
                        }
                        catch (IOException iOException) {}
                        PNViewer.log("Client has disconnected.");
                        if (waitThread != null) {
                            waitThread.interrupt();
                        }
                    }
                }
            }).start();
        }
    }

    private static PersistenceNetwork getPersistenceNetwork(String configPath) throws URISyntaxException, IOException, DataSourceException {
        File config = new File(configPath);
        ConnectionMixinFactory.ConnectionMixinOptions options = new ConnectionMixinFactory.ConnectionMixinOptions();
        options.setWorkingDirectory(config.getParentFile().getParentFile());
        return new PersistenceNetworkImpl(config, new URI("sqlite://" + new File(config.getParentFile().getParentFile(), "persistence.db").toString().replace('\\', '/')), options);
    }

    private void displayData(VirtualPersistenceNetwork pn) throws DataSourceException {
        this.network = pn;
        final Map<String[], String> data = pn.getAllData();
        HashMap dataSources = new HashMap();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PNViewer.this.data = new HashMap();
                DefaultTreeModel model = (DefaultTreeModel)PNViewer.this.keyTree.getModel();
                DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
                root.removeAllChildren();
                for (String[] key : data.keySet()) {
                    PNViewer.this.data.put(PNViewer.this.join(key), data.get(key));
                    DefaultMutableTreeNode node = root;
                    block1: for (String n : key) {
                        for (int i = 0; i < node.getChildCount(); ++i) {
                            DefaultMutableTreeNode at = (DefaultMutableTreeNode)node.getChildAt(i);
                            if (!n.equals(at.getUserObject())) continue;
                            node = at;
                            continue block1;
                        }
                        DefaultMutableTreeNode newChild = new DefaultMutableTreeNode(n);
                        node.add(newChild);
                        node = newChild;
                    }
                }
                model.reload(root);
                PNViewer.this.setStatus("Data loaded.", false);
            }
        });
    }

    private void setStatus(final String statusString, final boolean thinking) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                PNViewer.this.statusLabel.setText(statusString);
                PNViewer.this.statusProgressBar.setVisible(thinking);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InterruptedException | InvocationTargetException ex) {
                PNViewer.log(ex);
            }
        }
    }

    private void setProgress(final Integer i) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                PNViewer.this.statusProgressBar.setValue(i == null ? 100 : i);
                PNViewer.this.statusProgressBar.setIndeterminate(i == null);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InterruptedException | InvocationTargetException ex) {
                PNViewer.log(ex);
            }
        }
    }

    private void showError(String message) {
        JOptionPane.showMessageDialog(this, message, "Error", 0);
    }

    private static void log(Throwable t) {
        PNViewer.log(StackTraceUtils.GetStacktrace(t));
    }

    private static void log(String message) {
        StreamUtils.GetSystemOut().println("[" + new SimpleDateFormat("yyyy.MM.dd HH:mm:ss z").format(new Date()) + "]: " + message);
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.keyTree = new JTree();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.namespaceLabel = new JLabel();
        this.keyLabel = new JLabel();
        this.valueTypeLabel = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.valueTextArea = new JTextArea();
        this.jLabel6 = new JLabel();
        this.sourceLabel = new JLabel();
        this.jLabel5 = new JLabel();
        this.configurationFromLabel = new JLabel();
        this.statusLabel = new JLabel();
        this.statusProgressBar = new JProgressBar();
        this.reloadButton = new JButton();
        this.jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.loadFromConfigurationMenu = new JMenuItem();
        this.closeRemoteConnectionMenu = new JMenuItem();
        this.bookmarksMenu = new JMenu();
        this.manageBookmarksMenu = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jMenu1 = new JMenu();
        this.helpMenu = new JMenuItem();
        this.aboutMenu = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.jSplitPane1.setDividerLocation(200);
        DefaultMutableTreeNode treeNode1 = new DefaultMutableTreeNode("root");
        this.keyTree.setModel(new DefaultTreeModel(treeNode1));
        this.keyTree.setToolTipText("");
        this.keyTree.setRootVisible(false);
        this.jScrollPane1.setViewportView(this.keyTree);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.jLabel1.setText("Namespace:");
        this.jLabel2.setText("Key:");
        this.jLabel3.setText("Value type:");
        this.jLabel4.setText("Value:");
        this.namespaceLabel.setText(".............");
        this.keyLabel.setText(".............");
        this.valueTypeLabel.setText("............");
        this.valueTextArea.setEditable(false);
        this.valueTextArea.setColumns(20);
        this.valueTextArea.setFont(new Font("Monospaced", 0, 11));
        this.valueTextArea.setLineWrap(true);
        this.valueTextArea.setRows(5);
        this.jScrollPane2.setViewportView(this.valueTextArea);
        this.jLabel6.setText("Source:");
        this.sourceLabel.setText("...........");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 722, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.namespaceLabel)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.keyLabel)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sourceLabel)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.valueTypeLabel))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.namespaceLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.keyLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.sourceLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.valueTypeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 232, Short.MAX_VALUE)));
        this.jSplitPane1.setRightComponent(this.jPanel1);
        this.jLabel5.setText("Configuration from:");
        this.configurationFromLabel.setText("...............");
        this.statusLabel.setText(".........");
        this.reloadButton.setText("Reload");
        this.reloadButton.setToolTipText("Reloads the data from the configuration");
        this.fileMenu.setText("File");
        this.loadFromConfigurationMenu.setText("Load from Configuration...");
        this.fileMenu.add(this.loadFromConfigurationMenu);
        this.closeRemoteConnectionMenu.setText("Close Remote Connection");
        this.fileMenu.add(this.closeRemoteConnectionMenu);
        this.jMenuBar1.add(this.fileMenu);
        this.bookmarksMenu.setText("Bookmarks");
        this.manageBookmarksMenu.setText("Manage Bookmarks...");
        this.bookmarksMenu.add(this.manageBookmarksMenu);
        this.bookmarksMenu.add(this.jSeparator1);
        this.jMenuBar1.add(this.bookmarksMenu);
        this.jMenu1.setText("Help");
        this.helpMenu.setText("Help...");
        this.jMenu1.add(this.helpMenu);
        this.aboutMenu.setText("About...");
        this.jMenu1.add(this.aboutMenu);
        this.jMenuBar1.add(this.jMenu1);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 780, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configurationFromLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.reloadButton)).addGroup(layout.createSequentialGroup().addComponent(this.statusLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.statusProgressBar, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.configurationFromLabel).addComponent(this.reloadButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusProgressBar, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.statusLabel, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        this.pack();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            Logger.getLogger(PNViewer.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                PNViewer pnViewer = new PNViewer();
                UIUtils.centerWindow(pnViewer);
                pnViewer.setVisible(true);
            }
        });
    }

    static /* synthetic */ Socket access$902(PNViewer x0, Socket x1) {
        x0.remoteSocket = x1;
        return x0.remoteSocket;
    }

    static /* synthetic */ ObjectOutputStream access$702(PNViewer x0, ObjectOutputStream x1) {
        x0.remoteOutput = x1;
        return x0.remoteOutput;
    }

    static /* synthetic */ ObjectInputStream access$2002(PNViewer x0, ObjectInputStream x1) {
        x0.remoteInput = x1;
        return x0.remoteInput;
    }

    static /* synthetic */ JButton access$2200(PNViewer x0) {
        return x0.reloadButton;
    }

    static /* synthetic */ Thread access$002(PNViewer x0, Thread x1) {
        x0.remoteSocketThread = x1;
        return x0.remoteSocketThread;
    }

    private static interface VirtualPersistenceNetwork {
        public Map<String[], String> getAllData() throws DataSourceException;

        public URI getKeySource(String[] var1);
    }
}

