/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SAXDocument {
    private final InputStream stream;
    private final Map<String, List<ElementCallback>> callbacks = new HashMap<String, List<ElementCallback>>();

    public SAXDocument(InputStream stream) {
        this.stream = stream;
    }

    public SAXDocument(String document, String encoding) throws UnsupportedEncodingException {
        this(new ByteArrayInputStream(document.getBytes(encoding == null ? "UTF-8" : encoding)));
    }

    public void parse() throws SAXException, IOException {
        SAXParser saxParser;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            saxParser = factory.newSAXParser();
        }
        catch (ParserConfigurationException | SAXException ex) {
            throw new RuntimeException(ex);
        }
        saxParser.parse(this.stream, new DefaultHandler(){
            Stack<String> nodeNames = new Stack();
            Stack<Map<String, AtomicInteger>> nodeCount = new Stack();
            String lastElement = "";
            Map<String, StringBuilder> contents = new HashMap<String, StringBuilder>();
            Stack<Attributes> attributeStack = new Stack();

            @Override
            public void startDocument() throws SAXException {
                this.nodeCount.push(new HashMap());
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                String path;
                this.nodeNames.push(qName);
                Map<String, AtomicInteger> c = this.nodeCount.peek();
                if (!c.containsKey(qName)) {
                    c.put(qName, new AtomicInteger(1));
                } else {
                    c.get(qName).incrementAndGet();
                }
                HashMap counts = new HashMap();
                this.nodeCount.push(counts);
                if (!this.contents.isEmpty()) {
                    StringBuilder b = new StringBuilder();
                    b.append("<").append(qName).append("");
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        b.append(" ").append(attributes.getQName(i)).append("=\"").append(attributes.getValue(i).replace("\"", "&quot;")).append("\"");
                    }
                    b.append(">");
                    this.appendAll(b.toString());
                }
                if (SAXDocument.this.hasListener(path = SAXDocument.this.pathFromMarkers(this.nodeNames, this.nodeCount))) {
                    this.contents.put(SAXDocument.this.getListenerPath(path), new StringBuilder());
                    this.attributeStack.push(attributes);
                }
            }

            @Override
            public void characters(char[] ch, int start, int length2) throws SAXException {
                if (!this.contents.isEmpty()) {
                    String s = SAXDocument.this.fromChars(ch, start, length2);
                    this.appendAll(s);
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                String path = SAXDocument.this.pathFromMarkers(this.nodeNames, this.nodeCount);
                if (SAXDocument.this.hasListener(path)) {
                    String key = SAXDocument.this.getListenerPath(path);
                    StringBuilder b = this.contents.remove(key);
                    Attributes attr = this.attributeStack.pop();
                    LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
                    for (int i = 0; i < attr.getLength(); ++i) {
                        attributes.put(attr.getQName(i), attr.getValue(i));
                    }
                    SAXDocument.this.notifyListeners(path, qName, attributes, b.toString());
                }
                if (!this.contents.isEmpty()) {
                    this.appendAll("</" + qName + ">");
                }
                this.nodeNames.pop();
                this.nodeCount.pop();
            }

            private void appendAll(String s) {
                for (StringBuilder b : this.contents.values()) {
                    b.append(s);
                }
            }
        });
    }

    private String pathFromMarkers(Stack<String> elementStack, Stack<Map<String, AtomicInteger>> nodeCounts) {
        ArrayList<String> elementList = new ArrayList<String>(elementStack);
        ArrayList<Map<String, AtomicInteger>> nodeList = new ArrayList<Map<String, AtomicInteger>>(nodeCounts);
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < elementList.size(); ++i) {
            b.append("/").append((String)elementList.get(i)).append("[").append(((AtomicInteger)((Map)nodeList.get(i)).get(elementList.get(i))).get()).append("]");
        }
        return b.toString();
    }

    private String fromChars(char[] ch, int start, int length2) {
        StringBuilder b = new StringBuilder();
        for (int i = start; i < start + length2; ++i) {
            b.append(ch[i]);
        }
        return b.toString();
    }

    private void notifyListeners(String xpath, String tag, Map<String, String> attr, String contents) {
        for (String key : this.callbacks.keySet()) {
            if (!xpath.matches(key)) continue;
            for (ElementCallback c : this.callbacks.get(key)) {
                c.handleElement(xpath, tag, attr, contents);
            }
        }
    }

    private boolean hasListener(String xpath) {
        for (String key : this.callbacks.keySet()) {
            if (!xpath.matches(key)) continue;
            return true;
        }
        return false;
    }

    private String getListenerPath(String xpath) {
        for (String key : this.callbacks.keySet()) {
            if (!xpath.matches(key)) continue;
            return key;
        }
        return null;
    }

    public void addListener(String xpath, ElementCallback callback) {
        if (xpath.contains(" ")) {
            throw new IllegalArgumentException("The xpath may not contain spaces");
        }
        if (xpath.startsWith("//") || !xpath.startsWith("/")) {
            throw new IllegalArgumentException("The xpath must be absolute, meaning it must start with exactly 1 forward slash");
        }
        if (!this.callbacks.containsKey(xpath = this.standardizeXpath(xpath))) {
            this.callbacks.put(xpath, new ArrayList());
        }
        this.callbacks.get(xpath).add(callback);
    }

    private String standardizeXpath(String xpath) {
        String[] parts = xpath.substring(1).split("/");
        StringBuilder b = new StringBuilder();
        for (String part : parts) {
            if (!part.matches(".*\\[(?:\\d+|\\*)\\]$")) {
                part = part + "[*]";
            }
            b.append("/").append(part);
        }
        xpath = "^" + b.toString().replace("[*]", "[\\d+]").replace("[", "\\[").replace("]", "\\]") + "$";
        return xpath;
    }

    public static interface ElementCallback {
        public void handleElement(String var1, String var2, Map<String, String> var3, String var4);
    }
}

