/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities;

import com.laytonsmith.PureUtilities.SignalType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import sun.misc.Signal;

public class SignalHandler {
    private static final Map<SignalType, SignalCallback> HANDLERS = new HashMap<SignalType, SignalCallback>();
    private static final Set<SignalType> SETUP = new HashSet<SignalType>();

    public static SignalCallback addHandler(final SignalType type, SignalCallback handler) {
        if (!type.isCatchable()) {
            throw new IllegalArgumentException(type.getSignalName() + " cannot be caught, and therefore cannot be registered.");
        }
        SignalCallback last = null;
        if (HANDLERS.containsKey(type)) {
            last = HANDLERS.get(type);
        }
        HANDLERS.put(type, handler);
        if (!SETUP.contains(type)) {
            Signal.handle(new Signal(type.getSignalName()), new sun.misc.SignalHandler(){

                @Override
                public void handle(Signal sig) {
                    boolean handled = ((SignalCallback)HANDLERS.get(type)).handle(type);
                    if (!handled) {
                        if (type.getDefaultAction() == SignalType.DefaultAction.IGNORE) {
                            sun.misc.SignalHandler.SIG_IGN.handle(sig);
                        } else {
                            sun.misc.SignalHandler.SIG_DFL.handle(sig);
                        }
                    }
                }
            });
            SETUP.add(type);
        }
        return last;
    }

    public static void raise(SignalType type) {
        Signal.raise(new Signal(type.getSignalName()));
    }

    public static interface SignalCallback {
        public boolean handle(SignalType var1);
    }
}

