/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit;

import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.abstraction.MCBossBar;
import com.laytonsmith.abstraction.MCCommandMap;
import com.laytonsmith.abstraction.MCCommandSender;
import com.laytonsmith.abstraction.MCConsoleCommandSender;
import com.laytonsmith.abstraction.MCEntity;
import com.laytonsmith.abstraction.MCInventory;
import com.laytonsmith.abstraction.MCInventoryHolder;
import com.laytonsmith.abstraction.MCItemFactory;
import com.laytonsmith.abstraction.MCItemStack;
import com.laytonsmith.abstraction.MCMerchant;
import com.laytonsmith.abstraction.MCOfflinePlayer;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.abstraction.MCPluginManager;
import com.laytonsmith.abstraction.MCRecipe;
import com.laytonsmith.abstraction.MCScoreboard;
import com.laytonsmith.abstraction.MCServer;
import com.laytonsmith.abstraction.MCWorld;
import com.laytonsmith.abstraction.blocks.MCBlockData;
import com.laytonsmith.abstraction.bukkit.BukkitConvertor;
import com.laytonsmith.abstraction.bukkit.BukkitMCBossBar;
import com.laytonsmith.abstraction.bukkit.BukkitMCCommandMap;
import com.laytonsmith.abstraction.bukkit.BukkitMCCommandSender;
import com.laytonsmith.abstraction.bukkit.BukkitMCConsoleCommandSender;
import com.laytonsmith.abstraction.bukkit.BukkitMCInventory;
import com.laytonsmith.abstraction.bukkit.BukkitMCItemFactory;
import com.laytonsmith.abstraction.bukkit.BukkitMCItemStack;
import com.laytonsmith.abstraction.bukkit.BukkitMCMerchant;
import com.laytonsmith.abstraction.bukkit.BukkitMCOfflinePlayer;
import com.laytonsmith.abstraction.bukkit.BukkitMCPluginManager;
import com.laytonsmith.abstraction.bukkit.BukkitMCScoreboard;
import com.laytonsmith.abstraction.bukkit.BukkitMCWorld;
import com.laytonsmith.abstraction.bukkit.blocks.BukkitMCBlockData;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCPlayer;
import com.laytonsmith.abstraction.bukkit.pluginmessages.BukkitMCMessenger;
import com.laytonsmith.abstraction.enums.MCBarColor;
import com.laytonsmith.abstraction.enums.MCBarStyle;
import com.laytonsmith.abstraction.enums.MCInventoryType;
import com.laytonsmith.abstraction.enums.MCVersion;
import com.laytonsmith.abstraction.pluginmessages.MCMessenger;
import com.laytonsmith.core.Static;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.server.BroadcastMessageEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.Recipe;

public class BukkitMCServer
implements MCServer {
    Server s;
    MCVersion version;

    public BukkitMCServer() {
        this.s = Bukkit.getServer();
    }

    public BukkitMCServer(Server server) {
        this.s = server;
    }

    @Override
    public Object getHandle() {
        return this.s;
    }

    public Server __Server() {
        return this.s;
    }

    @Override
    public String getName() {
        return this.s.getName();
    }

    @Override
    public Collection<MCPlayer> getOnlinePlayers() {
        Collection players = this.s.getOnlinePlayers();
        HashSet<MCPlayer> mcpa = new HashSet<MCPlayer>();
        for (Player p2 : players) {
            mcpa.add(new BukkitMCPlayer((Entity)p2));
        }
        return mcpa;
    }

    public static MCServer Get() {
        return new BukkitMCServer();
    }

    @Override
    public boolean dispatchCommand(MCCommandSender sender, String command) {
        Object cs = sender instanceof MCPlayer ? (Player)sender.getHandle() : (CommandSender)sender.getHandle();
        return this.s.dispatchCommand((CommandSender)cs, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String dispatchAndCaptureCommand(MCCommandSender commandSender, String cmd) {
        CommandSender sender = (CommandSender)commandSender.getHandle();
        CommandSenderInterceptor interceptor = new CommandSenderInterceptor(sender);
        CommandSender newCommandSender = (CommandSender)Proxy.newProxyInstance(BukkitMCServer.class.getClassLoader(), new Class[]{CommandSender.class}, (InvocationHandler)interceptor);
        BukkitMCCommandSender aCommandSender = new BukkitMCCommandSender(newCommandSender);
        MCCommandSender oldSender = Static.UninjectPlayer(commandSender);
        Static.InjectPlayer(aCommandSender);
        try {
            this.s.dispatchCommand(newCommandSender, cmd);
        }
        finally {
            Static.UninjectPlayer(aCommandSender);
            if (oldSender != null) {
                Static.InjectPlayer(oldSender);
            }
        }
        return interceptor.getBuffer();
    }

    @Override
    public MCPluginManager getPluginManager() {
        if (this.s.getPluginManager() == null) {
            return null;
        }
        return new BukkitMCPluginManager(this.s.getPluginManager());
    }

    @Override
    public MCPlayer getPlayerExact(String name) {
        Player p2 = this.s.getPlayerExact(name);
        if (p2 == null) {
            return null;
        }
        return new BukkitMCPlayer((Entity)p2);
    }

    @Override
    public MCPlayer getPlayer(String name) {
        Player p2 = this.s.getPlayer(name);
        if (p2 == null) {
            return null;
        }
        return new BukkitMCPlayer((Entity)p2);
    }

    @Override
    public MCPlayer getPlayer(UUID uuid2) {
        Player p2 = this.s.getPlayer(uuid2);
        if (p2 == null) {
            return null;
        }
        return new BukkitMCPlayer((Entity)p2);
    }

    @Override
    public MCEntity getEntity(UUID uuid2) {
        return BukkitConvertor.BukkitGetCorrectEntity(this.s.getEntity(uuid2));
    }

    @Override
    public MCWorld getWorld(String name) {
        World w = this.s.getWorld(name);
        if (w == null) {
            return null;
        }
        return new BukkitMCWorld(w);
    }

    @Override
    public List<MCWorld> getWorlds() {
        ArrayList<MCWorld> list = new ArrayList<MCWorld>();
        for (World w : this.s.getWorlds()) {
            list.add(new BukkitMCWorld(w));
        }
        return list;
    }

    @Override
    public void broadcastMessage(String message) {
        HashSet<CommandSender> recipients = new HashSet<CommandSender>(this.s.getOnlinePlayers());
        recipients.add((CommandSender)this.s.getConsoleSender());
        this.bukkitBroadcastMessage(message, recipients);
    }

    @Override
    public void broadcastMessage(String message, String permission) {
        HashSet<CommandSender> recipients = new HashSet<CommandSender>();
        for (Player player2 : this.s.getOnlinePlayers()) {
            if (!player2.hasPermission(permission)) continue;
            recipients.add((CommandSender)player2);
        }
        recipients.add((CommandSender)this.s.getConsoleSender());
        this.bukkitBroadcastMessage(message, recipients);
    }

    @Override
    public void broadcastMessage(String message, Set<MCCommandSender> recipients) {
        HashSet<CommandSender> bukkitRecipients = new HashSet<CommandSender>();
        if (recipients != null) {
            for (MCCommandSender recipient : recipients) {
                bukkitRecipients.add((CommandSender)recipient.getHandle());
            }
        }
        this.bukkitBroadcastMessage(message, bukkitRecipients);
    }

    private int bukkitBroadcastMessage(String message, Set<CommandSender> recipients) {
        BroadcastMessageEvent broadcastMessageEvent = Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_14) ? new BroadcastMessageEvent(!Bukkit.isPrimaryThread(), message, recipients) : new BroadcastMessageEvent(message, recipients);
        this.s.getPluginManager().callEvent((Event)broadcastMessageEvent);
        if (broadcastMessageEvent.isCancelled()) {
            return 0;
        }
        message = broadcastMessageEvent.getMessage();
        recipients = broadcastMessageEvent.getRecipients();
        for (CommandSender recipient : recipients) {
            recipient.sendMessage(message);
        }
        return recipients.size();
    }

    @Override
    public MCConsoleCommandSender getConsole() {
        return new BukkitMCConsoleCommandSender(this.s.getConsoleSender());
    }

    @Override
    public MCItemFactory getItemFactory() {
        return new BukkitMCItemFactory(this.s.getItemFactory());
    }

    @Override
    public MCCommandMap getCommandMap() {
        return new BukkitMCCommandMap((SimpleCommandMap)ReflectionUtils.invokeMethod(this.s.getClass(), this.s, "getCommandMap"));
    }

    @Override
    public MCOfflinePlayer getOfflinePlayer(String player2) {
        return new BukkitMCOfflinePlayer(this.s.getOfflinePlayer(player2));
    }

    @Override
    public MCOfflinePlayer getOfflinePlayer(UUID uuid2) {
        return new BukkitMCOfflinePlayer(this.s.getOfflinePlayer(uuid2));
    }

    @Override
    public MCOfflinePlayer[] getOfflinePlayers() {
        OfflinePlayer[] offp = this.s.getOfflinePlayers();
        MCOfflinePlayer[] mcoff = new MCOfflinePlayer[offp.length];
        for (int i = 0; i < offp.length; ++i) {
            mcoff[i] = new BukkitMCOfflinePlayer(offp[i]);
        }
        return mcoff;
    }

    @Override
    public String getAPIVersion() {
        return this.s.getBukkitVersion();
    }

    @Override
    public String getServerVersion() {
        return this.s.getVersion();
    }

    @Override
    public MCVersion getMinecraftVersion() {
        if (this.version == null) {
            int temp = this.s.getBukkitVersion().indexOf(45);
            this.version = MCVersion.match(this.s.getBukkitVersion().substring(0, temp).split("\\."));
        }
        return this.version;
    }

    @Override
    public int getPort() {
        return this.s.getPort();
    }

    @Override
    public String getIp() {
        return this.s.getIp();
    }

    @Override
    public boolean getAllowEnd() {
        return this.s.getAllowEnd();
    }

    @Override
    public boolean getAllowFlight() {
        return this.s.getAllowFlight();
    }

    @Override
    public boolean getAllowNether() {
        return this.s.getAllowNether();
    }

    @Override
    public boolean getOnlineMode() {
        return this.s.getOnlineMode();
    }

    @Override
    public int getViewDistance() {
        return this.s.getViewDistance();
    }

    @Override
    public String getWorldContainer() {
        return this.s.getWorldContainer().getPath();
    }

    @Override
    public String getServerName() {
        if (Static.getServer().getMinecraftVersion().lt(MCVersion.MC1_14)) {
            return (String)ReflectionUtils.invokeMethod(Server.class, this.s, "getServerName");
        }
        return "";
    }

    @Override
    public String getMotd() {
        return this.s.getMotd();
    }

    @Override
    public int getMaxPlayers() {
        return this.s.getMaxPlayers();
    }

    @Override
    public List<MCOfflinePlayer> getBannedPlayers() {
        ArrayList<MCOfflinePlayer> list = new ArrayList<MCOfflinePlayer>();
        for (OfflinePlayer p2 : this.s.getBannedPlayers()) {
            list.add(new BukkitMCOfflinePlayer(p2));
        }
        return list;
    }

    @Override
    public List<MCOfflinePlayer> getWhitelistedPlayers() {
        ArrayList<MCOfflinePlayer> list = new ArrayList<MCOfflinePlayer>();
        for (OfflinePlayer p2 : this.s.getWhitelistedPlayers()) {
            list.add(new BukkitMCOfflinePlayer(p2));
        }
        return list;
    }

    @Override
    public List<MCOfflinePlayer> getOperators() {
        ArrayList<MCOfflinePlayer> list = new ArrayList<MCOfflinePlayer>();
        for (OfflinePlayer p2 : this.s.getOperators()) {
            list.add(new BukkitMCOfflinePlayer(p2));
        }
        return list;
    }

    @Override
    public void runasConsole(String cmd) {
        this.s.dispatchCommand((CommandSender)this.s.getConsoleSender(), cmd);
    }

    public String toString() {
        return this.s.toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof BukkitMCServer && this.s.equals(((BukkitMCServer)obj).s);
    }

    public int hashCode() {
        return this.s.hashCode();
    }

    @Override
    public MCInventory createInventory(MCInventoryHolder holder, MCInventoryType type, String title2) {
        InventoryHolder ih = holder == null ? null : (InventoryHolder)holder.getHandle();
        if (title2 == null) {
            return new BukkitMCInventory(Bukkit.createInventory((InventoryHolder)ih, (InventoryType)InventoryType.valueOf((String)type.name())));
        }
        return new BukkitMCInventory(Bukkit.createInventory((InventoryHolder)ih, (InventoryType)InventoryType.valueOf((String)type.name()), (String)title2));
    }

    @Override
    public MCInventory createInventory(MCInventoryHolder holder, int size, String title2) {
        InventoryHolder ih = holder == null ? null : (InventoryHolder)holder.getHandle();
        if (title2 == null) {
            return new BukkitMCInventory(Bukkit.createInventory((InventoryHolder)ih, (int)size));
        }
        return new BukkitMCInventory(Bukkit.createInventory((InventoryHolder)ih, (int)size, (String)title2));
    }

    @Override
    public void banName(String name, String reason, String source) {
        this.s.getBanList(BanList.Type.NAME).addBan(name, reason, null, source);
    }

    @Override
    public void unbanName(String name) {
        this.s.getBanList(BanList.Type.NAME).pardon(name);
    }

    @Override
    public void banIP(String address) {
        this.s.banIP(address);
    }

    @Override
    public Set<String> getIPBans() {
        return this.s.getIPBans();
    }

    @Override
    public void unbanIP(String address) {
        this.s.unbanIP(address);
    }

    @Override
    public MCMessenger getMessenger() {
        return new BukkitMCMessenger(this.s.getMessenger());
    }

    @Override
    public MCScoreboard getMainScoreboard() {
        return new BukkitMCScoreboard(this.s.getScoreboardManager().getMainScoreboard());
    }

    @Override
    public MCScoreboard getNewScoreboard() {
        return new BukkitMCScoreboard(this.s.getScoreboardManager().getNewScoreboard());
    }

    @Override
    public boolean unloadWorld(MCWorld world, boolean save) {
        return this.s.unloadWorld(((BukkitMCWorld)world).__World(), save);
    }

    @Override
    public void savePlayers() {
        this.s.savePlayers();
    }

    @Override
    public void shutdown() {
        this.s.shutdown();
    }

    @Override
    public boolean addRecipe(MCRecipe recipe) {
        return this.s.addRecipe((Recipe)recipe.getHandle());
    }

    @Override
    public List<MCRecipe> getRecipesFor(MCItemStack result) {
        ArrayList<MCRecipe> ret = new ArrayList<MCRecipe>();
        List recipes = this.s.getRecipesFor(((BukkitMCItemStack)result).__ItemStack());
        for (Recipe recipe : recipes) {
            ret.add(BukkitConvertor.BukkitGetRecipe(recipe));
        }
        return ret;
    }

    @Override
    public List<MCRecipe> allRecipes() {
        ArrayList<MCRecipe> ret = new ArrayList<MCRecipe>();
        Iterator recipes = this.s.recipeIterator();
        while (recipes.hasNext()) {
            Recipe recipe = (Recipe)recipes.next();
            ret.add(BukkitConvertor.BukkitGetRecipe(recipe));
        }
        return ret;
    }

    @Override
    public void clearRecipes() {
        this.s.clearRecipes();
    }

    @Override
    public void resetRecipes() {
        this.s.resetRecipes();
    }

    @Override
    public MCBossBar createBossBar(String title2, MCBarColor color2, MCBarStyle style) {
        return new BukkitMCBossBar(this.s.createBossBar(title2, BarColor.valueOf((String)color2.name()), BarStyle.valueOf((String)style.name()), new BarFlag[0]));
    }

    @Override
    public MCBlockData createBlockData(String data) {
        return new BukkitMCBlockData(this.s.createBlockData(data));
    }

    @Override
    public MCMerchant createMerchant(String title2) {
        return new BukkitMCMerchant(this.__Server().createMerchant(title2), title2);
    }

    private class CommandSenderInterceptor
    implements InvocationHandler {
        private final StringBuilder buffer = new StringBuilder();
        private final CommandSender sender;

        public CommandSenderInterceptor(CommandSender sender) {
            this.sender = sender;
        }

        @Override
        public Object invoke(Object o, Method method, Object[] args) throws Throwable {
            if ("sendMessage".equals(method.getName())) {
                this.buffer.append(args[0].toString());
                return Void.TYPE;
            }
            return method.invoke((Object)this.sender, args);
        }

        public String getBuffer() {
            return this.buffer.toString();
        }
    }
}

