/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.compiler;

import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.Variable;
import java.util.List;

public class NewScript {
    ParseTree executable;
    List<Construct> signature;
    String label;

    public NewScript(List<Construct> signature, ParseTree executable, String label) {
        this.signature = signature;
        this.executable = executable;
        this.label = label;
        if ("".equals(label)) {
            this.label = null;
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder(this.label != null ? this.label + ":" : "");
        boolean first = true;
        for (Construct c : this.signature) {
            if (!first) {
                b.append(" ");
            }
            first = false;
            if (c instanceof Variable) {
                Variable var = (Variable)c;
                if (var.isOptional() && !var.getDefault().trim().isEmpty()) {
                    b.append("[").append(var.getVariableName()).append("='").append(var.getDefault()).append("']");
                    continue;
                }
                if (var.isOptional()) {
                    b.append("[").append(var.getVariableName()).append("]");
                    continue;
                }
                b.append(var.getVariableName());
                continue;
            }
            b.append(c.val());
        }
        return b.toString();
    }
}

