/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.MEnum;
import com.laytonsmith.annotations.typeof;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.LogLevel;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CDouble;
import com.laytonsmith.core.constructs.CEntry;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CLabel;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CSlice;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import com.laytonsmith.core.exceptions.CRE.CREIndexOverflowException;
import com.laytonsmith.core.exceptions.CRE.CRERangeException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.functions.ArrayHandling;
import com.laytonsmith.core.functions.BasicLogic;
import com.laytonsmith.core.functions.DataHandling;
import com.laytonsmith.core.natives.interfaces.Booleanish;
import com.laytonsmith.core.natives.interfaces.Iterable;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.core.objects.ObjectModifier;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.Stack;
import java.util.TreeMap;

@typeof(value="ms.lang.array")
public class CArray
extends Construct
implements java.lang.Iterable<Mixed>,
Booleanish,
Iterable {
    public static final CClassType TYPE = CClassType.get(CArray.class);
    private boolean associativeMode = false;
    private long nextIndex = 0L;
    private List<Mixed> array;
    private SortedMap<String, Mixed> associativeArray;
    private String mutVal;
    private CArray parent = null;
    private boolean valueDirty = true;
    private Comparator<String> comparator = new Comparator<String>(){

        private int normalize(int value) {
            if (value < 0) {
                return -1;
            }
            if (value > 0) {
                return 1;
            }
            return 0;
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1 == null && o2 != null) {
                return -1;
            }
            if (o1 == null) {
                return 0;
            }
            if (o2 == null) {
                return 1;
            }
            return this.normalize(o1.compareTo(o2));
        }
    };

    public CArray(Target t) {
        this(t, 0, (Mixed[])null);
    }

    public CArray(Target t, Mixed ... items) {
        this(t, 0, items);
    }

    public CArray(Target t, int initialCapacity) {
        this(t, initialCapacity, (Mixed[])null);
    }

    public CArray(Target t, Collection<Mixed> items) {
        this(t, 0, CArray.getArray(items));
    }

    public CArray(Target t, int initialCapacity, Collection<Mixed> items) {
        this(t, initialCapacity, CArray.getArray(items));
    }

    public CArray(Target t, int initialCapacity, Mixed ... items) {
        super("{}", Construct.ConstructType.ARRAY, t);
        if (initialCapacity == -1) {
            this.associativeMode = true;
        } else if (items != null) {
            for (Mixed item : items) {
                if (!(item instanceof CEntry)) continue;
                this.associativeMode = true;
                break;
            }
        }
        this.associativeArray = new TreeMap<String, Mixed>(this.comparator);
        ArrayList arrayList = this.associativeMode ? new ArrayList() : (initialCapacity > 0 ? new ArrayList(initialCapacity) : (this.array = items != null ? new ArrayList(items.length) : new ArrayList()));
        if (this.associativeMode) {
            if (items != null) {
                for (Mixed item : items) {
                    if (item instanceof CEntry) {
                        this.associativeArray.put(this.normalizeConstruct(((CEntry)item).ckey), ((CEntry)item).construct);
                        continue;
                    }
                    int max2 = Integer.MIN_VALUE;
                    for (String key : this.associativeArray.keySet()) {
                        try {
                            int i = Integer.parseInt(key);
                            max2 = Math.max(max2, i);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    if (max2 == Integer.MIN_VALUE) {
                        max2 = -1;
                    }
                    this.associativeArray.put(Integer.toString(max2 + 1), item);
                    if (!item.isInstanceOf(TYPE)) continue;
                    ((CArray)item).parent = this;
                }
            }
        } else {
            if (items != null) {
                for (Mixed item : items) {
                    this.array.add(item);
                    if (!item.isInstanceOf(TYPE)) continue;
                    ((CArray)item).parent = this;
                }
            }
            this.nextIndex = this.array.size();
        }
        this.setDirty();
    }

    @Override
    public boolean isAssociative() {
        return this.associativeMode;
    }

    protected List<Mixed> getArray() {
        return this.array;
    }

    private static Mixed[] getArray(Collection<Mixed> items) {
        Mixed[] c = new Mixed[items.size()];
        int count = 0;
        for (Mixed cc : items) {
            c[count++] = cc;
        }
        return c;
    }

    public List<Mixed> asList() {
        if (this.inAssociativeMode()) {
            throw new RuntimeException("asList can only be called on a normal array");
        }
        return new ArrayList<Mixed>(this.array);
    }

    protected SortedMap<String, Mixed> getAssociativeArray() {
        return this.associativeArray;
    }

    public boolean inAssociativeMode() {
        return this.associativeMode;
    }

    public static CArray GetAssociativeArray(Target t) {
        return new CArray(t, -1);
    }

    public static CArray GetAssociativeArray(Target t, Mixed[] args) {
        return new CArray(t, -1, args);
    }

    private void setDirty() {
        if (this.valueDirty) {
            return;
        }
        this.setDirty(new HashSet<CArray>());
    }

    private void setDirty(Set<CArray> dirtied) {
        if (dirtied.contains(this)) {
            return;
        }
        this.valueDirty = true;
        if (this.parent != null) {
            dirtied.add(this);
            this.parent.setDirty(dirtied);
        }
    }

    public void reverse(Target t) {
        if (this.associativeMode) {
            throw new CRECastException("Cannot reverse an associative array.", t);
        }
        Collections.reverse(this.array);
        this.setDirty();
    }

    public final void push(Mixed c, Target t) {
        this.push(c, null, t);
    }

    public void push(Mixed c, Integer index, Target t) throws IllegalArgumentException, IndexOutOfBoundsException {
        if (!this.associativeMode) {
            if (index != null) {
                this.array.add(index, c);
            } else {
                this.array.add(c);
            }
            ++this.nextIndex;
        } else {
            if (index != null) {
                throw new IllegalArgumentException("Cannot insert into an associative array");
            }
            int max2 = 0;
            for (String key : this.associativeArray.keySet()) {
                try {
                    int i = Integer.parseInt(key);
                    max2 = Math.max(max2, i);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (c instanceof CEntry) {
                this.associativeArray.put(Integer.toString(max2 + 1), ((CEntry)c).construct());
            } else {
                this.associativeArray.put(Integer.toString(max2 + 1), c);
            }
        }
        if (c.isInstanceOf(TYPE)) {
            ((CArray)c).parent = this;
        }
        this.setDirty();
    }

    @Override
    public Set<Mixed> keySet() {
        LinkedHashSet<Mixed> set;
        if (!this.associativeMode) {
            set = new LinkedHashSet<Mixed>(this.array.size());
            for (int i = 0; i < this.array.size(); ++i) {
                set.add(new CInt(i, Target.UNKNOWN));
            }
        } else {
            set = new LinkedHashSet(this.associativeArray.size());
            for (String key : this.associativeArray.keySet()) {
                set.add(new CString(key, Target.UNKNOWN));
            }
        }
        return set;
    }

    public Set<String> stringKeySet() {
        if (!this.associativeMode) {
            LinkedHashSet<String> set = new LinkedHashSet<String>(this.array.size());
            for (int i = 0; i < this.array.size(); ++i) {
                set.add(Integer.toString(i));
            }
            return set;
        }
        return this.associativeArray.keySet();
    }

    private void setAssociative() {
        this.associativeArray = new TreeMap<String, Mixed>(this.comparator);
        for (int i = 0; i < this.array.size(); ++i) {
            this.associativeArray.put(Integer.toString(i), this.array.get(i));
        }
        this.associativeMode = true;
        this.array = null;
    }

    public void set(Mixed index, Mixed c, Target t) {
        if (!this.associativeMode) {
            if (index instanceof CNull) {
                this.setAssociative();
            } else {
                try {
                    int indx = Static.getInt32(index, t);
                    if ((long)indx > this.nextIndex || indx < 0) {
                        this.setAssociative();
                    } else if ((long)indx == this.nextIndex) {
                        this.push(c, t);
                    } else {
                        this.array.set(indx, c);
                    }
                }
                catch (ConfigRuntimeException e) {
                    this.setAssociative();
                }
            }
        }
        if (this.associativeMode) {
            this.associativeArray.put(this.normalizeConstruct(index), c);
        }
        if (c.isInstanceOf(TYPE)) {
            ((CArray)c).parent = this;
        }
        this.setDirty();
    }

    public final void set(int index, Mixed c, Target t) {
        this.set(new CInt(index, t), c, t);
    }

    public final void set(String index, Mixed c, Target t) {
        this.set(new CString(index, t), c, t);
    }

    public final void set(String index, String value, Target t) {
        this.set(index, (Mixed)new CString(value, t), t);
    }

    public final void set(String index, String value) {
        this.set(index, value, Target.UNKNOWN);
    }

    @Override
    public Mixed get(Mixed index, Target t) {
        if (!this.associativeMode) {
            try {
                return this.array.get(Static.getInt32(index, t));
            }
            catch (IndexOutOfBoundsException e) {
                throw new CREIndexOverflowException("The element at index \"" + index.val() + "\" does not exist", t, e);
            }
        }
        Mixed val = (Mixed)this.associativeArray.get(this.normalizeConstruct(index));
        if (val != null) {
            if (val instanceof CEntry) {
                return ((CEntry)val).construct();
            }
            return val;
        }
        IndexOutOfBoundsException ioobe = new IndexOutOfBoundsException();
        throw new CREIndexOverflowException("The element at index \"" + index.val() + "\" does not exist", t, ioobe);
    }

    public final Mixed get(long index, Target t) {
        return this.get(new CInt(index, t), t);
    }

    @Override
    public final Mixed get(int index, Target t) {
        return this.get(new CInt(index, t), t);
    }

    @Override
    public final Mixed get(String index, Target t) {
        return this.get(new CString(index, t), t);
    }

    public boolean containsKey(String c) {
        if (this.associativeMode) {
            return this.associativeArray.containsKey(c);
        }
        try {
            return Integer.valueOf(c) < this.array.size();
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public final boolean containsKey(int i) {
        return this.containsKey(Integer.toString(i));
    }

    public boolean contains(Mixed c) {
        if (this.associativeMode) {
            return this.associativeArray.containsValue(c);
        }
        return this.array.contains(c);
    }

    public final boolean contains(String c) {
        return this.contains(new CString(c, Target.UNKNOWN));
    }

    public final boolean contains(int i) {
        return this.contains(new CString(Integer.toString(i), Target.UNKNOWN));
    }

    public CArray indexesOf(Mixed value) {
        CArray ret = new CArray(Target.UNKNOWN);
        if (this.associativeMode) {
            for (String key : this.associativeArray.keySet()) {
                if (!BasicLogic.equals.doEquals((Mixed)this.associativeArray.get(key), value)) continue;
                ret.push(new CString(key, Target.UNKNOWN), Target.UNKNOWN);
            }
        } else {
            for (int i = 0; i < this.array.size(); ++i) {
                if (!BasicLogic.equals.doEquals(this.array.get(i), value)) continue;
                ret.push(new CInt(i, Target.UNKNOWN), Target.UNKNOWN);
            }
        }
        return ret;
    }

    @Override
    public String val() {
        if (this.valueDirty) {
            this.getString(new Stack<CArray>(), this.getTarget());
        }
        return this.mutVal;
    }

    @Override
    public String toString() {
        return this.val();
    }

    protected String getString(Stack<CArray> arrays, Target t) {
        if (!this.valueDirty) {
            return this.mutVal;
        }
        StringBuilder b = new StringBuilder();
        b.append("{");
        if (!this.inAssociativeMode()) {
            int i = 0;
            while ((long)i < this.size()) {
                String v;
                Mixed value = this.get(i, t);
                if (value.isInstanceOf(TYPE)) {
                    if (arrays.contains(value)) {
                        v = "*recursion*";
                    } else {
                        arrays.add((CArray)value);
                        v = ((CArray)value).getString(arrays, t);
                        arrays.pop();
                    }
                } else {
                    v = value.val();
                }
                if (i > 0) {
                    b.append(", ");
                }
                b.append(v);
                ++i;
            }
        } else {
            boolean first = true;
            for (String key : this.stringKeySet()) {
                String v;
                if (!first) {
                    b.append(", ");
                }
                first = false;
                if (this.get(key, t) == null) {
                    v = "null";
                } else {
                    Mixed value = this.get(key, t);
                    if (value.isInstanceOf(TYPE)) {
                        if (arrays.contains(value)) {
                            v = "*recursion*";
                        } else {
                            arrays.add((CArray)value);
                            v = ((CArray)value).getString(arrays, t);
                        }
                    } else {
                        v = value.val();
                    }
                }
                b.append(key).append(": ").append(v);
            }
        }
        b.append("}");
        this.mutVal = b.toString();
        this.valueDirty = false;
        return this.mutVal;
    }

    @Override
    public long size() {
        if (this.associativeMode) {
            return this.associativeArray.size();
        }
        return this.array.size();
    }

    @Override
    public CArray clone() {
        CArray clone;
        try {
            clone = (CArray)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
        clone.associativeMode = this.associativeMode;
        if (!this.associativeMode) {
            if (this.array != null) {
                clone.array = new ArrayList<Mixed>(this.array);
            }
        } else if (this.associativeArray != null) {
            clone.associativeArray = new TreeMap<String, Mixed>(this.associativeArray);
        }
        clone.setDirty();
        return clone;
    }

    public CArray deepClone(Target t) {
        return CArray.deepClone(this, t, new ArrayList<CArray[]>());
    }

    private static CArray deepClone(CArray array2, Target t, ArrayList<CArray[]> cloneRefs) {
        for (CArray[] refCouple : cloneRefs) {
            if (refCouple[0] != array2) continue;
            return refCouple[1];
        }
        CArray clone = new CArray(t, (int)array2.size());
        clone.associativeMode = array2.associativeMode;
        cloneRefs.add(new CArray[]{array2, clone});
        for (Mixed key : array2.keySet()) {
            Mixed value = array2.get(key, t);
            if (value.isInstanceOf(TYPE)) {
                value = CArray.deepClone((CArray)value, t, cloneRefs);
            }
            clone.set(key, value, t);
        }
        return clone;
    }

    private String normalizeConstruct(Mixed c) {
        if (c.isInstanceOf(TYPE)) {
            throw new CRECastException("Arrays cannot be used as the key in an associative array", c.getTarget());
        }
        if (c.isInstanceOf(CString.TYPE) || c.isInstanceOf(CInt.TYPE)) {
            return c.val();
        }
        if (c instanceof CNull) {
            return "";
        }
        if (c.isInstanceOf(CBoolean.TYPE)) {
            if (((CBoolean)c).getBoolean()) {
                return "1";
            }
            return "0";
        }
        if (c instanceof CLabel) {
            return this.normalizeConstruct(((CLabel)c).cVal());
        }
        return c.val();
    }

    public Mixed remove(int i) {
        return this.remove(new CInt(i, Target.UNKNOWN));
    }

    public Mixed remove(String s) {
        return this.remove(new CString(s, Target.UNKNOWN));
    }

    public Mixed remove(Mixed construct) {
        Mixed ret;
        String c = this.normalizeConstruct(construct);
        if (!this.associativeMode) {
            try {
                ret = this.array.remove(Integer.parseInt(c));
                --this.nextIndex;
            }
            catch (NumberFormatException e) {
                throw new CRECastException("Expecting an integer, but received \"" + c + "\" (were you expecting an associative array? This array is a normal array.)", construct.getTarget());
            }
            catch (IndexOutOfBoundsException e) {
                throw new CRERangeException("Cannot remove the value at '" + c + "', as no such index exists in the array", construct.getTarget());
            }
        } else {
            ret = (Mixed)this.associativeArray.remove(c);
            if (ret == null) {
                return CNull.NULL;
            }
        }
        this.setDirty();
        return ret;
    }

    public void removeValues(Mixed construct) {
        if (this.associativeMode) {
            Iterator<Mixed> it = this.associativeArray.values().iterator();
            while (it.hasNext()) {
                Mixed c = it.next();
                if (!BasicLogic.equals.doEquals(c, construct)) continue;
                it.remove();
            }
        } else {
            for (int i = this.array.size() - 1; i >= 0; --i) {
                Mixed c = this.array.get(i);
                if (!BasicLogic.equals.doEquals(c, construct)) continue;
                this.array.remove(i);
            }
        }
        this.setDirty();
    }

    public CArray createNew(Target t) {
        try {
            Constructor<?> con = this.getClass().getConstructor(Target.class);
            try {
                return (CArray)con.newInstance(t);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(this.typeof() + " does not support creating a new value.");
        }
        catch (SecurityException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public boolean canBeAssociative() {
        return true;
    }

    @Override
    public Mixed slice(int begin, int end, Target t) {
        return new ArrayHandling.array_get().exec(t, null, new CSlice(begin, (long)end, t));
    }

    @Override
    public String docs() {
        return "An array is a data type, which contains any number of other values.";
    }

    @Override
    public Version since() {
        return MSVersion.V3_0_1;
    }

    @Override
    public Iterator<Mixed> iterator() {
        if (this.associativeMode) {
            throw new RuntimeException("iterator() cannot be called on an associative array");
        }
        return this.array.iterator();
    }

    public void sort(final ArraySortType sort) {
        if (this.associativeMode) {
            this.array = new ArrayList<Mixed>(this.associativeArray.values());
            this.associativeArray.clear();
            this.associativeArray = null;
            this.associativeMode = false;
            MSLog.GetLogger().Log((MSLog.Tag)MSLog.Tags.GENERAL, LogLevel.VERBOSE, "Attempting to sort an associative array; key values will be lost.", this.getTarget());
        }
        this.array.sort(new Comparator<Mixed>(){

            @Override
            public int compare(Mixed o1, Mixed o2) {
                for (int i = 0; i < 2; ++i) {
                    Mixed c = i == 0 ? o1 : o2;
                    if (c.isInstanceOf(TYPE)) {
                        throw new CRECastException("Cannot sort an array of arrays.", CArray.this.getTarget());
                    }
                    if (c.isInstanceOf(CBoolean.TYPE) || c.isInstanceOf(CString.TYPE) || c.isInstanceOf(CInt.TYPE) || c.isInstanceOf(CDouble.TYPE) || c instanceof CNull || c.isInstanceOf(CClassType.TYPE)) continue;
                    throw new CREFormatException("Unsupported type being sorted: " + c.typeof(), CArray.this.getTarget());
                }
                if (o1 instanceof CNull || o2 instanceof CNull) {
                    if (o1 instanceof CNull && o2 instanceof CNull) {
                        return 0;
                    }
                    if (o1 instanceof CNull) {
                        return "".compareTo(o2.val());
                    }
                    return o1.val().compareTo("");
                }
                if (o1.isInstanceOf(CBoolean.TYPE) || o2.isInstanceOf(CBoolean.TYPE)) {
                    if (ArgumentValidation.getBoolean(o1, Target.UNKNOWN) == ArgumentValidation.getBoolean(o2, Target.UNKNOWN)) {
                        return 0;
                    }
                    boolean oo1 = ArgumentValidation.getBoolean(o1, Target.UNKNOWN);
                    boolean oo2 = ArgumentValidation.getBoolean(o2, Target.UNKNOWN);
                    return oo1 < oo2 ? -1 : 1;
                }
                switch (sort) {
                    case REGULAR: {
                        return this.compareRegular(o1, o2);
                    }
                    case NUMERIC: {
                        return this.compareNumeric(o1, o2);
                    }
                    case STRING: {
                        return this.compareString(o1.val(), o2.val());
                    }
                    case STRING_IC: {
                        return this.compareString(o1.val().toLowerCase(), o2.val().toLowerCase());
                    }
                }
                throw ConfigRuntimeException.CreateUncatchableException("Missing implementation for " + sort.name(), Target.UNKNOWN);
            }

            public int compareRegular(Mixed o1, Mixed o2) {
                if (ArgumentValidation.getBoolean(new DataHandling.is_numeric().exec(Target.UNKNOWN, null, o1), Target.UNKNOWN) && ArgumentValidation.getBoolean(new DataHandling.is_numeric().exec(Target.UNKNOWN, null, o2), Target.UNKNOWN)) {
                    return this.compareNumeric(o1, o2);
                }
                if (ArgumentValidation.getBoolean(new DataHandling.is_numeric().exec(Target.UNKNOWN, null, o1), Target.UNKNOWN)) {
                    return -1;
                }
                if (ArgumentValidation.getBoolean(new DataHandling.is_numeric().exec(Target.UNKNOWN, null, o2), Target.UNKNOWN)) {
                    return 1;
                }
                return this.compareString(o1.val(), o2.val());
            }

            public int compareNumeric(Mixed o1, Mixed o2) {
                double d1 = Static.getNumber(o1, o1.getTarget());
                double d2 = Static.getNumber(o2, o2.getTarget());
                return Double.compare(d1, d2);
            }

            public int compareString(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        this.setDirty();
    }

    public boolean isEmpty() {
        return this.size() == 0L;
    }

    public void clear() {
        this.array.clear();
        this.associativeArray.clear();
        this.nextIndex = 0L;
        this.parent = null;
        this.valueDirty = true;
    }

    public void ensureCapacity(int capacity) {
        ((ArrayList)this.array).ensureCapacity(capacity);
    }

    @Override
    public Set<ObjectModifier> getObjectModifiers() {
        return EnumSet.of(ObjectModifier.FINAL);
    }

    @Override
    public CClassType[] getSuperclasses() {
        return new CClassType[]{Mixed.TYPE};
    }

    @Override
    public CClassType[] getInterfaces() {
        return new CClassType[]{Booleanish.TYPE, Iterable.TYPE};
    }

    @Override
    public boolean getBooleanValue(Target t) {
        return this.size() > 0L;
    }

    @MEnum(value="ms.lang.ArraySortType")
    public static enum ArraySortType {
        REGULAR,
        NUMERIC,
        STRING,
        STRING_IC;

    }
}

