/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.typeof;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.Callable;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.MethodScriptCompiler;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.compiler.CompilerEnvironment;
import com.laytonsmith.core.compiler.CompilerWarning;
import com.laytonsmith.core.compiler.FileOptions;
import com.laytonsmith.core.constructs.Auto;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.IVariable;
import com.laytonsmith.core.constructs.InstanceofUtil;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.environments.GlobalEnv;
import com.laytonsmith.core.exceptions.CRE.AbstractCREException;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CREStackOverflowError;
import com.laytonsmith.core.exceptions.CancelCommandException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.exceptions.FunctionReturnException;
import com.laytonsmith.core.exceptions.LoopManipulationException;
import com.laytonsmith.core.exceptions.ProgramFlowManipulationException;
import com.laytonsmith.core.exceptions.StackTraceManager;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

@typeof(value="ms.lang.closure")
public class CClosure
extends Construct
implements Callable {
    public static final long serialVersionUID = 1L;
    protected ParseTree node;
    protected final Environment env;
    protected final String[] names;
    protected final Mixed[] defaults;
    protected final CClassType[] types;
    protected final CClassType returnType;
    public static final CClassType TYPE = CClassType.get(CClosure.class);

    public CClosure(ParseTree node, Environment env, CClassType returnType, String[] names, Mixed[] defaults, CClassType[] types, Target t) {
        super(node != null ? node.toString() : "", Construct.ConstructType.CLOSURE, t);
        this.node = node;
        this.env = env;
        this.names = names;
        this.defaults = defaults;
        this.types = types;
        this.returnType = returnType;
        for (String pName : names) {
            if (!pName.equals("@arguments")) continue;
            env.getEnv(CompilerEnvironment.class).addCompilerWarning(node.getFileOptions(), new CompilerWarning("This closure overrides the builtin @arguments parameter", t, FileOptions.SuppressWarning.OverrideArguments));
            break;
        }
    }

    @Override
    public String val() {
        StringBuilder b = new StringBuilder();
        this.condense(this.getNode(), b);
        return b.toString();
    }

    private void condense(ParseTree node, StringBuilder b) {
        if (node == null) {
            return;
        }
        if (node.getData() instanceof CFunction) {
            b.append(((CFunction)node.getData()).val()).append("(");
            for (int i = 0; i < node.numberOfChildren(); ++i) {
                this.condense(node.getChildAt(i), b);
                if (i == node.numberOfChildren() - 1 || ((CFunction)node.getData()).val().equals("__autoconcat__")) continue;
                b.append(",");
            }
            b.append(")");
        } else if (node.getData().isInstanceOf(CString.TYPE)) {
            String data = ArgumentValidation.getString(node.getData(), node.getTarget());
            b.append("'").append(data.replace("\\", "\\\\").replaceAll("\t", "\\\\t").replaceAll("\n", "\\\\n").replace("'", "\\'")).append("'");
        } else if (node.getData() instanceof IVariable) {
            b.append(((IVariable)node.getData()).getVariableName());
        } else {
            b.append(node.getData().val());
        }
    }

    public ParseTree getNode() {
        return this.node;
    }

    @Override
    public CClosure clone() throws CloneNotSupportedException {
        CClosure clone = (CClosure)super.clone();
        if (this.node != null) {
            clone.node = this.node.clone();
        }
        return clone;
    }

    public synchronized Environment getEnv() {
        return this.env;
    }

    public Mixed executeCallable(Mixed ... values) {
        return this.executeCallable(null, Target.UNKNOWN, values);
    }

    @Override
    public Mixed executeCallable(Environment env, Target t, Mixed ... values) throws ConfigRuntimeException, ProgramFlowManipulationException, CancelCommandException {
        try {
            this.execute(values);
        }
        catch (FunctionReturnException e) {
            return e.getReturn();
        }
        return CVoid.VOID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void execute(Mixed ... values) throws ConfigRuntimeException, ProgramFlowManipulationException, FunctionReturnException, CancelCommandException {
        if (this.node == null) {
            return;
        }
        StackTraceManager stManager = this.env.getEnv(GlobalEnv.class).GetStackTraceManager();
        stManager.addStackTraceElement(new ConfigRuntimeException.StackTraceElement("<<closure>>", this.getTarget()));
        try {
            Environment environment;
            CClosure cClosure = this;
            synchronized (cClosure) {
                environment = this.env.clone();
            }
            if (values != null) {
                for (int i = 0; i < this.names.length; ++i) {
                    Mixed value;
                    String string = this.names[i];
                    try {
                        value = values[i];
                    }
                    catch (Exception e) {
                        value = this.defaults[i].clone();
                    }
                    environment.getEnv(GlobalEnv.class).GetVarList().set(new IVariable(this.types[i], string, value, this.getTarget(), environment));
                }
            }
            boolean hasArgumentsParam = false;
            for (String pName : this.names) {
                if (!pName.equals("@arguments")) continue;
                hasArgumentsParam = true;
                break;
            }
            if (!hasArgumentsParam) {
                CArray cArray = new CArray(this.node.getData().getTarget());
                if (values != null) {
                    for (Mixed value : values) {
                        cArray.push(value, this.node.getData().getTarget());
                    }
                }
                environment.getEnv(GlobalEnv.class).GetVarList().set(new IVariable(CArray.TYPE, "@arguments", cArray, this.node.getData().getTarget()));
            }
            ParseTree parseTree = new ParseTree(new CFunction("g", this.getTarget()), this.node.getFileOptions());
            ArrayList<ParseTree> children = new ArrayList<ParseTree>();
            children.add(this.node);
            parseTree.setChildren(children);
            try {
                MethodScriptCompiler.execute(parseTree, environment, null, environment.getEnv(GlobalEnv.class).GetScript());
            }
            catch (LoopManipulationException e) {
                LoopManipulationException lme = e;
                Target t = lme.getTarget();
                ConfigRuntimeException.HandleUncaughtException(ConfigRuntimeException.CreateUncatchableException("A " + lme.getName() + "() bubbled up to the top of a closure, which is unexpected behavior.", t), environment);
            }
            catch (FunctionReturnException ex) {
                Mixed ret = ex.getReturn();
                if (!InstanceofUtil.isInstanceof(ret, this.returnType, environment)) {
                    throw new CRECastException("Expected closure to return a value of type " + this.returnType.val() + " but a value of type " + ret.typeof() + " was returned instead", ret.getTarget());
                }
                throw ex;
            }
            catch (CancelCommandException ex) {
            }
            catch (ConfigRuntimeException ex) {
                if (ex instanceof AbstractCREException) {
                    ((AbstractCREException)ex).freezeStackTraceElements(stManager);
                }
                throw ex;
            }
            catch (StackOverflowError e) {
                throw new CREStackOverflowError(null, this.node.getTarget(), e);
            }
            finally {
                stManager.popStackTraceElement();
            }
            if (!this.returnType.equals(Auto.TYPE) && !this.returnType.equals(CVoid.TYPE)) {
                throw new CRECastException("Expecting closure to return a value of type " + this.returnType.val() + ", but no value was returned.", this.node.getTarget());
            }
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(CClosure.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public String docs() {
        return "A closure is a data type that contains executable code. This is similar to a procedure, but the value is first class, and can be stored in variables, and executed.";
    }

    @Override
    public Version since() {
        return MSVersion.V3_3_1;
    }

    @Override
    public CClassType[] getSuperclasses() {
        return new CClassType[]{Mixed.TYPE};
    }

    @Override
    public CClassType[] getInterfaces() {
        return CClassType.EMPTY_CLASS_ARRAY;
    }
}

