/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.exceptions.CRE;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.seealso;
import com.laytonsmith.annotations.typeof;
import com.laytonsmith.core.Documentation;
import com.laytonsmith.core.FullyQualifiedClassName;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.NativeTypeList;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CRECausedByWrapper;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.exceptions.StackTraceManager;
import com.laytonsmith.core.natives.interfaces.ArrayAccess;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.core.objects.AccessModifier;
import com.laytonsmith.core.objects.ObjectModifier;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractCREException
extends ConfigRuntimeException
implements Documentation,
Mixed,
ArrayAccess {
    private static final Class[] EMPTY_CLASS = new Class[0];
    private List<ConfigRuntimeException.StackTraceElement> stackTrace = null;
    private CArray exceptionObject = null;

    public AbstractCREException(String msg2, Target t) {
        super(msg2, t);
    }

    public AbstractCREException(String msg2, Target t, Throwable cause) {
        super(msg2, t, cause);
    }

    @Override
    public Class<? extends Documentation>[] seeAlso() {
        seealso see = this.getClass().getAnnotation(seealso.class);
        if (see == null) {
            return EMPTY_CLASS;
        }
        return see.value();
    }

    @Override
    public URL getSourceJar() {
        return ClassDiscovery.GetClassContainer(this.getClass());
    }

    @Override
    public String getName() {
        typeof to = ClassDiscovery.GetClassAnnotation(this.getClass(), typeof.class);
        if (to == null) {
            throw new Error("ConfigRuntimeException subtypes must annotate themselves with @typeof, if they are instantiateable.");
        }
        return to.value();
    }

    @Override
    public AccessModifier getAccessModifier() {
        return AccessModifier.PUBLIC;
    }

    @Override
    public Set<ObjectModifier> getObjectModifiers() {
        return EnumSet.noneOf(ObjectModifier.class);
    }

    public CClassType getExceptionType() {
        return Construct.typeof(this);
    }

    public static String getExceptionName(ConfigRuntimeException ex) {
        if (ex instanceof AbstractCREException) {
            return ((AbstractCREException)ex).getName();
        }
        return ex.getClass().getName();
    }

    public CArray getExceptionObject() {
        CArray ret = CArray.GetAssociativeArray(Target.UNKNOWN);
        ret.set("classType", (Mixed)this.getExceptionType(), Target.UNKNOWN);
        ret.set("message", this.getMessage());
        CArray stackTrace = new CArray(Target.UNKNOWN);
        ret.set("stackTrace", (Mixed)stackTrace, Target.UNKNOWN);
        for (ConfigRuntimeException.StackTraceElement e : this.getCREStackTrace()) {
            CArray element = e.getObjectFor();
            stackTrace.push(element, Target.UNKNOWN);
        }
        ret.set("causedBy", AbstractCREException.getCausedBy(this.getCause()), Target.UNKNOWN);
        return ret;
    }

    public static AbstractCREException getFromCArray(CArray exception, Target t, Environment env) throws ClassNotFoundException {
        FullyQualifiedClassName classType = FullyQualifiedClassName.forName(exception.get("classType", t).val(), t, env);
        Class<? extends Mixed> clzz = NativeTypeList.getNativeClass(classType);
        CRECausedByWrapper cause = null;
        if (exception.get("causedBy", t).isInstanceOf(CArray.TYPE)) {
            cause = new CRECausedByWrapper((CArray)exception.get("causedBy", t));
        }
        String message = exception.get("message", t).val();
        ArrayList<ConfigRuntimeException.StackTraceElement> st = new ArrayList<ConfigRuntimeException.StackTraceElement>();
        for (Mixed consStElement : Static.getArray(exception.get("stackTrace", t), t).asList()) {
            CArray stElement = Static.getArray(consStElement, t);
            int line = Static.getInt32(stElement.get("line", t), t);
            File f = new File(stElement.get("file", t).val());
            int col = Static.getInt32(stElement.get("col", t), t);
            st.add(new ConfigRuntimeException.StackTraceElement(stElement.get("id", t).val(), new Target(line, f, col)));
        }
        Class[] types = new Class[]{String.class, Target.class, Throwable.class};
        Object[] args = new Object[]{message, t, cause};
        AbstractCREException ex = (AbstractCREException)ReflectionUtils.newInstance(clzz, types, args);
        ex.stackTrace = st;
        return ex;
    }

    private static Mixed getCausedBy(Throwable causedBy) {
        if (causedBy == null || !(causedBy instanceof CRECausedByWrapper)) {
            return CNull.NULL;
        }
        CRECausedByWrapper cre = (CRECausedByWrapper)causedBy;
        CArray ret = cre.getException();
        return ret;
    }

    public static AbstractCREException getAbstractCREException(ConfigRuntimeException ex) {
        if (ex instanceof AbstractCREException) {
            return (AbstractCREException)ex;
        }
        throw new Error("Unexpected CRE exception that isn't convertable to AbstractCREException");
    }

    @Override
    public String val() {
        return this.getName() + ":" + this.getMessage();
    }

    @Override
    public Mixed get(String index, Target t) throws ConfigRuntimeException {
        return this.exceptionObject.get(index, t);
    }

    @Override
    public Mixed get(int index, Target t) throws ConfigRuntimeException {
        return this.exceptionObject.get(index, t);
    }

    @Override
    public Mixed get(Mixed index, Target t) throws ConfigRuntimeException {
        return this.exceptionObject.get(index, t);
    }

    @Override
    public Set<Mixed> keySet() {
        return this.exceptionObject.keySet();
    }

    @Override
    public boolean isAssociative() {
        return this.exceptionObject.isAssociative();
    }

    @Override
    public boolean canBeAssociative() {
        return this.exceptionObject.canBeAssociative();
    }

    @Override
    public Mixed slice(int begin, int end, Target t) {
        return this.exceptionObject.slice(begin, end, t);
    }

    @Override
    public AbstractCREException clone() throws CloneNotSupportedException {
        AbstractCREException obj = (AbstractCREException)super.clone();
        return obj;
    }

    public void freezeStackTraceElements(StackTraceManager manager) {
        if (this.stackTrace == null) {
            this.stackTrace = manager.getCurrentStackTrace();
        }
    }

    public void setStackTraceElements(List<ConfigRuntimeException.StackTraceElement> st) {
        if (this.stackTrace != null) {
            throw new RuntimeException("The stacktrace was already set, and it cannot be set again");
        }
        this.stackTrace = st;
    }

    public List<ConfigRuntimeException.StackTraceElement> getCREStackTrace() {
        if (this.stackTrace == null) {
            return new ArrayList<ConfigRuntimeException.StackTraceElement>();
        }
        return new ArrayList<ConfigRuntimeException.StackTraceElement>(this.stackTrace);
    }

    @Override
    public Version since() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String docs() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public CClassType[] getInterfaces() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CClassType[] getSuperclasses() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isInstanceOf(CClassType type) {
        return Construct.isInstanceof((Mixed)this, type);
    }

    @Override
    public boolean isInstanceOf(Class<? extends Mixed> type) {
        return Construct.isInstanceof((Mixed)this, type);
    }

    @Override
    public CClassType typeof() {
        return Construct.typeof(this);
    }
}

