/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.tools;

import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.TermColors;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProfilerSummary {
    private static final Pattern PATTERN = Pattern.compile("\\d{4}-\\d{2}-\\d{2} \\d{1,2}:\\d{2}\\.\\d{2}:\\s*\\[(\\d+\\.\\d+)ms\\]\\[Lvl:(4|5)\\]:\\s*Executing function: ([a-zA-Z_]+[a-zA-Z0-9_]*)\\(.*\\).*");
    private String data;
    private double ignorePercentage = 0.0;

    public ProfilerSummary(InputStream input) {
        this(StreamUtils.GetString(input));
    }

    public ProfilerSummary(String data) {
        this.data = data;
    }

    public void setIgnorePercentage(double percentage) {
        if (percentage < 0.0 || percentage > 1.0) {
            throw new IllegalArgumentException("The percentage must be between 0 and 1.");
        }
        this.ignorePercentage = percentage;
    }

    public String getAnalysis() {
        HashMap<String, Object> functionData = new HashMap<String, Object>();
        Matcher m = PATTERN.matcher(this.data);
        double totalTime = 0.0;
        boolean foundLevel5 = false;
        while (m.find()) {
            String function = m.group(3);
            if ("5".equals(m.group(2))) {
                foundLevel5 = true;
            }
            Double time2 = Double.parseDouble(m.group(1));
            totalTime += time2.doubleValue();
            if (functionData.containsKey(function)) {
                functionData.put(function, (Double)functionData.get(function) + time2);
                continue;
            }
            functionData.put(function, time2);
        }
        if (!foundLevel5) {
            return "Analysis can only be done on a profile summary file, which was created with verbosity level 5.";
        }
        int originalSize = functionData.size();
        for (String f : new ArrayList(functionData.keySet())) {
            if (!((Double)functionData.get(f) / totalTime <= this.ignorePercentage)) continue;
            functionData.remove(f);
        }
        StringBuilder b = new StringBuilder();
        b.append("Profiler data summary:\n\n");
        b.append(StringUtils.PluralTemplateHelper(functionData.size(), "One function was", "%d functions were")).append(" profiled in total");
        if (originalSize == functionData.size()) {
            b.append(".");
        } else {
            b.append(", and ");
            b.append(StringUtils.PluralTemplateHelper(originalSize - functionData.size(), "one function is", "%d functions are"));
            b.append(" being hidden from the report, as they are less than ").append((int)(this.ignorePercentage * 100.0)).append("% of the total time spent.");
        }
        b.append("\n\n");
        Map sortedMap = ProfilerSummary.sortByValue(functionData);
        ArrayList keySet = new ArrayList(sortedMap.keySet());
        Collections.reverse(keySet);
        for (String f : keySet) {
            b.append(TermColors.WHITE).append(f).append(TermColors.RESET).append(": ").append(String.format("%.3f", sortedMap.get(f))).append(" ms\n");
        }
        return b.toString();
    }

    private static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                return ((Comparable)o1.getValue()).compareTo(o2.getValue());
            }
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }
}

