/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.ClassLoading;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscoveryURLCache;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.ProgressIterator;
import com.laytonsmith.PureUtilities.ZipReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ClassDiscoveryCache {
    public static final String OUTPUT_FILENAME = "jarInfo.ser";
    private static final int READ_SIZE = 2048;
    private final File cacheDir;
    private ProgressIterator progress;
    private Logger logger;
    private static final Object CACHE_WRITE_LOCK = new Object();

    public ClassDiscoveryCache(File cacheDir) {
        this.cacheDir = cacheDir;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassDiscoveryURLCache getURLCache(URL fromClassLocation) {
        if (fromClassLocation.toString().endsWith(".jar")) {
            Object digest2;
            File cacheOutputName = null;
            try {
                byte[] data;
                File jarFile = new File(URLDecoder.decode(fromClassLocation.getFile(), "UTF8"));
                try (FileInputStream fis = new FileInputStream(jarFile);){
                    data = new byte[2048];
                    fis.read(data);
                }
                digest2 = MessageDigest.getInstance("MD5");
                ((MessageDigest)digest2).update(data);
                String fileName = StringUtils.toHex(((MessageDigest)digest2).digest());
                cacheOutputName = new File(this.cacheDir, fileName);
                if (cacheOutputName.exists()) {
                    ZipReader cacheReader = new ZipReader(new File(cacheOutputName, "data"));
                    return new ClassDiscoveryURLCache(fromClassLocation, cacheReader.getInputStream());
                }
            }
            catch (Exception jarFile) {
                // empty catch block
            }
            try {
                JarFile jfile = new JarFile(URLDecoder.decode(fromClassLocation.getFile(), "UTF8"));
                InputStream is = jfile.getInputStream(new ZipEntry(OUTPUT_FILENAME));
                if (is != null) {
                    try {
                        return new ClassDiscoveryURLCache(fromClassLocation, is);
                    }
                    catch (Exception digest2) {}
                }
            }
            catch (IOException ex) {
                Logger.getLogger(ClassDiscoveryCache.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (this.logger != null) {
                this.logger.log(Level.INFO, "Performing one time scan of {0}, this may take a few moments.", fromClassLocation);
            }
            ClassDiscoveryURLCache cache = new ClassDiscoveryURLCache(fromClassLocation, this.progress);
            if (cacheOutputName != null) {
                try {
                    digest2 = CACHE_WRITE_LOCK;
                    synchronized (digest2) {
                        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(cacheOutputName, false));){
                            zos.putNextEntry(new ZipEntry("data"));
                            cache.writeDescriptor(zos);
                        }
                    }
                }
                catch (IOException ex) {
                    if (this.logger != null) {
                        this.logger.log(Level.SEVERE, null, ex);
                    }
                    Logger.getLogger(ClassDiscoveryCache.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            return cache;
        }
        return new ClassDiscoveryURLCache(fromClassLocation, this.progress);
    }

    public void setProgressIterator(ProgressIterator progress) {
        this.progress = progress;
    }
}

