/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.ClassLoading.ClassMirror;

import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.AbstractElementMirror;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.AnnotationMirror;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.ClassReferenceMirror;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.MethodMirror;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.ModifierMirror;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class AbstractMethodMirror
extends AbstractElementMirror {
    private static final long serialVersionUID = 1L;
    private final List<ClassReferenceMirror> params;
    private boolean isVararg = false;
    private boolean isSynthetic = false;
    private Member underlyingMethod = null;

    public AbstractMethodMirror(ClassReferenceMirror parentClass, List<AnnotationMirror> annotations, ModifierMirror modifiers, ClassReferenceMirror type, String name, List<ClassReferenceMirror> params, boolean isVararg, boolean isSynthetic, String signature) {
        super(parentClass, annotations, modifiers, type, name, signature);
        Objects.requireNonNull(params, "params cannot be null");
        this.params = params;
        this.isVararg = isVararg;
        this.isSynthetic = isSynthetic;
    }

    public AbstractMethodMirror(Member method) {
        super(method);
        this.underlyingMethod = method;
        this.params = null;
    }

    AbstractMethodMirror(ClassReferenceMirror parentClass, ModifierMirror modifiers, ClassReferenceMirror type, String name, List<ClassReferenceMirror> params, boolean isVararg, boolean isSynthetic, String signature) {
        super(parentClass, null, modifiers, type, name, signature);
        this.annotations = new ArrayList();
        Objects.requireNonNull(params, "params cannot be null");
        this.params = params;
        this.isVararg = isVararg;
        this.isSynthetic = isSynthetic;
    }

    public List<ClassReferenceMirror> getParams() {
        if (this.underlyingMethod != null) {
            ArrayList<ClassReferenceMirror> list = new ArrayList<ClassReferenceMirror>();
            for (Class<?> p2 : ((Method)this.underlyingMethod).getParameterTypes()) {
                list.add(ClassReferenceMirror.fromClass(p2));
            }
            return list;
        }
        return new ArrayList<ClassReferenceMirror>(this.params);
    }

    public boolean isVararg() {
        if (this.underlyingMethod != null) {
            return ((Method)this.underlyingMethod).isVarArgs();
        }
        return this.isVararg;
    }

    public boolean isSynthetic() {
        if (this.underlyingMethod != null) {
            return this.underlyingMethod.isSynthetic();
        }
        return this.isSynthetic;
    }

    public String toString() {
        if (this.underlyingMethod != null) {
            return this.underlyingMethod.toString();
        }
        ArrayList<String> sParams = new ArrayList<String>();
        for (int i = 0; i < this.params.size(); ++i) {
            if (i == this.params.size() - 1 && this.isVararg) {
                sParams.add(this.params.get(i).getComponentType().toString() + "...");
                continue;
            }
            sParams.add(this.params.get(i).toString());
        }
        return StringUtils.Join(this.annotations, "\n") + (this.annotations.isEmpty() ? "" : "\n") + (this.modifiers.toString() + " " + this.type).trim() + " " + this.name + "(" + StringUtils.Join(sParams, ", ") + "){}";
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof MethodMirror)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AbstractMethodMirror m = (AbstractMethodMirror)obj;
        return Objects.equals(this.params, m.params) && this.isVararg == m.isVararg && this.isSynthetic == m.isSynthetic;
    }

    @Override
    public int hashCode() {
        int hash2 = 5;
        hash2 = 31 * hash2 + super.hashCode();
        hash2 = 31 * hash2 + Objects.hashCode(this.params);
        hash2 = 31 * hash2 + (this.isVararg ? 1 : 0);
        hash2 = 31 * hash2 + (this.isSynthetic ? 1 : 0);
        return hash2;
    }

    protected Member getExecutable() {
        return this.underlyingMethod;
    }
}

