/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.Common;

public class OSUtils {
    public static OS GetOS() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            return OS.WINDOWS;
        }
        if (os.contains("mac")) {
            return OS.MAC;
        }
        if (os.contains("nix") || os.contains("nux")) {
            return OS.LINUX;
        }
        if (os.contains("sunos")) {
            return OS.SOLARIS;
        }
        return OS.UNKNOWN;
    }

    public static String GetLineEnding() {
        return System.getProperty("line.separator");
    }

    public static enum OS {
        WINDOWS,
        MAC,
        LINUX,
        SOLARIS,
        UNKNOWN;


        public boolean isWindows() {
            return this == WINDOWS;
        }

        public boolean isMac() {
            return this == MAC;
        }

        public boolean isLinux() {
            return this == LINUX;
        }

        public boolean isSolaris() {
            return this == SOLARIS;
        }

        public boolean isUnknown() {
            return this == UNKNOWN;
        }

        public boolean isUnix() {
            return this == MAC || this == SOLARIS;
        }

        public boolean isUnixLike() {
            return this.isUnix() || this == LINUX;
        }
    }
}

