/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.enums;

import com.laytonsmith.PureUtilities.ClassLoading.DynamicEnum;
import com.laytonsmith.abstraction.enums.MCVersion;
import com.laytonsmith.annotations.MDynamicEnum;
import com.laytonsmith.core.Static;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@MDynamicEnum(value="com.commandhelper.Particle")
public abstract class MCParticle<Concrete>
extends DynamicEnum<MCVanillaParticle, Concrete> {
    protected static final Map<String, MCParticle> MAP = new HashMap<String, MCParticle>();
    public static MCParticle NULL = null;

    public MCParticle(MCVanillaParticle mcVanillaParticle, Concrete concrete) {
        super(mcVanillaParticle, concrete);
    }

    public static MCParticle valueOf(String test) throws IllegalArgumentException {
        MCParticle ret = MAP.get(test);
        if (ret == null) {
            throw new IllegalArgumentException("Unknown particle type: " + test);
        }
        return ret;
    }

    public static Set<String> types() {
        if (NULL == null) {
            HashSet<String> dummy = new HashSet<String>();
            for (MCVanillaParticle t : MCVanillaParticle.values()) {
                dummy.add(t.name());
            }
            return dummy;
        }
        return MAP.keySet();
    }

    public static List<MCParticle> values() {
        if (NULL == null) {
            ArrayList<MCParticle> dummy = new ArrayList<MCParticle>();
            for (final MCVanillaParticle p2 : MCVanillaParticle.values()) {
                dummy.add(new MCParticle<Object>(p2, null){

                    @Override
                    public String name() {
                        return p2.name();
                    }

                    @Override
                    public String concreteName() {
                        return p2.name();
                    }
                });
            }
            return dummy;
        }
        return new ArrayList<MCParticle>(MAP.values());
    }

    public static enum MCVanillaParticle {
        EXPLOSION_NORMAL,
        EXPLOSION_LARGE,
        EXPLOSION_HUGE,
        FIREWORKS_SPARK,
        WATER_BUBBLE,
        WATER_SPLASH,
        WATER_WAKE,
        SUSPENDED,
        SUSPENDED_DEPTH,
        CRIT,
        CRIT_MAGIC,
        SMOKE_NORMAL,
        SMOKE_LARGE,
        SPELL,
        SPELL_INSTANT,
        SPELL_MOB,
        SPELL_MOB_AMBIENT,
        SPELL_WITCH,
        DRIP_WATER,
        DRIP_LAVA,
        VILLAGER_ANGRY,
        VILLAGER_HAPPY,
        TOWN_AURA,
        NOTE,
        PORTAL,
        ENCHANTMENT_TABLE,
        FLAME,
        LAVA,
        CLOUD,
        REDSTONE,
        SNOWBALL,
        SNOW_SHOVEL,
        SLIME,
        HEART,
        BARRIER,
        ITEM_CRACK,
        BLOCK_CRACK,
        BLOCK_DUST,
        WATER_DROP,
        MOB_APPEARANCE,
        DRAGON_BREATH,
        END_ROD,
        DAMAGE_INDICATOR,
        SWEEP_ATTACK,
        FALLING_DUST,
        TOTEM,
        SPIT,
        SQUID_INK,
        BUBBLE_POP,
        CURRENT_DOWN,
        BUBBLE_COLUMN_UP,
        NAUTILUS,
        DOLPHIN,
        SNEEZE(MCVersion.MC1_14),
        CAMPFIRE_COSY_SMOKE(MCVersion.MC1_14),
        CAMPFIRE_SIGNAL_SMOKE(MCVersion.MC1_14),
        COMPOSTER(MCVersion.MC1_14),
        FLASH(MCVersion.MC1_14),
        FALLING_LAVA(MCVersion.MC1_14),
        LANDING_LAVA(MCVersion.MC1_14),
        FALLING_WATER(MCVersion.MC1_14),
        UNKNOWN(MCVersion.NEVER);

        private final MCVersion since;

        private MCVanillaParticle() {
            this(MCVersion.MC1_0);
        }

        private MCVanillaParticle(MCVersion since) {
            this.since = since;
        }

        public boolean existsInCurrent() {
            return Static.getServer().getMinecraftVersion().gte(this.since);
        }
    }
}

