/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GenericTreeNode<T>
implements Cloneable {
    public T data;
    public List<GenericTreeNode<T>> children = new ArrayList<GenericTreeNode<T>>();
    public boolean optimized = false;

    public GenericTreeNode<T> clone() throws CloneNotSupportedException {
        GenericTreeNode clone = (GenericTreeNode)super.clone();
        Class<?> c = this.data.getClass();
        if (Arrays.asList(c.getInterfaces()).contains(Cloneable.class)) {
            try {
                Method m = c.getMethod("clone", new Class[0]);
                Object obj = m.invoke(this.data, new Object[0]);
                clone.data = obj;
                clone.children = new ArrayList<GenericTreeNode<T>>(this.children);
                clone.optimized = this.optimized;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException ex) {
                throw new CloneNotSupportedException();
            }
        }
        return clone;
    }

    public GenericTreeNode() {
    }

    public GenericTreeNode(T data) {
        this();
        this.setData(data);
    }

    public synchronized List<GenericTreeNode<T>> getChildren() {
        return this.children;
    }

    public int getNumberOfChildren() {
        return this.getChildren().size();
    }

    public boolean hasChildren() {
        return this.getNumberOfChildren() > 0;
    }

    public void setChildren(List<GenericTreeNode<T>> children) {
        this.children = children;
    }

    public void addChild(GenericTreeNode<T> child) {
        this.children.add(child);
    }

    public void addChildAt(int index, GenericTreeNode<T> child) throws IndexOutOfBoundsException {
        this.children.add(index, child);
    }

    public void removeChildren() {
        this.children = new ArrayList<GenericTreeNode<T>>();
    }

    public void removeChildAt(int index) throws IndexOutOfBoundsException {
        this.children.remove(index);
    }

    public GenericTreeNode<T> getChildAt(int index) throws IndexOutOfBoundsException {
        return this.children.get(index);
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String toString() {
        return this.getData().toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericTreeNode other = (GenericTreeNode)obj;
        return !(this.data == null ? other.data != null : !this.data.equals(other.data));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        return result;
    }

    public String toStringVerbose() {
        String stringRepresentation = this.getData().toString() + ":[";
        for (GenericTreeNode<T> node : this.getChildren()) {
            stringRepresentation = stringRepresentation + node.getData().toString() + ", ";
        }
        Pattern pattern = Pattern.compile(", $", 32);
        Matcher matcher = pattern.matcher(stringRepresentation);
        stringRepresentation = matcher.replaceFirst("");
        stringRepresentation = stringRepresentation + "]";
        return stringRepresentation;
    }
}

