/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

public interface Profiles {
    public Profile getProfileById(String var1) throws InvalidProfileException;

    public static class InvalidProfileException
    extends Exception {
        public InvalidProfileException() {
        }

        public InvalidProfileException(String message) {
            super(message);
        }

        public InvalidProfileException(String message, Throwable t) {
            super(message, t);
        }

        public InvalidProfileException(Throwable t) {
            super(t);
        }
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ProfileType {
        public String type();
    }

    public static abstract class Profile
    implements Comparable<Profile> {
        private final String id;

        protected Profile(String id) {
            this.id = id;
        }

        public String getID() {
            return this.id;
        }

        public String getType() {
            return this.getClass().getAnnotation(ProfileType.class).type();
        }

        @Override
        public int compareTo(Profile o) {
            return this.id.compareTo(o.id);
        }

        public String toString() {
            return (this.id == null ? "" : "(" + this.id + ") ") + this.getType();
        }
    }
}

