/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.compiler;

import com.laytonsmith.core.MethodScriptCompiler;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.CSlice;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.IVariable;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.constructs.Variable;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigCompileGroupException;
import java.io.File;
import java.util.List;
import java.util.Set;

public class OptimizationUtilities {
    public static void pullUpLikeFunctions(List<ParseTree> children, String functionName) {
        int size;
        for (int i = size = children.size() - 1; i >= 0; --i) {
            ParseTree tree = children.get(i);
            if (!(tree.getData() instanceof CFunction) || !tree.getData().val().equals(functionName)) continue;
            children.remove(i);
            for (int j = tree.getChildren().size() - 1; j >= 0; --j) {
                children.add(i, tree.getChildAt(j));
            }
        }
    }

    public static String optimize(String script, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, File source) throws ConfigCompileException, ConfigCompileGroupException {
        ParseTree tree = MethodScriptCompiler.compile(MethodScriptCompiler.lex(script, env, source, true), null, envs);
        StringBuilder b = new StringBuilder();
        for (ParseTree child : tree.getChildren()) {
            b.append(OptimizationUtilities.optimize0(child));
        }
        return b.toString();
    }

    private static String optimize0(ParseTree node) {
        if (node.getData() instanceof CFunction) {
            StringBuilder b = new StringBuilder();
            boolean first = true;
            b.append(((CFunction)node.getData()).val()).append("(");
            for (ParseTree child : node.getChildren()) {
                if (!first) {
                    b.append(",");
                }
                first = false;
                b.append(OptimizationUtilities.optimize0(child));
            }
            b.append(")");
            return b.toString();
        }
        if (node.getData() instanceof CString) {
            return "'" + node.getData().val().replaceAll("\t", "\\t").replaceAll("\n", "\\n").replace("\\", "\\\\").replace("'", "\\'") + "'";
        }
        if (node.getData() instanceof IVariable) {
            return ((IVariable)node.getData()).getVariableName();
        }
        if (node.getData() instanceof Variable) {
            return ((Variable)node.getData()).getVariableName();
        }
        if (node.getData() instanceof CSlice) {
            return node.getData().val();
        }
        if (node.getData().isInstanceOf(CArray.TYPE)) {
            StringBuilder b = new StringBuilder();
            b.append("array(");
            boolean first = true;
            CArray n = (CArray)node.getData();
            for (String key : n.stringKeySet()) {
                if (!first) {
                    b.append(",");
                }
                first = false;
                b.append(OptimizationUtilities.optimize0(new ParseTree(n.get(key, Target.UNKNOWN), node.getFileOptions())));
            }
            b.append(")");
            return b.toString();
        }
        return node.getData().toString();
    }
}

