/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.typeof;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.MethodScriptCompiler;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.constructs.Auto;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CClosure;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.IVariable;
import com.laytonsmith.core.constructs.InstanceofUtil;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.environments.GlobalEnv;
import com.laytonsmith.core.exceptions.CRE.AbstractCREException;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CancelCommandException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.exceptions.FunctionReturnException;
import com.laytonsmith.core.exceptions.LoopManipulationException;
import com.laytonsmith.core.exceptions.ProgramFlowManipulationException;
import com.laytonsmith.core.exceptions.StackTraceManager;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

@typeof(value="ms.lang.iclosure")
public class CIClosure
extends CClosure {
    public static final CClassType TYPE = CClassType.get(CIClosure.class);

    public CIClosure(ParseTree node, Environment env, CClassType returnType, String[] names, Mixed[] defaults, CClassType[] types, Target t) {
        super(node, env, returnType, names, defaults, types, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Mixed ... values) throws ConfigRuntimeException, ProgramFlowManipulationException, FunctionReturnException, CancelCommandException {
        if (this.node == null) {
            return;
        }
        StackTraceManager stManager = this.env.getEnv(GlobalEnv.class).GetStackTraceManager();
        stManager.addStackTraceElement(new ConfigRuntimeException.StackTraceElement("<<iclosure>>", this.getTarget()));
        try {
            Environment environment;
            CIClosure cIClosure = this;
            synchronized (cIClosure) {
                boolean prev = this.env.getEnv(GlobalEnv.class).getCloneVars();
                this.env.getEnv(GlobalEnv.class).setCloneVars(false);
                environment = this.env.clone();
                this.env.getEnv(GlobalEnv.class).setCloneVars(prev);
            }
            environment.getEnv(GlobalEnv.class).setCloneVars(true);
            if (values != null) {
                for (int i = 0; i < this.names.length; ++i) {
                    Mixed value;
                    String name = this.names[i];
                    try {
                        value = values[i];
                    }
                    catch (Exception e) {
                        value = this.defaults[i].clone();
                    }
                    environment.getEnv(GlobalEnv.class).GetVarList().set(new IVariable(this.types[i], name, value, this.getTarget(), environment));
                }
            }
            boolean hasArgumentsParam = false;
            for (String pName : this.names) {
                if (!pName.equals("@arguments")) continue;
                hasArgumentsParam = true;
                break;
            }
            if (!hasArgumentsParam) {
                CArray arguments = new CArray(this.node.getData().getTarget());
                if (values != null) {
                    for (Mixed value : values) {
                        arguments.push(value, this.node.getData().getTarget());
                    }
                }
                environment.getEnv(GlobalEnv.class).GetVarList().set(new IVariable(CArray.TYPE, "@arguments", arguments, this.node.getData().getTarget()));
            }
            ParseTree newNode = new ParseTree(new CFunction("g", this.getTarget()), this.node.getFileOptions());
            ArrayList<ParseTree> children = new ArrayList<ParseTree>();
            children.add(this.node);
            newNode.setChildren(children);
            try {
                MethodScriptCompiler.execute(newNode, environment, null, environment.getEnv(GlobalEnv.class).GetScript());
            }
            catch (LoopManipulationException e) {
                LoopManipulationException lme = e;
                Target t = lme.getTarget();
                ConfigRuntimeException.HandleUncaughtException(ConfigRuntimeException.CreateUncatchableException("A " + lme.getName() + "() bubbled up to the top of a closure, which is unexpected behavior.", t), environment);
            }
            catch (FunctionReturnException ex) {
                Mixed ret = ex.getReturn();
                if (!InstanceofUtil.isInstanceof(ret, this.returnType, environment)) {
                    throw new CRECastException("Expected closure to return a value of type " + this.returnType.val() + " but a value of type " + ret.typeof() + " was returned instead", ret.getTarget());
                }
                throw ex;
            }
            catch (CancelCommandException ex) {
            }
            catch (ConfigRuntimeException ex) {
                if (ex instanceof AbstractCREException) {
                    ((AbstractCREException)ex).freezeStackTraceElements(stManager);
                }
                throw ex;
            }
            finally {
                stManager.popStackTraceElement();
            }
            if (!this.returnType.equals(Auto.TYPE) && !this.returnType.equals(CVoid.TYPE)) {
                throw new CRECastException("Expecting closure to return a value of type " + this.returnType.val() + ", but no value was returned.", this.node.getTarget());
            }
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(CClosure.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public String docs() {
        return "An iclosure is an isolated scope closure. This is more efficient than a regular closure, but it doesn't allow for access of variables outside of the scope of the closure, other than values passed in.";
    }

    @Override
    public Version since() {
        return MSVersion.V3_3_1;
    }

    @Override
    public CClassType[] getSuperclasses() {
        return new CClassType[]{CClosure.TYPE};
    }

    @Override
    public CClassType[] getInterfaces() {
        return CClassType.EMPTY_CLASS_ARRAY;
    }
}

