/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs;

import com.laytonsmith.core.constructs.Target;
import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;

public class Token {
    public TType type;
    public String value;
    public final int lineNum;
    public final int column;
    public final File file;
    public final Target target;

    public Token(TType type, String value, Target t) {
        this.type = type;
        this.value = value;
        this.lineNum = t.line();
        this.file = t.file();
        this.column = t.col();
        this.target = t;
    }

    public String val() {
        return this.value;
    }

    public int hashCode() {
        int hash2 = 7;
        hash2 = 59 * hash2 + (this.type != null ? this.type.hashCode() : 0);
        hash2 = 59 * hash2 + (this.value != null ? this.value.hashCode() : 0);
        return hash2;
    }

    public boolean equals(Object o) {
        if (o instanceof Token) {
            Token t = (Token)o;
            return this.type.equals((Object)t.type) && this.value.equals(t.value);
        }
        return false;
    }

    public String toString() {
        if (this.type.equals((Object)TType.NEWLINE)) {
            return "newline";
        }
        if (this.type.equals((Object)TType.STRING)) {
            return "'" + this.value + "'";
        }
        return (Object)((Object)this.type) + ":" + this.value;
    }

    public String toSimpleString() {
        if (this.type.equals((Object)TType.STRING)) {
            return "'" + this.value + "'";
        }
        return this.value;
    }

    public String toOutputString() {
        if (this.type.equals((Object)TType.STRING)) {
            return this.value.replace("\\", "\\\\").replace("'", "\\'");
        }
        if (this.type.equals((Object)TType.SMART_STRING)) {
            return this.value.replace("\\", "\\\\").replace("\"", "\\\"");
        }
        return this.value;
    }

    public Target getTarget() {
        return this.target;
    }

    public static enum TType {
        UNKNOWN(TokenVariant.IDENTIFIER),
        LSQUARE_BRACKET(TokenVariant.SEPARATOR),
        RSQUARE_BRACKET(TokenVariant.SEPARATOR),
        OPT_VAR_ASSIGN(TokenVariant.SEPARATOR),
        ALIAS_END(TokenVariant.SEPARATOR),
        COMMA(TokenVariant.SEPARATOR),
        FUNC_NAME(new TokenVariant[0]),
        FUNC_START(TokenVariant.SEPARATOR),
        FUNC_END(TokenVariant.SEPARATOR),
        NEWLINE(TokenVariant.WHITESPACE),
        MULTILINE_START(TokenVariant.SEPARATOR),
        MULTILINE_END(TokenVariant.SEPARATOR),
        COMMENT(TokenVariant.COMMENT),
        SMART_COMMENT(TokenVariant.COMMENT),
        COMMAND(new TokenVariant[0]),
        SEPERATOR(TokenVariant.SEPARATOR),
        STRING(TokenVariant.IDENTIFIER, TokenVariant.ATOMIC_LIT),
        VARIABLE(TokenVariant.IDENTIFIER),
        IVARIABLE(TokenVariant.IDENTIFIER),
        FINAL_VAR(TokenVariant.IDENTIFIER),
        LIT(TokenVariant.IDENTIFIER, TokenVariant.ATOMIC_LIT),
        DOT(TokenVariant.IDENTIFIER),
        SMART_STRING(TokenVariant.IDENTIFIER, TokenVariant.ATOMIC_LIT),
        BARE_STRING(TokenVariant.IDENTIFIER, TokenVariant.ATOMIC_LIT),
        ROOT(new TokenVariant[0]),
        LABEL(TokenVariant.SEPARATOR),
        DEREFERENCE(new TokenVariant[0]),
        SLICE(new TokenVariant[0]),
        PLUS(TokenVariant.SYMBOL, TokenVariant.UNARY, TokenVariant.ADDITIVE, TokenVariant.PLUS_MINUS),
        MINUS(TokenVariant.SYMBOL, TokenVariant.UNARY, TokenVariant.ADDITIVE, TokenVariant.PLUS_MINUS),
        MULTIPLICATION(TokenVariant.SYMBOL, TokenVariant.MULTIPLICATIVE),
        DIVISION(TokenVariant.SYMBOL, TokenVariant.MULTIPLICATIVE),
        EQUALS(TokenVariant.SYMBOL, TokenVariant.EQUALITY),
        NOT_EQUALS(TokenVariant.SYMBOL, TokenVariant.EQUALITY),
        STRICT_EQUALS(TokenVariant.SYMBOL, TokenVariant.EQUALITY),
        STRICT_NOT_EQUALS(TokenVariant.SYMBOL, TokenVariant.EQUALITY),
        GT(TokenVariant.SYMBOL, TokenVariant.RELATIONAL),
        LT(TokenVariant.SYMBOL, TokenVariant.RELATIONAL),
        LTE(TokenVariant.SYMBOL, TokenVariant.RELATIONAL),
        GTE(TokenVariant.SYMBOL, TokenVariant.RELATIONAL),
        LOGICAL_AND(TokenVariant.SYMBOL, TokenVariant.LOGICAL_AND),
        LOGICAL_OR(TokenVariant.SYMBOL, TokenVariant.LOGICAL_OR),
        DEFAULT_AND(TokenVariant.SYMBOL, TokenVariant.DEFAULT_AND),
        DEFAULT_OR(TokenVariant.SYMBOL, TokenVariant.DEFAULT_OR),
        LOGICAL_NOT(TokenVariant.SYMBOL, TokenVariant.UNARY),
        INCREMENT(TokenVariant.SYMBOL, TokenVariant.POSTFIX, TokenVariant.UNARY),
        DECREMENT(TokenVariant.SYMBOL, TokenVariant.POSTFIX, TokenVariant.UNARY),
        MODULO(TokenVariant.SYMBOL, TokenVariant.MULTIPLICATIVE),
        CONCAT(TokenVariant.SYMBOL, TokenVariant.ADDITIVE),
        EXPONENTIAL(TokenVariant.SYMBOL, TokenVariant.EXPONENTIAL),
        WHITESPACE(TokenVariant.WHITESPACE),
        LCURLY_BRACKET(TokenVariant.SEPARATOR),
        RCURLY_BRACKET(TokenVariant.SEPARATOR),
        IDENTIFIER(new TokenVariant[0]),
        DOUBLE(TokenVariant.IDENTIFIER, TokenVariant.ATOMIC_LIT),
        INTEGER(TokenVariant.IDENTIFIER, TokenVariant.ATOMIC_LIT),
        CONST_START(new TokenVariant[0]),
        ASSIGNMENT(TokenVariant.ASSIGNMENT, TokenVariant.SYMBOL),
        PLUS_ASSIGNMENT(TokenVariant.ASSIGNMENT, TokenVariant.SYMBOL, TokenVariant.ADDITIVE, TokenVariant.PLUS_MINUS),
        MINUS_ASSIGNMENT(TokenVariant.ASSIGNMENT, TokenVariant.SYMBOL, TokenVariant.ADDITIVE, TokenVariant.PLUS_MINUS),
        MULTIPLICATION_ASSIGNMENT(TokenVariant.ASSIGNMENT, TokenVariant.SYMBOL, TokenVariant.MULTIPLICATIVE),
        DIVISION_ASSIGNMENT(TokenVariant.ASSIGNMENT, TokenVariant.SYMBOL, TokenVariant.MULTIPLICATIVE),
        CONCAT_ASSIGNMENT(TokenVariant.ASSIGNMENT, TokenVariant.SYMBOL, TokenVariant.ADDITIVE),
        SEMICOLON(TokenVariant.SEPARATOR),
        KEYWORD(TokenVariant.KEYWORD),
        FILE_OPTIONS_START(TokenVariant.SEPARATOR, TokenVariant.FILE_OPTION),
        FILE_OPTIONS_STRING(TokenVariant.FILE_OPTION),
        FILE_OPTIONS_END(TokenVariant.SEPARATOR, TokenVariant.FILE_OPTION),
        ANNOTATION(TokenVariant.COMMENT);

        private final Set<TokenVariant> variants = EnumSet.noneOf(TokenVariant.class);

        private TType(TokenVariant ... variants) {
            this.variants.addAll(Arrays.asList(variants));
        }

        public boolean isSymbol() {
            return this.variants.contains((Object)TokenVariant.SYMBOL);
        }

        public boolean isPostfix() {
            return this.variants.contains((Object)TokenVariant.POSTFIX);
        }

        public boolean isUnary() {
            return this.variants.contains((Object)TokenVariant.UNARY);
        }

        public boolean isMultaplicative() {
            return this.variants.contains((Object)TokenVariant.MULTIPLICATIVE);
        }

        public boolean isAdditive() {
            return this.variants.contains((Object)TokenVariant.ADDITIVE);
        }

        public boolean isRelational() {
            return this.variants.contains((Object)TokenVariant.RELATIONAL);
        }

        public boolean isEquality() {
            return this.variants.contains((Object)TokenVariant.EQUALITY);
        }

        public boolean isLogicalAnd() {
            return this.variants.contains((Object)TokenVariant.LOGICAL_AND);
        }

        public boolean isDefaultAnd() {
            return this.variants.contains((Object)TokenVariant.DEFAULT_AND);
        }

        public boolean isLogicalOr() {
            return this.variants.contains((Object)TokenVariant.LOGICAL_OR);
        }

        public boolean isDefaultOr() {
            return this.variants.contains((Object)TokenVariant.DEFAULT_OR);
        }

        public boolean isPlusMinus() {
            return this.variants.contains((Object)TokenVariant.PLUS_MINUS);
        }

        public boolean isIdentifier() {
            return this.variants.contains((Object)TokenVariant.IDENTIFIER);
        }

        public boolean isExponential() {
            return this.variants.contains((Object)TokenVariant.EXPONENTIAL);
        }

        public boolean isAssignment() {
            return this.variants.contains((Object)TokenVariant.ASSIGNMENT);
        }

        public boolean isSeparator() {
            return this.variants.contains((Object)TokenVariant.SEPARATOR);
        }

        public boolean isAtomicLit() {
            return this.variants.contains((Object)TokenVariant.ATOMIC_LIT);
        }

        public boolean isWhitespace() {
            return this.variants.contains((Object)TokenVariant.WHITESPACE);
        }

        public boolean isKeyword() {
            return this.variants.contains((Object)TokenVariant.KEYWORD);
        }

        public boolean isComment() {
            return this.variants.contains((Object)TokenVariant.COMMENT);
        }

        public boolean isFileOption() {
            return this.variants.contains((Object)TokenVariant.FILE_OPTION);
        }
    }

    private static enum TokenVariant {
        ADDITIVE,
        EQUALITY,
        EXPONENTIAL,
        IDENTIFIER,
        LOGICAL_AND,
        LOGICAL_OR,
        DEFAULT_AND,
        DEFAULT_OR,
        MULTIPLICATIVE,
        PLUS_MINUS,
        POSTFIX,
        RELATIONAL,
        SYMBOL,
        UNARY,
        ASSIGNMENT,
        SEPARATOR,
        ATOMIC_LIT,
        WHITESPACE,
        KEYWORD,
        COMMENT,
        FILE_OPTION;

    }
}

