/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.federation;

import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.core.federation.FederationCommunication;
import com.laytonsmith.core.federation.FederationVersion;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FederationConnection {
    private static final String VERSION = FederationVersion.V1_0_0.getVersionString();
    private final String serverName;
    private final String host;
    private final int masterPort;
    private final int timeout;
    private final String password;
    private Socket socket;
    private final Object socketLock = new Object();
    private long lastUpdated;
    private boolean closed = false;
    private final boolean isEncrypted;
    private FederationCommunication communicator;

    public FederationConnection(String serverName, String host, int masterPort, int timeout, String password) {
        this.serverName = serverName;
        this.host = host;
        this.masterPort = masterPort;
        this.timeout = timeout;
        this.password = password;
        this.isEncrypted = false;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void writeLine(String line) throws IOException {
        this.ensureConnected();
        this.communicator.writeLine(line);
    }

    public String readLine() throws IOException {
        this.ensureConnected();
        return this.communicator.readLine();
    }

    public void writeBytes(byte[] bytes) throws IOException {
        this.ensureConnected();
        this.communicator.writeBytes(bytes);
    }

    public byte[] readBytes(int size) throws IOException {
        this.ensureConnected();
        return this.communicator.readBytes(size);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void ensureConnected() throws IOException, SocketTimeoutException {
        if (this.socket == null || !this.socket.isConnected()) {
            block46: {
                masterSocket = new Socket();
                masterSocket.connect(new InetSocketAddress(this.host, this.masterPort), this.timeout);
                port = -1;
                reader = new BufferedReader(new InputStreamReader(masterSocket.getInputStream(), "UTF-8"));
                var4_4 = null;
                try {
                    out = new PrintWriter(masterSocket.getOutputStream(), true);
                    var6_9 = null;
                    try {
                        out.println("HELLO");
                        out.println(FederationConnection.VERSION);
                        versionOK = reader.readLine();
                        if (!"VERSION OK".equals(versionOK)) {
                            errorMsgSize = Integer.parseInt(reader.readLine());
                            errorMsg = new byte[errorMsgSize];
                            masterSocket.getInputStream().read(errorMsg);
                            sErrorMsg = new String(errorMsg, "UTF-8");
                            throw new IOException(sErrorMsg);
                        }
                        out.println("GET PORT");
                        out.println(this.serverName);
                        portOK = reader.readLine();
                        if (null == portOK) break block46;
                        var9_18 = portOK;
                        var10_20 = -1;
                        switch (var9_18.hashCode()) {
                            case 2524: {
                                if (!var9_18.equals("OK")) break;
                                var10_20 = 0;
                                break;
                            }
                            case 66247144: {
                                if (!var9_18.equals("ERROR")) break;
                                var10_20 = 1;
                            }
                        }
                        switch (var10_20) {
                            case 0: {
                                try {
                                    port = Integer.parseInt(reader.readLine());
                                    ** break;
lbl40:
                                    // 1 sources

                                }
                                catch (NumberFormatException var11_21) {
                                    ** break;
                                }
lbl43:
                                // 1 sources

                                break;
                            }
                            case 1: {
                                errorMsgSize = Integer.parseInt(reader.readLine());
                                errorMsg = new byte[errorMsgSize];
                                masterSocket.getInputStream().read(errorMsg);
                                sErrorMsg = new String(errorMsg, "UTF-8");
                                throw new IOException(sErrorMsg);
                            }
                            ** default:
lbl52:
                            // 1 sources

                            break;
                        }
                    }
                    catch (Throwable versionOK) {
                        var6_9 = versionOK;
                        throw versionOK;
                    }
                    finally {
                        if (out != null) {
                            if (var6_9 != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable versionOK) {
                                    var6_9.addSuppressed(versionOK);
                                }
                            } else {
                                out.close();
                            }
                        }
                    }
                }
                catch (Throwable out) {
                    var4_4 = out;
                    throw out;
                }
                finally {
                    if (reader != null) {
                        if (var4_4 != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable out) {
                                var4_4.addSuppressed(out);
                            }
                        } else {
                            reader.close();
                        }
                    }
                }
            }
            this.socket = new Socket();
            this.socket.connect(new InetSocketAddress(this.host, port), this.timeout);
            this.communicator = new FederationCommunication(new BufferedInputStream(this.socket.getInputStream()), new BufferedOutputStream(this.socket.getOutputStream()));
            this.communicator.writeUnencryptedLine("HELLO");
            this.communicator.writeUnencryptedLine(FederationConnection.VERSION);
            versionOK = this.communicator.readLine();
            if (!"VERSION OK".equals(versionOK)) {
                errorMsgSize = Integer.parseInt(this.communicator.readLine());
                errorMsg = new String(this.communicator.readBytes(errorMsgSize), "UTF-8");
                throw new IOException(errorMsg);
            }
            this.communicator.writeUnencryptedLine(this.isEncrypted != false ? "1" : "0");
            this.communicator.writeLine(this.password == null ? "" : this.password);
            response = this.communicator.readLine();
            if (null != response) {
                var5_6 = response;
                var6_10 = -1;
                switch (var5_6.hashCode()) {
                    case 2524: {
                        if (!var5_6.equals("OK")) break;
                        var6_10 = 0;
                        break;
                    }
                    case 66247144: {
                        if (!var5_6.equals("ERROR")) break;
                        var6_10 = 1;
                    }
                }
                switch (var6_10) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        errorMsgSize = Integer.parseInt(this.communicator.readLine());
                        errorMsg = new String(this.communicator.readBytes(errorMsgSize), "UTF-8");
                        throw new IOException(errorMsg);
                    }
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.closed) {
            StreamUtils.GetSystemErr().println("FederationConnection was not closed properly, and cleanup is having to be done in the finalize method!");
            this.closeSocket();
        }
    }

    public void closeSocket() {
        try {
            if (this.communicator != null) {
                this.communicator.close();
            }
            this.socket.close();
        }
        catch (IOException ex) {
            Logger.getLogger(FederationConnection.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.socket = null;
        this.closed = true;
    }

    public Object getSocketLock() {
        return this.socketLock;
    }

    public boolean closeIfInactive(long ms) {
        if (this.lastUpdated < System.currentTimeMillis() - ms) {
            return false;
        }
        this.closeSocket();
        return false;
    }

    private void updateLastUpdated() {
        this.lastUpdated = System.currentTimeMillis();
    }
}

