/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core;

import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.SimpleDocumentation;
import com.laytonsmith.core.compiler.FileOptions;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.functions.Function;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.List;
import java.util.Set;

public interface Optimizable
extends Function {
    public static final ParseTree REMOVE_ME = new ParseTree(null);
    public static final ParseTree PULL_ME_UP = new ParseTree(null);

    public Set<OptimizationOption> optimizationOptions();

    public Mixed optimize(Target var1, Environment var2, Mixed ... var3) throws ConfigRuntimeException, ConfigCompileException;

    public ParseTree optimizeDynamic(Target var1, Environment var2, Set<Class<? extends Environment.EnvironmentImpl>> var3, List<ParseTree> var4, FileOptions var5) throws ConfigCompileException, ConfigRuntimeException;

    public void link(Target var1, List<ParseTree> var2) throws ConfigCompileException;

    public static enum OptimizationOption implements SimpleDocumentation
    {
        CONSTANT_OFFLINE("If all the parameters of a function are constant, a function with this optimization will be run at compile time, and that value stored, instead of it being run each time. For instance, the add function is like this, which means that if you were to do add(2, 2), it would simply replace that call with 4, at compile time, which makes it more efficient during runtime.", MSVersion.V3_3_1),
        INSTANT_RETURN("Some functions can be run async, and there is no benefit for it to wait around for the operation to finish. For instance, using sys_out() does not need to wait for the IO to flush before returning control to the script.", MSVersion.V3_3_1),
        OPTIMIZE_CONSTANT("A function may be able to do some optimization if the parameters are constant, but it may be a bit more complicated than simply running the function. Otherwise, this is exactly like " + CONSTANT_OFFLINE.getName(), MSVersion.V3_3_1),
        OPTIMIZE_DYNAMIC("Some functions can do some amount of optimization or compilation checks, even if the function is sent dynamic parameters. For instance, if(true, rand(), '1') can be changed simply to rand(), because the condition is hard coded to be true. In this case, the compile tree is smaller, which makes it more efficient.", MSVersion.V3_3_1),
        CACHE_RETURN("If a function is able to optimize out constant inputs, it can likely also cache the return value. If the engine determines that it is faster to cache the returned values vs re-running the function, it may choose to do so. This is a runtime optimization, and is calculated by the engine itself to determine which method is faster, so there is no guarantee that any optimization will occur, however, unless this option is specified, it will certainly not.", MSVersion.V3_3_1),
        TERMINAL("If a function is \"terminal\", that is, it is guaranteed to have abnormal code flow (for instance, return() or throw()) it is marked terminal, which is used by the compiler to issue warnings, in the event you make some code unreachable by putting it under a terminal statement, and to optimize by removing the unreachable code from the code tree.", MSVersion.V3_3_1),
        NO_SIDE_EFFECTS("If a function is \"side effect free\", that is, if the return value is unused, the function itself does nothing, then this optimization can be specified. This is mostly useful for cases where the value returns a check, but the check has been determined by the compiler to be unused, making the entire call itself unneeded, allowing the call itself to be removed from the tree.", MSVersion.V3_3_1),
        CUSTOM_LINK("Some functions do want to do linking, but in a special, custom way. If this is specified, then the function will have the link() method called on it, in place of the default linking mechanism that the compiler provides.", MSVersion.V3_3_1),
        PRIORITY_OPTIMIZATION("This is a priority optimization function, meaning it needs to be optimized before its children are. This is required when optimization of the children could cause different internal behavior, for instance if this function is expecting the presence of some code element, but the child gets optimized out, this would cause an error, even though the user did in fact provide code in that section.", MSVersion.V3_3_1);

        private final MSVersion since;
        private final String docs;

        private OptimizationOption(String docs, MSVersion since) {
            this.docs = docs;
            this.since = since;
        }

        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public String docs() {
            return this.docs;
        }

        @Override
        public MSVersion since() {
            return this.since;
        }
    }
}

