/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.compiler;

import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AliasCompiler {
    public static void main(String[] args) throws Exception {
        List<AliasToken> list = new AliasLexer("/c /* = */ = /** hi */ code", null).parse();
        StreamUtils.GetSystemOut().println(list);
    }

    public static List<AliasToken> lex(String script, File file) throws ConfigCompileException {
        return new AliasLexer(script, file).parse();
    }

    public static enum AliasTokenType {
        UNKNOWN,
        VARIABLE,
        OPTIONAL_START,
        OPTIONAL_END,
        ASSIGN,
        LABEL,
        LIT,
        DEFINITION_END,
        ALIAS_END,
        CODE,
        DOCBLOCK;

    }

    public static class AliasToken {
        private final String token;
        private final AliasTokenType type;
        private final Target t;

        public AliasToken(String token, AliasTokenType type, Target t) {
            this.token = token;
            this.type = type;
            this.t = t;
        }

        public String toString() {
            return "(" + this.type.name() + ") " + this.token;
        }
    }

    public static class Alias {
    }

    private static class AliasLexer {
        private final String script;
        private final File file;
        private List<AliasToken> tokens;
        private StringBuilder buf = new StringBuilder();
        private Target t;
        private boolean pastLabel;
        private boolean pastDefinitionStart;
        private boolean inVariable;
        private boolean inQuote;
        private boolean inSingleString;
        private boolean inDoubleString;
        private boolean inOptionalVariable;
        private boolean inAliasCode;
        private boolean pastMultiline;
        private boolean inMultiline;
        private boolean isNewStyleMultiline;
        private boolean inComment;
        private boolean inLineComment;
        private boolean inMultilineComment;
        private boolean inDocBlockComment;
        private static final Pattern LIT_PATTERN = Pattern.compile("([\\[\\]=:\\$])");

        public AliasLexer(String script, File file) {
            if (script.charAt(0) == '\ufeff') {
                script = script.substring(1);
            }
            script = script.replaceAll("\r\n", "\n");
            this.script = script = script + "\n";
            this.file = file;
        }

        public List<AliasToken> parse() throws ConfigCompileException {
            if (this.tokens == null) {
                this.doParse();
            }
            return this.tokens;
        }

        private void doParse() throws ConfigCompileException {
            this.tokens = new ArrayList<AliasToken>();
            int line = 1;
            int col = 0;
            Target singleQuoteStart = Target.UNKNOWN;
            Target doubleQuoteStart = Target.UNKNOWN;
            Target multilineCommentStart = Target.UNKNOWN;
            Target optionalVariableStart = Target.UNKNOWN;
            for (int i = 0; i < this.script.length(); ++i) {
                ++col;
                Character c = Character.valueOf(this.script.charAt(i));
                Character c2 = null;
                Character c3 = null;
                Character c4 = null;
                if (i < this.script.length() - 1) {
                    c2 = Character.valueOf(this.script.charAt(i + 1));
                }
                if (i < this.script.length() - 2) {
                    c3 = Character.valueOf(this.script.charAt(i + 2));
                }
                if (i < this.script.length() - 3) {
                    c4 = Character.valueOf(this.script.charAt(i + 3));
                }
                this.t = new Target(line, this.file, col);
                if (!(this.pastDefinitionStart || this.inComment || this.inAliasCode)) {
                    if (c.charValue() == '\n' || Character.isWhitespace(c.charValue())) continue;
                    this.pastLabel = c.charValue() == '/' || c.charValue() == '\'' || c.charValue() == '\"';
                    this.pastDefinitionStart = true;
                }
                if (this.inLineComment) {
                    if (c.charValue() == '\n') {
                        this.inLineComment = false;
                        this.inComment = false;
                    }
                    if (!this.inAliasCode) continue;
                }
                if (this.inMultilineComment) {
                    if (c.charValue() == '*' && c2.charValue() == '/') {
                        boolean wasDocBlock = this.inDocBlockComment;
                        this.inComment = false;
                        this.inDocBlockComment = false;
                        this.inMultilineComment = false;
                        if (!this.inAliasCode) {
                            if (wasDocBlock) {
                                this.buffer(AliasTokenType.DOCBLOCK, this.t);
                            }
                            ++i;
                            continue;
                        }
                    }
                    if (!this.inDocBlockComment && !this.inAliasCode) continue;
                    this.buf.append(c);
                    continue;
                }
                if (this.inQuote && c.charValue() == '\\' && (c2.charValue() == '\'' || c2.charValue() == '\"')) {
                    this.buf.append(c2);
                    ++i;
                    continue;
                }
                boolean skipProcessing = false;
                if (!this.inComment) {
                    if (c.charValue() == '\'' && this.inSingleString) {
                        this.inQuote = false;
                        this.inSingleString = false;
                        if (!this.inAliasCode) {
                            if (!this.inOptionalVariable) {
                                this.validateLit(this.buf.toString());
                            }
                            this.buffer(AliasTokenType.LIT, this.t);
                            continue;
                        }
                        skipProcessing = true;
                    }
                    if (c.charValue() == '\"' && this.inDoubleString) {
                        this.inQuote = false;
                        this.inDoubleString = false;
                        if (!this.inAliasCode) {
                            if (!this.inOptionalVariable) {
                                this.validateLit(this.buf.toString());
                            }
                            this.buffer(AliasTokenType.LIT, this.t);
                            continue;
                        }
                        skipProcessing = true;
                    }
                    if (!skipProcessing) {
                        if (c.charValue() == '\'' && !this.inQuote) {
                            this.inQuote = true;
                            this.inSingleString = true;
                            singleQuoteStart = this.t;
                            if (!this.inAliasCode) continue;
                        }
                        if (c.charValue() == '\"' && !this.inQuote) {
                            this.inQuote = true;
                            this.inDoubleString = true;
                            doubleQuoteStart = this.t;
                            if (!this.inAliasCode) continue;
                        }
                    }
                    if (this.inQuote && !this.inAliasCode) {
                        this.buf.append(c);
                        continue;
                    }
                }
                if (c.charValue() == '#' || c.charValue() == '/' && c2.charValue() == '/' && !this.inQuote) {
                    this.inComment = true;
                    this.inLineComment = true;
                    if (!this.inAliasCode) {
                        this.endToken();
                        if (c.charValue() != '/') continue;
                        ++i;
                        continue;
                    }
                }
                if (c.charValue() == '/' && c2.charValue() == '*' && !this.inQuote) {
                    int skip = 1;
                    this.inComment = true;
                    this.inMultilineComment = true;
                    multilineCommentStart = this.t;
                    if (c3.charValue() == '*') {
                        ++skip;
                        this.inDocBlockComment = true;
                    }
                    if (!this.inAliasCode) {
                        this.endToken();
                        i += skip;
                        continue;
                    }
                }
                if (c.charValue() == ':') {
                    if (this.pastLabel) {
                        throw new ConfigCompileException("Unexpected symbol \":\", this may only be used as the command label.", this.t);
                    }
                    this.pastLabel = true;
                    this.buffer(AliasTokenType.LABEL, this.t);
                    continue;
                }
                if (!this.pastLabel) {
                    if (Character.isWhitespace(c.charValue())) continue;
                    this.buf.append(c);
                    continue;
                }
                if (this.inAliasCode) {
                    if (!this.pastMultiline && Character.isWhitespace(c.charValue()) && c.charValue() != '\n') continue;
                    if (this.pastMultiline) {
                        if (!this.inMultiline) {
                            if (c.charValue() == '\n') {
                                this.buffer(AliasTokenType.CODE, this.t);
                                this.buffer(AliasTokenType.ALIAS_END, this.t);
                                this.resetStates();
                                continue;
                            }
                        } else if (!this.inQuote && !this.inComment) {
                            if (c.charValue() == '<' && c2.charValue() == '<' && c3.charValue() == '<') {
                                if (this.isNewStyleMultiline) {
                                    throw new ConfigCompileException("Unexpected multiline end symbol type, expected \"?>\" but found \"<<<\"", this.t);
                                }
                                i += 2;
                                this.buffer(AliasTokenType.CODE, this.t);
                                this.buffer(AliasTokenType.ALIAS_END, this.t);
                                this.resetStates();
                                continue;
                            }
                            if (c.charValue() == '?' && c2.charValue() == '>') {
                                if (!this.isNewStyleMultiline) {
                                    throw new ConfigCompileException("Unexpected multiline end symbol type, expected \"<<<\" but found \"?>\"", this.t);
                                }
                                ++i;
                                this.buffer(AliasTokenType.CODE, this.t);
                                this.buffer(AliasTokenType.ALIAS_END, this.t);
                                this.resetStates();
                                continue;
                            }
                        }
                        this.buf.append(c);
                        continue;
                    }
                    if (!this.pastMultiline) {
                        if (c.charValue() == '>' && c2.charValue() == '>' && c3.charValue() == '>') {
                            this.isNewStyleMultiline = false;
                            this.inMultiline = true;
                            i += 2;
                            this.pastMultiline = true;
                            continue;
                        }
                        if (c.charValue() == '<' && c2.charValue() == '?' && c3.charValue() == 'm' && c4.charValue() == 's') {
                            this.isNewStyleMultiline = true;
                            this.inMultiline = true;
                            i += 3;
                            this.pastMultiline = true;
                            continue;
                        }
                        if (c.charValue() == '<' && c2.charValue() == '<' && c3.charValue() == '<' || c.charValue() == '?' && c2.charValue() == '>') {
                            throw new ConfigCompileException("Unexpected multiline end symbol", this.t);
                        }
                        this.buf.append(c);
                        this.pastMultiline = true;
                        continue;
                    }
                }
                if (Character.isWhitespace(c.charValue()) && !this.inQuote && c.charValue() != '\n') {
                    this.endToken();
                    continue;
                }
                if (c.charValue() == '$' && this.buf.length() == 0) {
                    this.inVariable = true;
                }
                if (c.charValue() == '[') {
                    if (this.inOptionalVariable) {
                        throw new ConfigCompileException("Unexpected left bracket", this.t);
                    }
                    this.endToken();
                    this.inOptionalVariable = true;
                    optionalVariableStart = this.t;
                    this.buf.append('[');
                    this.buffer(AliasTokenType.OPTIONAL_START, this.t);
                    continue;
                }
                if (c.charValue() == ']') {
                    if (!this.inOptionalVariable) {
                        throw new ConfigCompileException("Unexpected right bracket", this.t);
                    }
                    this.endToken();
                    this.buf.append(']');
                    this.inOptionalVariable = false;
                    this.buffer(AliasTokenType.OPTIONAL_END, this.t);
                    continue;
                }
                if (c.charValue() == '=') {
                    this.endToken();
                    this.buf.append('=');
                    if (this.inOptionalVariable) {
                        this.buffer(AliasTokenType.ASSIGN, this.t);
                        continue;
                    }
                    this.buffer(AliasTokenType.DEFINITION_END, this.t);
                    this.inAliasCode = true;
                    this.pastMultiline = false;
                    continue;
                }
                if (!this.inQuote && c.charValue() == '\n') {
                    this.endToken();
                    this.buffer(AliasTokenType.ALIAS_END, this.t);
                    continue;
                }
                this.buf.append(c);
            }
            if (this.inSingleString) {
                throw new ConfigCompileException("Unended string", singleQuoteStart);
            }
            if (this.inDoubleString) {
                throw new ConfigCompileException("Unended string", doubleQuoteStart);
            }
            if (this.inMultilineComment) {
                throw new ConfigCompileException("Unended block comment", multilineCommentStart);
            }
            if (this.inOptionalVariable) {
                throw new ConfigCompileException("Unended optional variable", optionalVariableStart);
            }
            this.endToken();
        }

        private void resetStates() {
            this.inDocBlockComment = false;
            this.inMultilineComment = false;
            this.inLineComment = false;
            this.inComment = false;
            this.inQuote = false;
            this.pastMultiline = false;
            this.pastLabel = false;
            this.pastDefinitionStart = false;
            this.isNewStyleMultiline = false;
            this.inVariable = false;
            this.inSingleString = false;
            this.inOptionalVariable = false;
            this.inMultiline = false;
            this.inDoubleString = false;
            this.inAliasCode = false;
        }

        private void validateLit(String lit) throws ConfigCompileException {
            if (lit.contains(" ") || lit.contains("\t") || lit.contains("\n")) {
                throw new ConfigCompileException("Alias literals cannot contain whitespace", this.t);
            }
        }

        private void endToken() throws ConfigCompileException {
            if (this.buf.length() == 0) {
                return;
            }
            if (this.inVariable) {
                String var = this.buf.toString();
                if (!var.matches("^\\$[a-zA-Z0-9_]*$")) {
                    throw new ConfigCompileException("Invalid variable name", this.t);
                }
                this.buffer(AliasTokenType.VARIABLE, this.t);
                this.inVariable = false;
                return;
            }
            Matcher m = LIT_PATTERN.matcher(this.buf.toString());
            if (m.find()) {
                throw new ConfigCompileException("Unexpected symbol \"" + m.group(1) + "\" in alias definition (you may quote strings in the definition)", this.t);
            }
            this.buffer(AliasTokenType.LIT, this.t);
        }

        private void buffer(AliasTokenType type, Target t) {
            Target myTarget = new Target(t.line(), t.file(), t.col() - this.buf.toString().length());
            this.tokens.add(new AliasToken(this.buf.toString(), type, myTarget));
            this.buf = new StringBuilder();
        }
    }
}

